/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.client.mod.particle;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDD)V", "Lnet/minecraft/client/particle/ParticleRenderType;", "getRenderType", "()Lnet/minecraft/client/particle/ParticleRenderType;", "", "tick", "()V", "onDiedByAge", "updateVelocity", "Dripping", "Falling", "Landing", "IFR25KU-common_client"})
public class HaimeviskaSapParticle
extends TextureSheetParticle {
    public HaimeviskaSapParticle(@NotNull ClientLevel world, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.setColor(1.0f, 0.62352943f, 0.19607843f);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_OPAQUE");
        return particleRenderType;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        int n = this.lifetime;
        this.lifetime = n + -1;
        if (this.lifetime <= 0) {
            this.remove();
            this.onDiedByAge();
        }
        if (this.removed) {
            return;
        }
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.updateVelocity();
        if (this.removed) {
            return;
        }
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
    }

    public void onDiedByAge() {
    }

    public void updateVelocity() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle$Dripping;", "Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "Lnet/minecraft/client/particle/SpriteSet;", "spriteProvider", "Lnet/minecraft/core/particles/ParticleOptions;", "particleEffect", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDLnet/minecraft/client/particle/SpriteSet;Lnet/minecraft/core/particles/ParticleOptions;)V", "", "onDiedByAge", "()V", "updateVelocity", "Lnet/minecraft/core/particles/ParticleOptions;", "IFR25KU-common_client"})
    public static final class Dripping
    extends HaimeviskaSapParticle {
        @NotNull
        private final ParticleOptions particleEffect;

        public Dripping(@NotNull ClientLevel world, double x, double y, double z, @NotNull SpriteSet spriteProvider, @NotNull ParticleOptions particleEffect) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)spriteProvider, (String)"spriteProvider");
            Intrinsics.checkNotNullParameter((Object)particleEffect, (String)"particleEffect");
            super(world, x, y, z);
            this.particleEffect = particleEffect;
            this.pickSprite(spriteProvider);
            this.gravity *= 0.01f;
            this.lifetime = 100;
        }

        @Override
        public void onDiedByAge() {
            this.level.addParticle(this.particleEffect, this.x, this.y, this.z, this.xd, this.yd, this.zd);
        }

        @Override
        public void updateVelocity() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle$Falling;", "Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "Lnet/minecraft/client/particle/SpriteSet;", "spriteProvider", "Lnet/minecraft/core/particles/ParticleOptions;", "particleEffect", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDLnet/minecraft/client/particle/SpriteSet;Lnet/minecraft/core/particles/ParticleOptions;)V", "", "updateVelocity", "()V", "Lnet/minecraft/core/particles/ParticleOptions;", "IFR25KU-common_client"})
    public static final class Falling
    extends HaimeviskaSapParticle {
        @NotNull
        private final ParticleOptions particleEffect;

        public Falling(@NotNull ClientLevel world, double x, double y, double z, @NotNull SpriteSet spriteProvider, @NotNull ParticleOptions particleEffect) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)spriteProvider, (String)"spriteProvider");
            Intrinsics.checkNotNullParameter((Object)particleEffect, (String)"particleEffect");
            super(world, x, y, z);
            this.particleEffect = particleEffect;
            this.pickSprite(spriteProvider);
            this.gravity = 0.01f;
            this.lifetime = (int)(64.0 / (world.random.nextDouble() * 0.8 + 0.2));
        }

        @Override
        public void updateVelocity() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.particleEffect, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.BEEHIVE_DRIP, SoundSource.BLOCKS, 0.3f + 0.7f * this.level.random.nextFloat(), 1.0f, false);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle$Landing;", "Lmiragefairy2024/client/mod/particle/HaimeviskaSapParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "Lnet/minecraft/client/particle/SpriteSet;", "spriteProvider", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDLnet/minecraft/client/particle/SpriteSet;)V", "IFR25KU-common_client"})
    public static final class Landing
    extends HaimeviskaSapParticle {
        public Landing(@NotNull ClientLevel world, double x, double y, double z, @NotNull SpriteSet spriteProvider) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)spriteProvider, (String)"spriteProvider");
            super(world, x, y, z);
            this.pickSprite(spriteProvider);
            this.lifetime = (int)(128.0 / (world.random.nextDouble() * 0.8 + 0.2));
        }
    }
}

