/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import miragefairy2024.mod.BagCard;
import miragefairy2024.mod.BagInventory;
import miragefairy2024.mod.BagModuleKt;
import miragefairy2024.util.InventoryKt;
import miragefairy2024.util.ItemStackKt;
import miragefairy2024.util.MergeResult;
import miragefairy2024.util.TextScope;
import miragefairy2024.util.TextScopeKt;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ-\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J/\u0010+\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b+\u0010,J?\u00100\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00106\u001a\u00020\u00132\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u00107R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lmiragefairy2024/mod/BagItem;", "Lnet/minecraft/world/item/Item;", "Lmiragefairy2024/mod/BagCard;", "card", "Lnet/minecraft/world/item/Item$Properties;", "settings", "<init>", "(Lmiragefairy2024/mod/BagCard;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/network/chat/Component;", "getName", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/world/item/Item$TooltipContext;", "context", "", "tooltipComponents", "Lnet/minecraft/world/item/TooltipFlag;", "tooltipFlag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "", "isBarVisible", "(Lnet/minecraft/world/item/ItemStack;)Z", "", "getBarWidth", "(Lnet/minecraft/world/item/ItemStack;)I", "getBarColor", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/inventory/Slot;", "slot", "Lnet/minecraft/world/inventory/ClickAction;", "clickType", "player", "overrideStackedOnOther", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;)Z", "otherStack", "Lnet/minecraft/world/entity/SlotAccess;", "cursorStackReference", "overrideOtherStackedOnMe", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/SlotAccess;)Z", "canFitInsideContainerItems", "()Z", "Lnet/minecraft/world/entity/item/ItemEntity;", "entity", "onDestroyed", "(Lnet/minecraft/world/entity/item/ItemEntity;)V", "Lmiragefairy2024/mod/BagCard;", "getCard", "()Lmiragefairy2024/mod/BagCard;", "IFR25KU-common"})
@SourceDebugExtension(value={"SMAP\nBagModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BagModule.kt\nmiragefairy2024/mod/BagItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TextScope.kt\nmiragefairy2024/util/TextScopeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1782#2,4:398\n774#2:403\n865#2,2:404\n1485#2:406\n1510#2,3:407\n1513#2,3:417\n1863#2:425\n1864#2:428\n1782#2,4:430\n1782#2,4:434\n1782#2,4:438\n1863#2,2:442\n8#3:402\n8#3:426\n8#3:427\n8#3:429\n381#4,7:410\n126#5:420\n153#5,2:421\n155#5:424\n1#6:423\n*S KotlinDebug\n*F\n+ 1 BagModule.kt\nmiragefairy2024/mod/BagItem\n*L\n172#1:398,4\n183#1:403\n183#1:404,2\n184#1:406\n184#1:407,3\n184#1:417,3\n186#1:425\n186#1:428\n201#1:430,4\n207#1:434,4\n213#1:438,4\n305#1:442,2\n173#1:402\n191#1:426\n193#1:427\n196#1:429\n184#1:410,7\n185#1:420\n185#1:421,2\n185#1:424\n*E\n"})
public final class BagItem
extends Item {
    @NotNull
    private final BagCard card;

    public BagItem(@NotNull BagCard card, @NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)card), (String)"card");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.card = card;
    }

    @NotNull
    public final BagCard getCard() {
        return this.card;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            Component component = super.getName(stack);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
            return component;
        }
        BagInventory bagInventory2 = bagInventory;
        Iterable $this$count$iv = InventoryKt.getItemStacks((Container)bagInventory2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!ItemStackKt.isNotEmpty(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        boolean $i$f$text = false;
        TextScope $this$getName_u24lambda_u241 = TextScope.INSTANCE;
        boolean bl = false;
        Component component = super.getName(stack);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        return TextScopeKt.plus($this$getName_u24lambda_u241, component, count > 0 ? TextScopeKt.invoke($this$getName_u24lambda_u241, " (" + count + " / " + this.card.getInventorySize() + ")") : TextScopeKt.invoke($this$getName_u24lambda_u241, ""));
    }

    /*
     * WARNING - void declaration
     */
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context2, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        boolean bl;
        ItemStack it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context2, tooltipComponents, tooltipFlag);
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return;
        }
        BagInventory inventory = bagInventory;
        boolean first = false;
        first = true;
        int itemCount = 0;
        Iterable iterable = InventoryKt.getItemStacks((Container)inventory);
        boolean $i$f$filter = false;
        void var10_11 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (ItemStack)t;
            bl = false;
            if (!ItemStackKt.isNotEmpty(it)) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (ItemStack)t;
            bl = false;
            key$iv$iv = it.getHoverName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            int n;
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            key$iv$iv = (Iterable)it.getValue();
            $this$getOrPut$iv$iv$iv = it.getKey();
            int n2 = 0;
            Iterator iterator = key$iv$iv.iterator();
            while (iterator.hasNext()) {
                void itemStack;
                Object t = iterator.next();
                ItemStack itemStack2 = (ItemStack)t;
                n = n2;
                boolean bl3 = false;
                int n3 = itemStack.getCount();
                n2 = n + n3;
            }
            n = n2;
            Integer n4 = n;
            Object object2 = $this$getOrPut$iv$iv$iv;
            object.add(new Pair(object2, (Object)n4));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection collection;
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            Component component = (Component)pair.component1();
            int count = ((Number)pair.component2()).intValue();
            if (++itemCount > 10) continue;
            if (first) {
                first = false;
                collection = tooltipComponents;
                boolean $i$f$text232 = false;
                TextScope $this$appendHoverText_u24lambda_u248_u24lambda_u246 = TextScope.INSTANCE;
                boolean bl4 = false;
                Component $i$f$text232 = TextScopeKt.invoke($this$appendHoverText_u24lambda_u248_u24lambda_u246, "");
                collection.add($i$f$text232);
            }
            collection = tooltipComponents;
            boolean $i$f$text = false;
            TextScope $this$appendHoverText_u24lambda_u248_u24lambda_u247 = TextScope.INSTANCE;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)component);
            Component component2 = TextScopeKt.plus($this$appendHoverText_u24lambda_u248_u24lambda_u247, component, count > 1 ? TextScopeKt.invoke($this$appendHoverText_u24lambda_u248_u24lambda_u247, " x " + count) : TextScopeKt.invoke($this$appendHoverText_u24lambda_u248_u24lambda_u247, ""));
            collection.add(component2);
        }
        if (itemCount > 10) {
            iterable = tooltipComponents;
            boolean $i$f$text = false;
            TextScope $this$appendHoverText_u24lambda_u249 = TextScope.INSTANCE;
            boolean bl3 = false;
            Component component = TextScopeKt.invoke($this$appendHoverText_u24lambda_u249, "... " + (itemCount - 10));
            iterable.add(component);
        }
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return false;
        }
        BagInventory bagInventory2 = bagInventory;
        Iterable $this$count$iv = InventoryKt.getItemStacks((Container)bagInventory2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!ItemStackKt.isNotEmpty(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        return count > 0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return 0;
        }
        BagInventory bagInventory2 = bagInventory;
        Iterable $this$count$iv = InventoryKt.getItemStacks((Container)bagInventory2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!ItemStackKt.isNotEmpty(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        return MathKt.roundToInt((double)(13.0 * (double)count / (double)this.card.getInventorySize()));
    }

    public int getBarColor(@NotNull ItemStack stack) {
        int n;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return 0;
        }
        BagInventory bagInventory2 = bagInventory;
        Iterable $this$count$iv = InventoryKt.getItemStacks((Container)bagInventory2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (!ItemStackKt.isNotEmpty(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        return count >= this.card.getInventorySize() ? 0xFF0000 : 65280;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        int n;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)itemStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            int selectedSlot = user.getInventory().selected;
            if (!Inventory.isHotbarSlot((int)selectedSlot)) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            n = selectedSlot;
        } else {
            n = -1;
        }
        int slotIndex = n;
        user.openMenu((MenuProvider)new ExtendedScreenHandlerFactory<Integer>(slotIndex, itemStack){
            final /* synthetic */ int $slotIndex;
            final /* synthetic */ ItemStack $itemStack;
            {
                this.$slotIndex = $slotIndex;
                this.$itemStack = $itemStack;
            }

            public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return BagModuleKt.createBagScreenHandler(syncId, playerInventory, this.$slotIndex);
            }

            public Component getDisplayName() {
                return this.$itemStack.getHoverName();
            }

            public Integer getScreenOpeningData(ServerPlayer player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return this.$slotIndex;
            }
        });
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction clickType, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        if (!slot.mayPickup(player)) {
            return false;
        }
        SimpleContainer srcInventory = new SimpleContainer(1);
        Container container = (Container)srcInventory;
        ItemStack itemStack = slot.getItem().copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        InventoryKt.set(container, 0, itemStack);
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return false;
        }
        BagInventory destInventory = bagInventory;
        MergeResult result = InventoryKt.mergeTo((Container)srcInventory, (Container)destInventory);
        if (!result.getCompleted() && !slot.allowModification(player)) {
            return false;
        }
        if (result.getMovementTimes() > 0) {
            player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
        }
        slot.set(InventoryKt.get((Container)srcInventory, 0));
        BagModuleKt.setBagInventory(stack, destInventory);
        return true;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction clickType, @NotNull Player player, @NotNull SlotAccess cursorStackReference) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)otherStack, (String)"otherStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)cursorStackReference, (String)"cursorStackReference");
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        if (!slot.allowModification(player)) {
            return false;
        }
        SimpleContainer srcInventory = new SimpleContainer(1);
        Container container = (Container)srcInventory;
        ItemStack itemStack = cursorStackReference.get().copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        InventoryKt.set(container, 0, itemStack);
        BagInventory bagInventory = BagModuleKt.getBagInventory(stack);
        if (bagInventory == null) {
            return false;
        }
        BagInventory destInventory = bagInventory;
        MergeResult result = InventoryKt.mergeTo((Container)srcInventory, (Container)destInventory);
        if (result.getMovementTimes() > 0) {
            player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
        }
        cursorStackReference.set(InventoryKt.get((Container)srcInventory, 0));
        BagModuleKt.setBagInventory(stack, destInventory);
        return true;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void onDestroyed(@NotNull ItemEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level world = entity.level();
        if (world.isClientSide) {
            return;
        }
        ItemStack itemStack = entity.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        BagInventory bagInventory = BagModuleKt.getBagInventory(itemStack);
        if (bagInventory == null) {
            return;
        }
        BagInventory bagInventory2 = bagInventory;
        NonNullList nonNullList = bagInventory2.items;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
        Iterable $this$forEach$iv = (Iterable)nonNullList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack itemStack2 = (ItemStack)element$iv;
            boolean bl = false;
            world.addFreshEntity((Entity)new ItemEntity(world, entity.getX(), entity.getY(), entity.getZ(), itemStack2));
        }
    }
}

