/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.wave;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import miragefairy2024.shadow.mirrg.kotlin.slf4j.hydrogen.LoggingKt;
import miragefairy2024.wave.Complex;
import miragefairy2024.wave.FftKt;
import miragefairy2024.wave.Spectrogram;
import miragefairy2024.wave.Waveform;
import miragefairy2024.wave.WindowsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a!\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\b\u001a\u00020\u0000*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000e\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000e\u0010\f\u001a!\u0010\u000f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0011\u0010\u0011\u001a\u00020\u0005*\u00020\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0011\u0010\u0013\u001a\u00020\u0005*\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0012\u001a\u0011\u0010\u0015\u001a\u00020\u0005*\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u0019\u001a\u00020\u0018*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0019\u0010\u001c\u001a\u00020\u0018*\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001d\"\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lmiragefairy2024/wave/Waveform;", "", "bits", "", "m", "Lmiragefairy2024/wave/Spectrogram;", "toSpectrogram", "(Lmiragefairy2024/wave/Waveform;ID)Lmiragefairy2024/wave/Spectrogram;", "toWaveform", "(Lmiragefairy2024/wave/Spectrogram;ID)Lmiragefairy2024/wave/Waveform;", "imageHeight", "resizeHorizontal", "(Lmiragefairy2024/wave/Spectrogram;I)Lmiragefairy2024/wave/Spectrogram;", "imageWidth", "resizeVertical", "resize", "(Lmiragefairy2024/wave/Spectrogram;II)Lmiragefairy2024/wave/Spectrogram;", "fromLogScale", "(Lmiragefairy2024/wave/Spectrogram;)Lmiragefairy2024/wave/Spectrogram;", "toLogScale", "Ljava/io/File;", "readSpectrogram", "(Ljava/io/File;)Lmiragefairy2024/wave/Spectrogram;", "spectrogram", "", "writeSpectrogram", "(Ljava/io/File;Lmiragefairy2024/wave/Spectrogram;)V", "file", "writeTo", "(Lmiragefairy2024/wave/Spectrogram;Ljava/io/File;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "IFR25KU-fabric"})
@SourceDebugExtension(value={"SMAP\nSpectrogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spectrogram.kt\nmiragefairy2024/wave/SpectrogramKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n11315#2:347\n11444#2,4:348\n11165#2:354\n11500#2,3:355\n37#3,2:352\n1863#4,2:358\n1863#4,2:360\n*S KotlinDebug\n*F\n+ 1 Spectrogram.kt\nmiragefairy2024/wave/SpectrogramKt\n*L\n65#1:347\n65#1:348,4\n111#1:354\n111#1:355,3\n68#1:352,2\n191#1:358,2\n273#1:360,2\n*E\n"})
public final class SpectrogramKt {
    @NotNull
    private static final Logger logger = LoggingKt.getLogger(Spectrogram.class);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Spectrogram toSpectrogram(@NotNull Waveform $this$toSpectrogram, int bits, double m) {
        Intrinsics.checkNotNullParameter((Object)$this$toSpectrogram, (String)"<this>");
        if (!(bits >= 4)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        int windowSize = 1 << bits;
        logger.info("Window Size: " + windowSize);
        int length = $this$toSpectrogram.getDoubleArray().length;
        logger.info("Input Waveform Length: " + length);
        int width = length + windowSize - 1;
        int height = windowSize / 2 + 1;
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int i = 0; i < width; ++i) {
            void $this$toTypedArray$iv;
            void $this$mapIndexedTo$iv$iv;
            int x = i;
            boolean bl = false;
            double[] subWaveform = new double[windowSize];
            Waveform $this$toSpectrogram_u24lambda_u243_u24lambda_u240 = $this$toSpectrogram;
            boolean bl2 = false;
            int start22 = x - (windowSize - 1);
            int end = x;
            int count = windowSize;
            int dest = 0;
            if (start22 < 0) {
                amount = -start22;
                start22 = 0;
                count -= amount;
                dest += amount;
            } else if (end >= length) {
                amount = end - length + 1;
                end = length - 1;
                count -= amount;
            }
            System.arraycopy($this$toSpectrogram_u24lambda_u243_u24lambda_u240.getDoubleArray(), start22, subWaveform, dest, end - start22 + 1);
            Object $this$mapIndexed$iv = subWaveform;
            boolean $i$f$mapIndexed = false;
            double[] start22 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((double[])$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void it;
                void i2;
                int n = index$iv$iv++;
                void var23_26 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                double w = WindowsKt.hanningWindow((double)i2, windowSize);
                collection.add(new Complex((double)(it * w), 0.0));
            }
            $this$mapIndexed$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Complex[] complexWindowedSubWaveform = thisCollection$iv.toArray(new Complex[0]);
            Complex[] outputSpectrum = FftKt.fft(complexWindowedSubWaveform);
            int n = 0;
            while (n < height) {
                int y = n++;
                boolean bl4 = false;
                double r = outputSpectrum[y].re * m;
                double g = outputSpectrum[y].abs() * m;
                double b = outputSpectrum[y].im * m;
                int rgb = (RangesKt.coerceIn((int)((int)r), (int)-128, (int)127) + 128 & 0xFF) << 16 | (RangesKt.coerceIn((int)((int)g), (int)0, (int)255) & 0xFF) << 8 | (RangesKt.coerceIn((int)((int)b), (int)-128, (int)127) + 128 & 0xFF) << 0;
                image.setRGB(x, height - 1 - y, rgb);
            }
        }
        return new Spectrogram(image);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Waveform toWaveform(@NotNull Spectrogram $this$toWaveform, int bits, double m) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toWaveform, (String)"<this>");
        if (!(bits >= 4)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        int windowSize = 1 << bits;
        if (!($this$toWaveform.getBufferedImage().getWidth() >= windowSize)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!($this$toWaveform.getBufferedImage().getHeight() == windowSize / 2 + 1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        List doubleArrays = new ArrayList();
        Complex zero = new Complex(0.0, 0.0);
        int n2 = $this$toWaveform.getBufferedImage().getWidth();
        for (int i = 0; i < n2; ++i) {
            void $this$mapTo$iv$iv;
            int x = i;
            boolean bl = false;
            int n3 = 0;
            Complex[] complexArray = new Complex[windowSize];
            while (n3 < windowSize) {
                n = n3++;
                complexArray[n] = zero;
            }
            Complex[] spectrum = complexArray;
            n3 = $this$toWaveform.getBufferedImage().getHeight();
            for (int j = 0; j < n3; ++j) {
                int y = j;
                boolean bl2 = false;
                int rgb = $this$toWaveform.getBufferedImage().getRGB(x, $this$toWaveform.getBufferedImage().getHeight() - 1 - y);
                double r = (double)((rgb >> 16 & 0xFF) - 128) / m;
                double b = (double)((rgb >> 0 & 0xFF) - 128) / m;
                spectrum[y] = new Complex(r, b);
                if (y == 0 || y == $this$toWaveform.getBufferedImage().getHeight() - 1) continue;
                spectrum[windowSize - y] = new Complex(r, -b);
            }
            Collection collection = doubleArrays;
            Complex[] $this$map$iv = FftKt.ifft(spectrum);
            boolean $i$f$map = false;
            Complex[] bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n4 = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n4; ++j) {
                void it;
                void item$iv$iv;
                void var25_34 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.re);
            }
            collection.add(CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv)));
        }
        int length = doubleArrays.size() - windowSize + 1;
        double[] doubleArray = new double[length];
        for (int i = 0; i < length; ++i) {
            int x = i;
            boolean bl = false;
            double value = 0.0;
            n = 0;
            while (n < windowSize) {
                int i2 = n++;
                boolean bl4 = false;
                double w = WindowsKt.hanningWindow(i2, windowSize);
                value += ((double[])doubleArrays.get(x + i2))[windowSize - 1 - i2] * w;
            }
            doubleArray[x] = value / (double)windowSize * (double)2;
        }
        return new Waveform(doubleArray);
    }

    @NotNull
    public static final Spectrogram resizeHorizontal(@NotNull Spectrogram $this$resizeHorizontal, int imageHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$resizeHorizontal, (String)"<this>");
        BufferedImage image = new BufferedImage($this$resizeHorizontal.getBufferedImage().getWidth(), imageHeight, 1);
        double rate = (double)$this$resizeHorizontal.getBufferedImage().getHeight() / (double)imageHeight;
        int n = $this$resizeHorizontal.getBufferedImage().getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            for (int j = 0; j < imageHeight; ++j) {
                int imageY0 = j;
                boolean bl2 = false;
                int imageY1 = imageY0 + 1;
                double thisY0 = (double)imageY0 * rate;
                double thisY1 = (double)imageY1 * rate;
                int thisY0f = (int)thisY0;
                int thisY1f = (int)thisY1;
                Ref.DoubleRef count = new Ref.DoubleRef();
                Ref.DoubleRef sumR = new Ref.DoubleRef();
                Ref.DoubleRef sumG = new Ref.DoubleRef();
                Ref.DoubleRef sumB = new Ref.DoubleRef();
                if (thisY0f == thisY1f) {
                    SpectrogramKt.resizeHorizontal$lambda$11$lambda$10$add($this$resizeHorizontal, x, count, sumR, sumG, sumB, thisY1 - thisY0, thisY0f);
                } else {
                    SpectrogramKt.resizeHorizontal$lambda$11$lambda$10$add($this$resizeHorizontal, x, count, sumR, sumG, sumB, (double)(thisY0f + 1) - thisY0, thisY0f);
                    Iterable $this$forEach$iv = (Iterable)new IntRange(thisY0f + 1, thisY1f - 1);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int thisYf = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl3 = false;
                        SpectrogramKt.resizeHorizontal$lambda$11$lambda$10$add($this$resizeHorizontal, x, count, sumR, sumG, sumB, 1.0, thisYf);
                    }
                    if (thisY1f < $this$resizeHorizontal.getBufferedImage().getHeight()) {
                        SpectrogramKt.resizeHorizontal$lambda$11$lambda$10$add($this$resizeHorizontal, x, count, sumR, sumG, sumB, thisY1 - (double)thisY1f, thisY1f);
                    }
                }
                double r = sumR.element / count.element;
                double g = sumG.element / count.element;
                double b = sumB.element / count.element;
                int outputRgb = RangesKt.coerceIn((int)((int)r), (int)0, (int)255) << 16 | RangesKt.coerceIn((int)((int)g), (int)0, (int)255) << 8 | RangesKt.coerceIn((int)((int)b), (int)0, (int)255) << 0;
                image.setRGB(x, imageY0, outputRgb);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram resizeVertical(@NotNull Spectrogram $this$resizeVertical, int imageWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$resizeVertical, (String)"<this>");
        BufferedImage image = new BufferedImage(imageWidth, $this$resizeVertical.getBufferedImage().getHeight(), 1);
        double rate = (double)$this$resizeVertical.getBufferedImage().getWidth() / (double)imageWidth;
        int n = $this$resizeVertical.getBufferedImage().getHeight();
        for (int i = 0; i < n; ++i) {
            int y = i;
            boolean bl = false;
            for (int j = 0; j < imageWidth; ++j) {
                int imageX0 = j;
                boolean bl2 = false;
                int imageX1 = imageX0 + 1;
                double thisX0 = (double)imageX0 * rate;
                double thisX1 = (double)imageX1 * rate;
                int thisX0f = (int)thisX0;
                int thisX1f = (int)thisX1;
                Ref.DoubleRef count = new Ref.DoubleRef();
                Ref.DoubleRef sumR = new Ref.DoubleRef();
                Ref.DoubleRef sumG = new Ref.DoubleRef();
                Ref.DoubleRef sumB = new Ref.DoubleRef();
                if (thisX0f == thisX1f) {
                    SpectrogramKt.resizeVertical$lambda$15$lambda$14$add$12($this$resizeVertical, y, count, sumR, sumG, sumB, thisX1 - thisX0, thisX0f);
                } else {
                    SpectrogramKt.resizeVertical$lambda$15$lambda$14$add$12($this$resizeVertical, y, count, sumR, sumG, sumB, (double)(thisX0f + 1) - thisX0, thisX0f);
                    Iterable $this$forEach$iv = (Iterable)new IntRange(thisX0f + 1, thisX1f - 1);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int thisXf = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl3 = false;
                        SpectrogramKt.resizeVertical$lambda$15$lambda$14$add$12($this$resizeVertical, y, count, sumR, sumG, sumB, 1.0, thisXf);
                    }
                    if (thisX1f < $this$resizeVertical.getBufferedImage().getWidth()) {
                        SpectrogramKt.resizeVertical$lambda$15$lambda$14$add$12($this$resizeVertical, y, count, sumR, sumG, sumB, thisX1 - (double)thisX1f, thisX1f);
                    }
                }
                double r = sumR.element / count.element;
                double g = sumG.element / count.element;
                double b = sumB.element / count.element;
                int outputRgb = RangesKt.coerceIn((int)((int)r), (int)0, (int)255) << 16 | RangesKt.coerceIn((int)((int)g), (int)0, (int)255) << 8 | RangesKt.coerceIn((int)((int)b), (int)0, (int)255) << 0;
                image.setRGB(imageX0, y, outputRgb);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram resize(@NotNull Spectrogram $this$resize, int imageWidth, int imageHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$resize, (String)"<this>");
        return SpectrogramKt.resizeVertical(SpectrogramKt.resizeHorizontal($this$resize, imageHeight), imageWidth);
    }

    @NotNull
    public static final Spectrogram fromLogScale(@NotNull Spectrogram $this$fromLogScale) {
        Intrinsics.checkNotNullParameter((Object)$this$fromLogScale, (String)"<this>");
        BufferedImage image = new BufferedImage($this$fromLogScale.getBufferedImage().getWidth(), $this$fromLogScale.getBufferedImage().getHeight(), 1);
        int n = $this$fromLogScale.getBufferedImage().getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = $this$fromLogScale.getBufferedImage().getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl2 = false;
                int rgb = $this$fromLogScale.getBufferedImage().getRGB(x, y);
                int r = RangesKt.coerceIn((int)((int)SpectrogramKt.fromLogScale$lambda$17$lambda$16$f(rgb >> 16 & 0xFF)), (int)0, (int)255);
                int g = RangesKt.coerceIn((int)((int)SpectrogramKt.fromLogScale$lambda$17$lambda$16$f(rgb >> 8 & 0xFF)), (int)0, (int)255);
                int b = RangesKt.coerceIn((int)((int)SpectrogramKt.fromLogScale$lambda$17$lambda$16$f(rgb >> 0 & 0xFF)), (int)0, (int)255);
                image.setRGB(x, y, r << 16 | g << 8 | b << 0);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram toLogScale(@NotNull Spectrogram $this$toLogScale) {
        Intrinsics.checkNotNullParameter((Object)$this$toLogScale, (String)"<this>");
        BufferedImage image = new BufferedImage($this$toLogScale.getBufferedImage().getWidth(), $this$toLogScale.getBufferedImage().getHeight(), 1);
        int n = $this$toLogScale.getBufferedImage().getWidth();
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = $this$toLogScale.getBufferedImage().getHeight();
            int n3 = 0;
            while (n3 < n2) {
                int y = n3++;
                boolean bl2 = false;
                int rgb = $this$toLogScale.getBufferedImage().getRGB(x, y);
                int r = RangesKt.coerceIn((int)((int)SpectrogramKt.toLogScale$lambda$20$lambda$19$f$18(rgb >> 16 & 0xFF)), (int)0, (int)255);
                int g = RangesKt.coerceIn((int)((int)SpectrogramKt.toLogScale$lambda$20$lambda$19$f$18(rgb >> 8 & 0xFF)), (int)0, (int)255);
                int b = RangesKt.coerceIn((int)((int)SpectrogramKt.toLogScale$lambda$20$lambda$19$f$18(rgb >> 0 & 0xFF)), (int)0, (int)255);
                image.setRGB(x, y, r << 16 | g << 8 | b << 0);
            }
        }
        return new Spectrogram(image);
    }

    @NotNull
    public static final Spectrogram readSpectrogram(@NotNull File $this$readSpectrogram) {
        Intrinsics.checkNotNullParameter((Object)$this$readSpectrogram, (String)"<this>");
        BufferedImage bufferedImage = ImageIO.read($this$readSpectrogram);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return new Spectrogram(bufferedImage);
    }

    public static final void writeSpectrogram(@NotNull File $this$writeSpectrogram, @NotNull Spectrogram spectrogram) {
        Intrinsics.checkNotNullParameter((Object)$this$writeSpectrogram, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spectrogram, (String)"spectrogram");
        ImageIO.write((RenderedImage)spectrogram.getBufferedImage(), "png", $this$writeSpectrogram);
    }

    public static final void writeTo(@NotNull Spectrogram $this$writeTo, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SpectrogramKt.writeSpectrogram(file, $this$writeTo);
    }

    private static final void resizeHorizontal$lambda$11$lambda$10$add(Spectrogram $this_resizeHorizontal, int $x, Ref.DoubleRef count, Ref.DoubleRef sumR, Ref.DoubleRef sumG, Ref.DoubleRef sumB, double c, int thisY) {
        int inputRgb = $this_resizeHorizontal.getBufferedImage().getRGB($x, thisY);
        count.element += c;
        sumR.element += (double)(inputRgb >> 16 & 0xFF) * c;
        sumG.element += (double)(inputRgb >> 8 & 0xFF) * c;
        sumB.element += (double)(inputRgb >> 0 & 0xFF) * c;
    }

    private static final void resizeVertical$lambda$15$lambda$14$add$12(Spectrogram $this_resizeVertical, int $y, Ref.DoubleRef count, Ref.DoubleRef sumR, Ref.DoubleRef sumG, Ref.DoubleRef sumB, double c, int thisX) {
        int inputRgb = $this_resizeVertical.getBufferedImage().getRGB(thisX, $y);
        count.element += c;
        sumR.element += (double)(inputRgb >> 16 & 0xFF) * c;
        sumG.element += (double)(inputRgb >> 8 & 0xFF) * c;
        sumB.element += (double)(inputRgb >> 0 & 0xFF) * c;
    }

    private static final double fromLogScale$lambda$17$lambda$16$f(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return (double)255 * Math.pow(0.1, ((double)255 - x) / (double)125);
    }

    private static final double toLogScale$lambda$20$lambda$19$f$18(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return (double)255 - MathKt.log((double)(x / 255.0), (double)0.1) * 125.0;
    }
}

