/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.mod.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import miragefairy2024.mod.SoundEventCard;
import miragefairy2024.mod.materials.MaterialCard;
import miragefairy2024.mod.tool.PhysicalMagicDamageTypeCard;
import miragefairy2024.util.EntityKt;
import miragefairy2024.util.WorldKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u00010B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR+\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%*\u0004\b&\u0010'R+\u0010,\u001a\u00020 2\u0006\u0010!\u001a\u00020 8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b)\u0010#\"\u0004\b*\u0010%*\u0004\b+\u0010'R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lmiragefairy2024/mod/entity/EtheroballisticBoltEntity;", "Lnet/minecraft/world/entity/projectile/Projectile;", "Lnet/minecraft/world/entity/EntityType;", "entityType", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "builder", "", "defineSynchedData", "(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "readAdditionalSaveData", "tick", "()V", "Lnet/minecraft/world/phys/HitResult;", "hitResult", "onHit", "(Lnet/minecraft/world/phys/HitResult;)V", "Lnet/minecraft/world/phys/EntityHitResult;", "entityHitResult", "onHitEntity", "(Lnet/minecraft/world/phys/EntityHitResult;)V", "", "status", "handleEntityEvent", "(B)V", "", "<set-?>", "getDamage", "()F", "setDamage", "(F)V", "getDamage$delegate", "(Lmiragefairy2024/mod/entity/EtheroballisticBoltEntity;)Ljava/lang/Object;", "damage", "getMaxDistance", "setMaxDistance", "getMaxDistance$delegate", "maxDistance", "Lnet/minecraft/world/phys/Vec3;", "prevPos", "Lnet/minecraft/world/phys/Vec3;", "Companion", "IFR25KU-common"})
public final class EtheroballisticBoltEntity
extends Projectile {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private Vec3 prevPos;
    @NotNull
    private static final EntityDataAccessor<Float> DAMAGE;
    @NotNull
    private static final EntityDataAccessor<Float> MAX_DISTANCE;

    public EtheroballisticBoltEntity(@NotNull EntityType<? extends EtheroballisticBoltEntity> entityType2, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType2, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType2, world);
    }

    public final float getDamage() {
        return ((Number)EntityKt.getValue((Entity)this, DAMAGE, (Entity)this, $$delegatedProperties[0])).floatValue();
    }

    public final void setDamage(float f2) {
        EntityKt.setValue((Entity)this, DAMAGE, (Entity)this, $$delegatedProperties[0], Float.valueOf(f2));
    }

    private static Object getDamage$delegate(EtheroballisticBoltEntity etheroballisticBoltEntity) {
        return DAMAGE;
    }

    public final float getMaxDistance() {
        return ((Number)EntityKt.getValue((Entity)this, MAX_DISTANCE, (Entity)this, $$delegatedProperties[1])).floatValue();
    }

    public final void setMaxDistance(float f2) {
        EntityKt.setValue((Entity)this, MAX_DISTANCE, (Entity)this, $$delegatedProperties[1], Float.valueOf(f2));
    }

    private static Object getMaxDistance$delegate(EtheroballisticBoltEntity etheroballisticBoltEntity) {
        return MAX_DISTANCE;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(MAX_DISTANCE, (Object)Float.valueOf(0.0f));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putFloat("Damage", this.getDamage());
        nbt.putFloat("MaxDistance", this.getMaxDistance());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.setDamage(nbt.getFloat("Damage"));
        this.setMaxDistance(nbt.getFloat("MaxDistance"));
    }

    public void tick() {
        boolean bl;
        super.tick();
        float movingDistance = (float)this.getDeltaMovement().length();
        if (movingDistance >= this.getMaxDistance()) {
            if (movingDistance >= 0.001f) {
                this.setDeltaMovement(this.getDeltaMovement().scale((double)(this.getMaxDistance() / movingDistance)));
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean stopped = bl;
        this.setMaxDistance(this.getMaxDistance() - movingDistance);
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)((Entity)this), arg_0 -> EtheroballisticBoltEntity.tick$lambda$0(this, arg_0));
        if (hitResult.getType() != HitResult.Type.MISS) {
            Intrinsics.checkNotNull((Object)hitResult);
            this.onHit(hitResult);
        }
        if (this.isRemoved()) {
            return;
        }
        this.checkInsideBlocks();
        if (this.isRemoved()) {
            return;
        }
        Vec3 vec3d = this.getDeltaMovement();
        double nextX = this.getX() + vec3d.x;
        double nextY = this.getY() + vec3d.y;
        double nextZ = this.getZ() + vec3d.z;
        this.updateRotation();
        if (stopped) {
            this.discard();
            return;
        }
        this.prevPos = this.position();
        this.setPos(nextX, nextY, nextZ);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            this.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * (double)180.0f / (double)((float)Math.PI)));
            this.setXRot((float)(Mth.atan2((double)vec3d.y, (double)vec3d.horizontalDistance()) * (double)180.0f / (double)((float)Math.PI)));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    protected void onHit(@NotNull HitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        super.onHit(hitResult);
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        if (WorldKt.isServer(level)) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        Intrinsics.checkNotNullParameter((Object)entityHitResult, (String)"entityHitResult");
        super.onHitEntity(entityHitResult);
        Entity entity = this.getOwner();
        entityHitResult.getEntity().hurt(this.level().damageSources().source(PhysicalMagicDamageTypeCard.INSTANCE.getRegistryKey(), (Entity)this, (Entity)(entity instanceof LivingEntity ? (LivingEntity)entity : null)), this.getDamage());
        if (this.level().random.nextInt(5) == 0) {
            this.spawnAtLocation((ItemLike)MaterialCard.Companion.getETHEROBALLISTIC_BOLT_FRAGMENT().getItem().invoke());
        }
    }

    public void handleEntityEvent(byte status) {
        super.handleEntityEvent(status);
        if (status == 3) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEventCard.ENTITY_ETHEROBALLISTIC_BOLT_HIT.getSoundEvent(), SoundSource.NEUTRAL, 0.5f, 0.9f + (this.level().random.nextFloat() - 0.5f) * 0.3f, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean tick$lambda$0(EtheroballisticBoltEntity this$0, Entity it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getOwner() != null) {
            EntityType entityType2 = it.getType();
            Entity entity = this$0.getOwner();
            Intrinsics.checkNotNull((Object)entity);
            if (Intrinsics.areEqual((Object)entityType2, (Object)entity.getType())) return false;
        }
        if (!it.isPickable()) return false;
        return true;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EtheroballisticBoltEntity.class, "damage", "getDamage()F", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(EtheroballisticBoltEntity.class, "maxDistance", "getMaxDistance()F", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(EtheroballisticBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DAMAGE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(EtheroballisticBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        MAX_DISTANCE = entityDataAccessor2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lmiragefairy2024/mod/entity/EtheroballisticBoltEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "DAMAGE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getDAMAGE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "MAX_DISTANCE", "getMAX_DISTANCE", "IFR25KU-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Float> getDAMAGE() {
            return DAMAGE;
        }

        @NotNull
        public final EntityDataAccessor<Float> getMAX_DISTANCE() {
            return MAX_DISTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

