/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.util;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import miragefairy2024.shadow.mirrg.kotlin.helium.NumberKt;
import miragefairy2024.util.MathKt;
import miragefairy2024.util.NeighborType;
import miragefairy2024.util.WorldKt;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H&\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u007f\u0010&\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001f\u001a\u00020\u001e2\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\"2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100$\u00a2\u0006\u0004\b&\u0010'R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00101\u001a\u0004\b2\u00103R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00104\u001a\u0004\b5\u00106R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u00107\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lmiragefairy2024/util/MultiMine;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lnet/minecraft/server/level/ServerPlayer;", "miner", "Lnet/minecraft/world/item/Item;", "toolItem", "Lnet/minecraft/world/item/ItemStack;", "toolItemStack", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;)V", "", "isValidBaseBlockState", "()Z", "", "executeImpl", "()V", "execute", "", "originalBlockPosList", "", "miningDamage", "", "maxDistance", "maxCount", "Lmiragefairy2024/util/NeighborType;", "neighborType", "Lkotlin/Function1;", "onMine", "Lnet/minecraft/core/BlockBox;", "region", "Lkotlin/Function2;", "canContinue", "visit", "(Ljava/lang/Iterable;DILjava/lang/Integer;Lmiragefairy2024/util/NeighborType;Lkotlin/jvm/functions/Function1;Lnet/minecraft/core/BlockBox;Lkotlin/jvm/functions/Function2;)Z", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/server/level/ServerPlayer;", "getMiner", "()Lnet/minecraft/server/level/ServerPlayer;", "Lnet/minecraft/world/item/Item;", "getToolItem", "()Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/ItemStack;", "getToolItemStack", "()Lnet/minecraft/world/item/ItemStack;", "IFR25KU-common"})
@SourceDebugExtension(value={"SMAP\nMultiMine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiMine.kt\nmiragefairy2024/util/MultiMine\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,73:1\n1317#2,2:74\n*S KotlinDebug\n*F\n+ 1 MultiMine.kt\nmiragefairy2024/util/MultiMine\n*L\n50#1:74,2\n*E\n"})
public abstract class MultiMine {
    @NotNull
    private final Level level;
    @NotNull
    private final BlockPos blockPos;
    @NotNull
    private final BlockState blockState;
    @NotNull
    private final ServerPlayer miner;
    @NotNull
    private final Item toolItem;
    @NotNull
    private final ItemStack toolItemStack;

    public MultiMine(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull ServerPlayer miner, @NotNull Item toolItem, @NotNull ItemStack toolItemStack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)miner, (String)"miner");
        Intrinsics.checkNotNullParameter((Object)toolItem, (String)"toolItem");
        Intrinsics.checkNotNullParameter((Object)toolItemStack, (String)"toolItemStack");
        this.level = level;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.miner = miner;
        this.toolItem = toolItem;
        this.toolItemStack = toolItemStack;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    public final BlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public final ServerPlayer getMiner() {
        return this.miner;
    }

    @NotNull
    public final Item getToolItem() {
        return this.toolItem;
    }

    @NotNull
    public final ItemStack getToolItemStack() {
        return this.toolItemStack;
    }

    public boolean isValidBaseBlockState() {
        return true;
    }

    public abstract void executeImpl();

    public final void execute() {
        if (this.miner.isShiftKeyDown()) {
            return;
        }
        if (!this.toolItem.isCorrectToolForDrops(this.toolItemStack, this.blockState)) {
            return;
        }
        if (!this.isValidBaseBlockState()) {
            return;
        }
        this.executeImpl();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean visit(@NotNull Iterable<? extends BlockPos> originalBlockPosList, double miningDamage, int maxDistance, @Nullable Integer maxCount, @NotNull NeighborType neighborType, @NotNull Function1<? super BlockPos, Unit> onMine, @Nullable BlockBox region, @NotNull Function2<? super BlockPos, ? super BlockState, Boolean> canContinue) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(originalBlockPosList, (String)"originalBlockPosList");
        Intrinsics.checkNotNullParameter((Object)((Object)neighborType), (String)"neighborType");
        Intrinsics.checkNotNullParameter(onMine, (String)"onMine");
        Intrinsics.checkNotNullParameter(canContinue, (String)"canContinue");
        Sequence<Pair<Integer, BlockPos>> sequence = WorldKt.blockVisitor(originalBlockPosList, false, maxDistance, maxCount, neighborType, (Function3<? super Integer, ? super BlockPos, ? super BlockPos, Boolean>)((Function3)(arg_0, arg_1, arg_2) -> MultiMine.visit$lambda$1(region, this, canContinue, arg_0, arg_1, arg_2)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            float targetHardness;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            BlockPos blockPos = (BlockPos)pair.component2();
            if (this.toolItemStack.isEmpty()) {
                return false;
            }
            if (this.toolItemStack.getMaxDamage() - this.toolItemStack.getDamageValue() <= NumberKt.ceilToInt(miningDamage)) {
                return false;
            }
            BlockState targetBlockState = this.level.getBlockState(blockPos);
            Intrinsics.checkNotNull((Object)targetBlockState);
            if (!((Boolean)canContinue.invoke((Object)blockPos, (Object)targetBlockState)).booleanValue() || (targetHardness = targetBlockState.getDestroySpeed((BlockGetter)this.level, blockPos)) > this.blockState.getDestroySpeed((BlockGetter)this.level, blockPos) || !WorldKt.breakBlockByMagic(this.toolItemStack, this.level, blockPos, this.miner)) continue;
            if (targetHardness > 0.0f) {
                RandomSource randomSource = this.level.random;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                int damage = MathKt.randomInt(randomSource, miningDamage);
                if (damage > 0) {
                    this.toolItemStack.hurtAndBreak(damage, (LivingEntity)this.miner, EquipmentSlot.MAINHAND);
                }
            }
            onMine.invoke((Object)blockPos);
        }
        return true;
    }

    public static /* synthetic */ boolean visit$default(MultiMine multiMine, Iterable iterable, double d, int n, Integer n2, NeighborType neighborType, Function1 function1, BlockBox blockBox, Function2 function2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: visit");
        }
        if ((n3 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            neighborType = NeighborType.FACES;
        }
        if ((n3 & 0x20) != 0) {
            function1 = MultiMine::visit$lambda$0;
        }
        if ((n3 & 0x40) != 0) {
            blockBox = null;
        }
        return multiMine.visit(iterable, d, n, n2, neighborType, (Function1<? super BlockPos, Unit>)function1, blockBox, (Function2<? super BlockPos, ? super BlockState, Boolean>)function2);
    }

    private static final Unit visit$lambda$0(BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final boolean visit$lambda$1(BlockBox $region, MultiMine this$0, Function2 $canContinue, int n, BlockPos blockPos, BlockPos toBlockPos) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$canContinue, (String)"$canContinue");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)toBlockPos, (String)"toBlockPos");
        if ($region != null && !$region.contains(toBlockPos)) {
            return false;
        }
        BlockState blockState = this$0.level.getBlockState(toBlockPos);
        if (blockState.getDestroySpeed((BlockGetter)this$0.level, toBlockPos) < 0.0f) {
            return false;
        }
        Intrinsics.checkNotNull((Object)blockState);
        return (Boolean)$canContinue.invoke((Object)toBlockPos, (Object)blockState);
    }
}

