/*
 * Decompiled with CFR 0.152.
 */
package miragefairy2024.colormaker;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import miragefairy2024.colormaker.ColorEvaluator;
import miragefairy2024.colormaker.Layer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lmiragefairy2024/colormaker/LayeredImage;", "Ljavax/swing/JLabel;", "", "zoom", "<init>", "(I)V", "", "Lmiragefairy2024/colormaker/Layer;", "arrayList", "", "render", "(Ljava/util/List;)V", "layers", "Ljava/awt/image/BufferedImage;", "createImage", "(Ljava/util/List;)Ljava/awt/image/BufferedImage;", "I", "Lmiragefairy2024/colormaker/ColorEvaluator;", "colorEvaluator", "Lmiragefairy2024/colormaker/ColorEvaluator;", "getColorEvaluator", "()Lmiragefairy2024/colormaker/ColorEvaluator;", "setColorEvaluator", "(Lmiragefairy2024/colormaker/ColorEvaluator;)V", "Ljava/awt/Color;", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "IFR25KU-fabric"})
@SourceDebugExtension(value={"SMAP\nLayeredImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayeredImage.kt\nmiragefairy2024/colormaker/LayeredImage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1863#2,2:61\n*S KotlinDebug\n*F\n+ 1 LayeredImage.kt\nmiragefairy2024/colormaker/LayeredImage\n*L\n28#1:61,2\n*E\n"})
public final class LayeredImage
extends JLabel {
    private final int zoom;
    @NotNull
    private ColorEvaluator colorEvaluator;
    @NotNull
    private Color backgroundColor;

    public LayeredImage(int zoom) {
        this.zoom = zoom;
        this.colorEvaluator = new ColorEvaluator();
        Color color = Color.black;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
        this.backgroundColor = color;
    }

    @NotNull
    public final ColorEvaluator getColorEvaluator() {
        return this.colorEvaluator;
    }

    public final void setColorEvaluator(@NotNull ColorEvaluator colorEvaluator) {
        Intrinsics.checkNotNullParameter((Object)colorEvaluator, (String)"<set-?>");
        this.colorEvaluator = colorEvaluator;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.backgroundColor = color;
    }

    public final void render(@NotNull List<Layer> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"arrayList");
        this.setIcon(new ImageIcon(this.createImage(arrayList)));
    }

    private final BufferedImage createImage(List<Layer> layers) {
        BufferedImage image = new BufferedImage(16 * this.zoom, 16 * this.zoom, 1);
        int n = 16 * this.zoom;
        for (int i = 0; i < n; ++i) {
            int x = i;
            boolean bl = false;
            int n2 = 16 * this.zoom;
            for (int j = 0; j < n2; ++j) {
                int y = j;
                boolean bl2 = false;
                int r1 = 0;
                r1 = this.backgroundColor.getRed();
                int g1 = 0;
                g1 = this.backgroundColor.getGreen();
                int b1 = 0;
                b1 = this.backgroundColor.getBlue();
                Iterable $this$forEach$iv = layers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Layer layer = (Layer)element$iv;
                    boolean bl3 = false;
                    Color colorMul = this.colorEvaluator.evaluate(layer.getColorExpression());
                    int argbOver = layer.getImage().getRGB(x / this.zoom, y / this.zoom);
                    int a2 = argbOver >> 24 & 0xFF;
                    int r2 = argbOver >> 16 & 0xFF;
                    int g2 = argbOver >> 8 & 0xFF;
                    int b2 = argbOver >> 0 & 0xFF;
                    r2 = r2 * colorMul.getRed() / 255;
                    g2 = g2 * colorMul.getGreen() / 255;
                    b2 = b2 * colorMul.getBlue() / 255;
                    r1 = (r1 * (255 - a2) + r2 * a2) / 255;
                    g1 = (g1 * (255 - a2) + g2 * a2) / 255;
                    b1 = (b1 * (255 - a2) + b2 * a2) / 255;
                }
                image.setRGB(x, y, (r1 & 0xFF) << 16 | (g1 & 0xFF) << 8 | (b1 & 0xFF) << 0);
            }
        }
        return image;
    }
}

