/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator.entity;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.AcceleratorPortBlock;
import igentuman.nc.block.accelerator.entity.AbstractAcceleratorControllerBE;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.LinearAcceleratorPeripheral;
import igentuman.nc.compat.oc2.LinearAcceleratorDevice;
import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.item.ParticleSourceItem;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.LinearAcceleratorMultiblock;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.Equations;
import igentuman.nc.util.ModUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class LinearAcceleratorControllerBE
extends AbstractAcceleratorControllerBE {
    public static String NAME = "linear_accelerator_controller";
    private LazyOptional<LinearAcceleratorPeripheral> peripheralCap;
    protected Direction facing;
    public Recipe recipe;
    public HashMap<String, Recipe> cachedRecipes = new HashMap();
    protected int reValidateCounter = 0;

    public LinearAcceleratorControllerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)AcceleratorRegistration.ACCELERATOR_BE.get(NAME).get(), pPos, pBlockState);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Recipe getRecipe() {
        if (this.contentHandler().itemHandler.getStackInSlot(0).m_41619_()) {
            return null;
        }
        NcRecipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe instanceof Recipe) {
            Recipe cRecipe = (Recipe)cachedRecipe;
            return cRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey("accelerator")) {
            return null;
        }
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("accelerator", this.m_58904_())) {
            if (!recipe.test(this.contentHandler())) continue;
            this.addToCache(recipe);
            return (Recipe)recipe;
        }
        return null;
    }

    @Override
    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new LinearAcceleratorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler().getFluidCapability(side);
        }
        if (cap == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.particleHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergy().cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == LinearAcceleratorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
        }
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        this.changed = false;
        super.tickServer();
        boolean wasEnabled = this.controllerEnabled;
        this.handleValidation();
        if (this.redstoneLevel < 1.0) {
            this.redstoneLevel = this.getRedstoneSignal();
        }
        boolean bl = this.controllerEnabled = this.getMultiblock().isFormed() && this.redstoneLevel > 0.0;
        if (this.controllerEnabled) {
            this.trackChanges(this.contentHandler().tick());
            this.handleMeltdown();
            this.trackChanges(this.accelerateParticle());
        }
        this.heat -= this.coolingRate;
        this.heat = Math.max(0, this.heat);
        this.coolantCoolDown();
        boolean bl2 = this.refreshCacheFlag = !this.getMultiblock().isFormed();
        if (wasEnabled != this.controllerEnabled) {
            this.m_6596_();
        }
        if (this.refreshCacheFlag || this.changed || NuclearCraft.currentTick % 20L == 0L) {
            try {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)AcceleratorPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)), 1);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AcceleratorPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public LinearAcceleratorMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new LinearAcceleratorMultiblock(this);
        }
        return (LinearAcceleratorMultiblock)this.multiblock;
    }

    private void handleMeltdown() {
    }

    @Override
    public HashMap<String, String> getAnalyzeReport() {
        HashMap<String, String> report = new HashMap<String, String>();
        return report;
    }

    private boolean accelerateParticle() {
        this.hasParticle = false;
        if (this.energyStorage().getEnergyStored() < this.energyRequired) {
            return false;
        }
        if (this.particleStorage.getParticle() == null) {
            this.getParticleFromIonSource();
        }
        if (this.particleStorage.getParticle() == null) {
            return false;
        }
        if (!this.drainEnergy()) {
            return false;
        }
        ParticleStack particleStack = this.particleStorage.getParticle();
        if (particleStack == null || particleStack.isEmpty()) {
            return false;
        }
        particleStack.addFocus(Equations.focusGain(this.focus, particleStack) - Equations.focusLoss(this.beamLength, particleStack));
        particleStack.setMeanEnergy((long)((double)Equations.linacEnergyGain(this.acceleratingVoltage, particleStack) * (this.redstoneLevel / 15.0)));
        this.particleStorage.setParticleStack(particleStack);
        this.heat += this.heatRate;
        this.hasParticle = true;
        this.getMultiblock().extractParticle(particleStack);
        return true;
    }

    private void getParticleFromIonSource() {
        ItemStack stack = this.contentHandler().itemHandler.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (item instanceof ParticleSourceItem) {
            ParticleSourceItem sourceItem = (ParticleSourceItem)item;
            ParticleStack particle = sourceItem.getParticleStack(stack = sourceItem.use(stack, 10000));
            if (particle != null) {
                particle.addFocus(0.4);
                particle.setAmount(10000);
                this.particleStorage.setParticleStack(particle);
                this.contentHandler().itemHandler.setStackInSlot(0, stack);
            }
        } else {
            ParticleStack particle;
            FluidStack fluidStack = this.contentHandler().fluidHandler.getFluidInSlot(0);
            if (fluidStack != null && !fluidStack.isEmpty() && (particle = ParticleSources.getParticleFromFluid(fluidStack)) != null) {
                particle.addFocus(0.4);
                particle.setAmount(10000);
                this.particleStorage.setParticleStack(particle);
                ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> LinearAcceleratorDevice.createDevice(this)).cast();
    }

    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(NAME, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return "accelerator";
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "accelerator";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get(NAME).get());
        }

        public int getBaseTime() {
            return (int)(this.timeModifier * 50.0);
        }

        @Override
        public double getEnergy() {
            return this.powerModifier * 1000.0;
        }
    }

    public static class CoolantRecipe
    extends NcRecipe {
        protected double coolingRate;

        public CoolantRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double temperature, double powerModifier, double radiation, double rar) {
            super(id, input, output, inputFluids, outputFluids, temperature, powerModifier, radiation, rar);
            this.coolingRate = temperature;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "accelerator_coolant";
        }

        @Override
        public String getCodeId() {
            return "accelerator_coolant";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_port").get());
        }

        public double getCoolingRate() {
            return Math.max(this.rarityModifier, 1.0);
        }
    }
}

