/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class IrradiatorBE
extends NCProcessorBE
implements MultiblockAttachable {
    private AbstractMultiblock multiblock;
    private FissionControllerBE controller;
    @NBTField
    public int irradiativeFlux = 0;
    @NBTField
    public double fuelMultiplier = 1.0;

    public IrradiatorBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, "irradiator");
        this.particle1 = ParticleTypes.f_123748_;
    }

    @Override
    public double speedMultiplier() {
        return (double)this.irradiativeFlux / 10.0 * this.fuelMultiplier;
    }

    public void setMultiblock(AbstractMultiblock multiblock) {
        this.multiblock = multiblock;
        if (multiblock != null) {
            if (multiblock.controller() != null) {
                this.controller = (FissionControllerBE)multiblock.controller().controllerBE();
            }
        } else {
            this.controller = null;
        }
    }

    public FissionControllerBE controller() {
        return this.controller;
    }

    public AbstractMultiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    @Override
    public void tickServer() {
        int wasFlux = this.irradiativeFlux;
        double wasFuel = this.fuelMultiplier;
        this.irradiativeFlux = 0;
        this.fuelMultiplier = 0.0;
        if (this.controller() != null && this.controller().isProcessing()) {
            this.irradiativeFlux = this.controller().irradiationLines;
            this.fuelMultiplier = this.controller().recipeInfo.recipe().getRadiation() * 10000.0;
        }
        if (this.speedMultiplier() > 0.0) {
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            super.tickServer();
        }
        if (wasFlux != this.irradiativeFlux || wasFuel != this.fuelMultiplier) {
            this.m_6596_();
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        this.wasUpdated = true;
    }

    @Override
    public void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            this.isActive = false;
            return;
        }
        if (this.energyStorage().getEnergyStored() < this.energyPerTick() * this.skippedTicks) {
            this.isActive = false;
            return;
        }
        boolean processed = this.recipeInfo().process(this.speedMultiplier() * (double)this.skippedTicks);
        if (processed) {
            this.controller().addIrradiationHeat();
        }
        if (this.recipeInfo().radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo().radiation / 1000000.0 * this.speedMultiplier() * (double)this.skippedTicks, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        this.isActive = true;
        this.m_6596_();
        if (!this.recipeInfo().isCompleted() && this.hasRecipe()) {
            this.energyStorage().consumeEnergy(this.energyPerTick() * this.skippedTicks);
        }
    }

    @Deprecated
    public void upadteMultiblockConnection() {
        AbstractMultiblock mb = MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).getMultiblockByPos(this.m_58899_());
        if (mb != null) {
            if (mb.isFormed() && mb.controller() != null) {
                this.controller = (FissionControllerBE)mb.controller().controllerBE();
            }
            this.multiblock = mb;
        }
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return "irradiator";
        }
    }
}

