/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.TagUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;

public class NuclearFurnaceBE
extends NCProcessorBE {
    @NBTField
    public int burnTime = 0;
    private List<Item> ingots;

    public NuclearFurnaceBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, "nuclear_furnace");
        this.contentHandler.itemHandler.setValidItemsForSlot(this.getFuelItems(), 1);
    }

    private List<Item> getFuelItems() {
        if (this.ingots == null) {
            this.ingots = TagUtil.getItemsByTagKey("forge:ingots/uranium");
        }
        return this.ingots;
    }

    private void consumeFuel() {
        boolean hasFuel;
        --this.burnTime;
        if (this.burnTime < 0 && (hasFuel = this.getFuelItems().contains(this.contentHandler.itemHandler.getStackInSlot(1).m_41720_()))) {
            this.burnTime = 500;
            if (this.getFuelItems().contains(this.contentHandler.itemHandler.getStackInSlot(1).m_41720_())) {
                this.contentHandler.itemHandler.extractItem(1, 1, false);
            }
        }
    }

    @Override
    public boolean canProcessRecipe() {
        this.consumeFuel();
        return this.burnTime > 0;
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return "nuclear_furnace";
        }
    }
}

