/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fission;

import igentuman.nc.block.MultiblockControllerBlock;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.container.FissionControllerContainer;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class FissionControllerBlock
extends MultiblockControllerBlock
implements EntityBlock {
    public FissionControllerBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_());
    }

    public FissionControllerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)FissionReactorRegistration.FISSION_BE.get("fission_reactor_controller").get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.getExistingBlockEntity(pos)) instanceof FissionControllerBE) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return TextUtils.__("fission_reactor_controller", new Object[0]);
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FissionControllerContainer(windowId, pos, playerInventory);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)be.m_58899_());
        }
        return InteractionResult.SUCCESS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof FissionControllerBE) {
                    FissionControllerBE tile = (FissionControllerBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof FissionControllerBE) {
                FissionControllerBE tile = (FissionControllerBE)t;
                tile.tickServer();
            }
        };
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level.m_5776_()) {
            return;
        }
        Level world = (Level)level;
        MultiblockHandler.get((ResourceKey<Level>)world.m_46472_()).trackBlockChange(pos);
        BlockEntity be = world.getExistingBlockEntity(pos);
    }

    public void m_5871_(ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.energy_eu_tier", new Object[]{this.getTier(pStack)}).m_130940_(ChatFormatting.GOLD));
        }
        if (ModUtil.isGtLoaded() && CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() == CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.GTCEU_AND_FE && ((Boolean)CommonConfig.GTCEU_CONFIG.LIMIT_FE_OUTPUT.get()).booleanValue()) {
            list.add((Component)TextUtils.__("tooltip.nc.max_fe_extract_per_tick", TextUtils.formatEnergy(GTUtils.getMaxOutputFE((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.FISSION_REACTOR_TIER.get())))).m_130940_(ChatFormatting.GOLD));
        }
        list.add((Component)TextUtils.__("multiblock.build_in_chunk.advise", new Object[0]).m_130940_(ChatFormatting.GREEN));
        int max = (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
        int min = (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
        list.add((Component)TextUtils.__("tooltip.structure.sizes", min + "x" + min + "x" + min, max + "x" + max + "x" + max).m_130940_(ChatFormatting.ITALIC));
    }

    private CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getTier(ItemStack pStack) {
        return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.byId(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.FISSION_REACTOR_TIER.get())).ordinal() + pStack.m_41784_().m_128451_("upgrade_tier"));
    }
}

