/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fusion.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.block.fusion.FusionCoreBlock;
import igentuman.nc.block.fusion.entity.FusionCoreProxyBE;
import igentuman.nc.client.particle.FusionBeamParticleData;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.cc.FusionReactorPeripheral;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.FusionReactorDevice;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fusion.FusionReactorMultiblock;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FusionCoreBE
extends MultiblockControllerBE {
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte redstoneMode = (byte)12;
    @NBTField
    public double reactorHeat = 0.0;
    @NBTField
    public int size = 0;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public boolean powered = false;
    @NBTField
    public int inputRedstoneSignal = 0;
    @NBTField
    public int currentRfAmplification = 0;
    @NBTField
    public int amplifiers = 0;
    @NBTField
    protected boolean forceShutdown = false;
    @NBTField
    public double magneticFieldStrength = 0.0;
    @NBTField
    public int magnets = 0;
    @NBTField
    public int connectors = 0;
    @NBTField
    public int casingBlocks = 0;
    @NBTField
    public int magnetsPower = 0;
    @NBTField
    public int maxMagnetsTemp = 0;
    @NBTField
    public int rfAmplification = 0;
    @NBTField
    public int rfAmplifiersPower = 0;
    @NBTField
    public int minRFAmplifiersTemp = 0;
    @NBTField
    public int rfAmplificationRatio = 0;
    @NBTField
    public int amplificationAdjustment = 50;
    @NBTField
    public int functionalBlocksCharge = 0;
    @NBTField
    public long plasmaTemperature = 0L;
    public long chargeAmount = 0L;
    @NBTField
    public int rfEfficiency = 0;
    @NBTField
    public int magnetsEfficiency = 0;
    @NBTField
    protected double lastKnownOptimalTemp = 1000000.0;
    protected FusionCoolantRecipe coolantRecipe;
    protected final LazyOptional<IEnergyStorage> energy;
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage;
    protected LazyOptional<FusionReactorPeripheral> peripheralCap;
    protected List<FusionCoolantRecipe> coolantRecipes;
    public boolean controllerEnabled = false;
    public Recipe recipe;
    public HashMap<String, Recipe> cachedRecipes = new HashMap();
    protected boolean initialized = false;
    protected boolean refreshCacheFlag;
    protected List<FluidStack> allowedInputs;
    protected FusionCoreProxyBE[] proxyBES;
    protected double lastHeadDeviationMult = 1.0;
    protected double radiationAggregated = 0.0;
    protected long prevAmplification = 0L;

    public FusionCoreBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FusionReactorRegistration.FUSION_BE.get("fusion_core").get(), pPos, pBlockState);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(this.getBaseGTEnergyTier()).setOutputEnergyTier(this.getBaseGTEnergyTier()).setInputAmperage(4L).setOutputAmperage(16L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
        this.contentHandler = new SidedContentHandler(0, 0, 3, 5, 10, 50);
        this.contentHandler().setBlockEntity(this);
        this.contentHandler().fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(1, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(2, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(3, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().fluidHandler.setGlobalMode(4, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().fluidHandler.setGlobalMode(5, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().fluidHandler.setGlobalMode(6, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().fluidHandler.setGlobalMode(7, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().setAllowedInputFluids(0, this::getAllowedInputFluids);
        this.contentHandler().setAllowedInputFluids(1, this::getAllowedInputFluids);
        this.contentHandler().setAllowedInputFluids(2, this::getAllowedCoolants);
        this.contentHandler().setAllowedInputFluids(7, this::getAllowedCoolantsOutput);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).setCapacity(100000);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(7))).setCapacity(100000);
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.FUSION_REACTOR_ENERGY_TIER.get())).ordinal();
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(2048000000, 1000000, 100000000){

            @Override
            protected void onEnergyChanged() {
                FusionCoreBE.this.m_6596_();
            }
        };
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private void initMultiblock() {
        if (this.multiblock == null) {
            this.multiblock = new FusionReactorMultiblock(this);
        }
    }

    public void toggleRedstoneMode() {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode > 13) {
            this.redstoneMode = (byte)11;
        }
        MultiblockHandler.get((ResourceKey<Level>)this.m_58904_().m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 1);
    }

    public List<FusionCoolantRecipe> getCoolantRecipes() {
        if (this.coolantRecipes == null) {
            this.coolantRecipes = NcRecipeType.getAllRecipesFor("fusion_coolant", this.m_58904_());
        }
        return this.coolantRecipes;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new FusionReactorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && FusionCoreBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
                return LazyOptional.empty();
            }
            return this.getEnergy().cast();
        }
        if (ModUtil.isOC2Loaded() && cap == FusionReactorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> FusionReactorDevice.createDevice(this)).cast();
    }

    public void updateAnalogSignal() {
        switch (this.redstoneMode) {
            case 11: {
                this.analogSignal = (byte)((double)this.energyStorage().getEnergyStored() * 15.0 / (double)this.energyStorage().getMaxEnergyStored());
                break;
            }
            case 12: {
                this.analogSignal = (byte)(this.reactorHeat * 15.0 / this.getMaxHeat());
                break;
            }
            case 13: {
                this.analogSignal = (byte)(this.efficiency * 15.0);
            }
        }
    }

    public void onLoad() {
        this.initialized = false;
    }

    public double getMaxHeat() {
        return Math.max(this.minRFAmplifiersTemp * 2, this.maxMagnetsTemp * 2);
    }

    @Override
    public void handleValidation() {
        super.handleValidation();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid) {
            this.stopSound();
            return;
        }
        if (this.playSoundCooldown > 0) {
            --this.playSoundCooldown;
            return;
        }
        if (this.functionalBlocksCharge < 100 && this.functionalBlocksCharge > 0) {
            this.playChargingSound();
            return;
        }
        if (this.isReady()) {
            if (this.energyPerTick > 0 && this.plasmaTemperature > 0L) {
                this.playRunningSound();
                return;
            }
            this.playReadySound();
        } else {
            this.stopSound();
        }
    }

    protected void sendBeamData(FusionBeamParticleData data, BlockPos from) {
        Object object;
        Vec3 vec = Vec3.m_82512_((Vec3i)from);
        if (!this.m_58904_().m_5776_() && (object = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.m_6907_()) {
                serverWorld.m_8624_(player, (ParticleOptions)data, true, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void renderBeam() {
        BlockPosInstance pos = new BlockPosInstance((Vec3i)this.m_58899_().m_7494_());
        int beamLength = this.size * 2 + 4;
        this.sendBeamData(new FusionBeamParticleData(Direction.EAST, beamLength, 0.35f), pos.revert().relative(Direction.NORTH, this.size + 2).relative(Direction.WEST, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.EAST, beamLength, 0.35f), pos.revert().relative(Direction.SOUTH, this.size + 2).relative(Direction.WEST, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.SOUTH, beamLength, 0.35f), pos.revert().relative(Direction.EAST, this.size + 2).relative(Direction.NORTH, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.SOUTH, beamLength, 0.35f), pos.revert().relative(Direction.WEST, this.size + 2).relative(Direction.NORTH, this.size + 2));
    }

    protected void playReadySound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_READY.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        this.playSound(NCSounds.FUSION_READY, 0.7f);
    }

    protected boolean isReady() {
        return this.isCasingValid && this.rfAmplifiersPower > 0 && this.magnetsPower > 0 && this.hasRecipe() && this.functionalBlocksCharge > 99;
    }

    protected void playRunningSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_RUNNING.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        this.playSound(NCSounds.FUSION_RUNNING, 0.5f);
    }

    @Override
    public void tickServer() {
        this.changed = false;
        this.initMultiblock();
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            FusionCoreBlock block = (FusionCoreBlock)this.m_58900_().m_60734_();
            block.placeProxyBlocks(this.m_58900_(), this.f_58857_, this.f_58858_, this);
        }
        super.tickServer();
        this.tickProxyBlocks();
        this.handleValidation();
        this.simulateReaction();
        this.sendOutPower();
        this.handleMeltdown();
        if (this.recipe == null && this.plasmaTemperature > 0L) {
            this.changePlasmaTemperature(-((long)((double)this.plasmaTemperature / 10.0)));
            this.changed = true;
        }
        if (this.refreshCacheFlag || this.changed) {
            if (NuclearCraft.currentTick % 10L == 0L) {
                this.updateAnalogSignal();
            }
            try {
                this.m_6596_();
                assert (this.f_58857_ != null);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 1);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.controllerEnabled = false;
        this.inputRedstoneSignal = 0;
    }

    private void tickProxyBlocks() {
        for (FusionCoreProxyBE proxy : this.getProxies()) {
            if (proxy == null) continue;
            proxy.forceTickServer(this);
        }
    }

    protected List<FluidStack> getAllowedCoolantsOutput() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
            allowedCoolants.addAll(recipe.getOutputFluids(0));
        }
        return allowedCoolants;
    }

    public double getHeatDeviationMultiplier() {
        double mEff = (this.magnetsEfficiency() - 50.0) / 100.0;
        double rEff = (this.rfEfficiency() - 50.0) / 100.0;
        double plasmaStability = (1.0 + this.getControlPartsEfficiency()) / 2.0;
        double minMult = 0.2 * plasmaStability + (mEff + rEff) / 2.0;
        double maxMult = 1.7 * this.getControlPartsEfficiency() - (mEff + rEff) / 2.0;
        double rand = (new Random().nextDouble() + 4.0) / 5.0;
        this.lastHeadDeviationMult = (this.lastHeadDeviationMult + rand * (maxMult - minMult) + minMult) / 2.0;
        return this.lastHeadDeviationMult;
    }

    protected double rfEfficiency() {
        return (double)this.rfEfficiency * Math.min((double)this.minRFAmplifiersTemp / ((this.reactorHeat + (double)this.minRFAmplifiersTemp) / 2.0), 1.0);
    }

    protected double magnetsEfficiency() {
        return (double)this.magnetsEfficiency * Math.min((double)this.maxMagnetsTemp / ((this.reactorHeat + (double)this.maxMagnetsTemp) / 2.0), 1.0);
    }

    public double getOptimalTemperature() {
        if (this.hasRecipe() && ((Recipe)this.recipeInfo().recipe()).getOptimalTemperature() > 0.0) {
            this.lastKnownOptimalTemp = ((Recipe)this.recipeInfo().recipe()).getOptimalTemperature() * 1000000.0;
        }
        return this.lastKnownOptimalTemp;
    }

    public double minimalMagneticField() {
        return (Double)FusionConfig.FUSION_CONFIG.MINIMAL_MAGNETIC_FIELD.get() * ((double)this.plasmaTemperature / this.getOptimalTemperature()) * (double)this.size;
    }

    public double overallMagneticField() {
        return this.magneticFieldStrength / (double)this.size;
    }

    public double getControlPartsEfficiency() {
        return Math.min(1.9, Math.max(0.1, 2.0 / (this.magnetsEfficiency() / 100.0 * (this.minimalMagneticField() / this.overallMagneticField()))));
    }

    public double getPlasmaStability() {
        return (this.getControlPartsEfficiency() / 1.9 + this.calculateEfficiency() * 2.0) / 3.0;
    }

    protected List<FluidStack> getAllowedCoolants() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
            allowedCoolants.addAll(recipe.getInputFluids(0));
        }
        return allowedCoolants;
    }

    @Override
    protected void sendOutPower() {
        for (FusionCoreProxyBE proxy : this.getProxies()) {
            if (proxy == null) continue;
            proxy.sendOutEnergy();
        }
        BlockEntity be = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_121945_(Direction.DOWN));
        if (be instanceof BlockEntity && !(be instanceof FusionCoreProxyBE) && !(be instanceof FusionCoreBE)) {
            IEnergyStorage r = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, Direction.UP).orElse(null);
            if (r == null) {
                return;
            }
            if (r.canReceive()) {
                int received = r.receiveEnergy(this.energyStorage().getEnergyStored() - this.rfAmplifiersPower - this.magnetsPower, false);
                this.energyStorage().setEnergy(this.energyStorage().getEnergyStored() - received);
            }
        }
    }

    protected FusionCoreProxyBE[] getProxies() {
        if (this.proxyBES == null) {
            this.proxyBES = new FusionCoreProxyBE[26];
            int i = 0;
            for (int y = 0; y < 3; ++y) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        FusionCoreProxyBE proxy;
                        BlockEntity be = this.blockEntity(this.m_58899_().m_7918_(x, y, z));
                        if (!(be instanceof FusionCoreProxyBE)) continue;
                        this.proxyBES[i] = proxy = (FusionCoreProxyBE)be;
                        ++i;
                    }
                }
            }
        }
        return this.proxyBES;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<FluidStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
                for (FluidStackIngredient ingredient : recipe.getInputFluids()) {
                    this.allowedInputs.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedInputs;
    }

    protected void simulateReaction() {
        if (!this.getMultiblock().isFormed()) {
            return;
        }
        this.controllerEnabled = (this.hasRedstoneSignal() || this.controllerEnabled) && this.getMultiblock().isFormed();
        this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        this.updateCharge();
        boolean bl = this.controllerEnabled = this.functionalBlocksCharge == 100 && this.controllerEnabled;
        if (this.controllerEnabled) {
            this.powered = this.processReaction();
            this.trackChanges(this.powered);
        } else {
            this.powered = false;
            if (this.plasmaTemperature > 0L) {
                this.plasmaTemperature = (long)Math.max(0.0f, (float)this.plasmaTemperature / 1.2f - 10000.0f);
                this.changed = true;
            }
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
            this.trackChanges(this.hasRecipe());
        }
        this.trackChanges(this.coolDown());
    }

    public long getTargetCharge() {
        return (long)(this.rfAmplifiersPower + this.magnetsPower) * 7L;
    }

    protected void updateCharge() {
        if (this.getTargetCharge() == 0L) {
            return;
        }
        if (this.chargeAmount < this.getTargetCharge()) {
            this.chargeAmount += (long)this.energyStorage().extractEnergy((this.rfAmplifiersPower + this.magnetsPower) / 2, false);
            this.changed = true;
        }
        this.functionalBlocksCharge = (int)Math.min(this.chargeAmount * 100L / this.getTargetCharge(), 100L);
    }

    protected void playChargingSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_CHARGING.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        this.playSound(NCSounds.FUSION_CHARGING, 0.7f);
    }

    @Override
    public FusionReactorMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new FusionReactorMultiblock(this);
        }
        return (FusionReactorMultiblock)this.multiblock;
    }

    public double rfAmplifierRatio() {
        return Math.max(0.0, Math.min((double)this.rfAmplificationRatio / 100.0 * (double)this.amplificationAdjustment / 100.0, 1.0));
    }

    protected void coolantCoolDown() {
        if (this.hasCoolant() && this.reactorHeat > this.coolantRecipe.getCoolingRate()) {
            int coolantNeeded = (int)(this.reactorHeat / this.coolantRecipe.getCoolingRate());
            int coolantPerOp = this.coolantRecipe.getInputFluids()[0].getAmount();
            int availableCoolant = ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).getFluidAmount();
            int possibleOps = availableCoolant / coolantPerOp;
            int actualOps = Math.min(possibleOps, coolantNeeded * coolantPerOp);
            this.changeReactorHeat(-(this.coolantRecipe.getCoolingRate() / (double)this.size) * (double)actualOps);
            this.extractCoolant(actualOps);
        }
    }

    protected void changeReactorHeat(double amount) {
        this.reactorHeat += amount;
        this.reactorHeat = Math.max(0.0, this.reactorHeat);
    }

    protected boolean coolDown() {
        double wasHeat = this.reactorHeat;
        this.changeReactorHeat(-1000.0 * Math.log(this.size + 4));
        this.coolantCoolDown();
        return wasHeat != this.reactorHeat;
    }

    protected void extractCoolant(int ops) {
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).drain(this.coolantRecipe.getInputFluids()[0].getAmount() * ops, IFluidHandler.FluidAction.EXECUTE);
        FluidStack output = this.coolantRecipe.getOutputFluids().get(0).copy();
        output.setAmount(output.getAmount() * ops);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(7))).fill(output, IFluidHandler.FluidAction.EXECUTE);
    }

    protected boolean processReaction() {
        if (this.recipeInfo().recipe != null && this.recipeInfo().isCompleted() && this.contentHandler().fluidHandler.getFluidInSlot(0).equals((Object)FluidStack.EMPTY)) {
            this.recipeInfo().clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    protected boolean process() {
        this.recipeInfo().process(this.efficiency * 4.0);
        if (this.recipeInfo().radiation != 1.0) {
            this.radiationAggregated += this.recipeInfo().radiation / 5000.0;
            if (this.radiationAggregated > 100.0) {
                RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.radiationAggregated, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
                this.radiationAggregated = 0.0;
            }
        }
        if (!this.recipeInfo().isCompleted()) {
            this.simulateHeatExchange();
            if (this.energyPerTick > 0) {
                this.renderBeam();
                this.energyStorage().addEnergy(this.energyPerTick);
            }
        }
        this.handleRecipeOutput();
        this.efficiency = this.calculateEfficiency();
        return true;
    }

    protected double calculateEfficiency() {
        double temperatureEfficiency = (double)this.plasmaTemperature / this.getOptimalTemperature();
        if ((double)this.plasmaTemperature > this.getOptimalTemperature()) {
            temperatureEfficiency = this.getOptimalTemperature() / (double)this.plasmaTemperature + 0.1;
        }
        return temperatureEfficiency;
    }

    protected void changePlasmaTemperature(long amount) {
        this.plasmaTemperature += amount;
        this.plasmaTemperature = Math.max(0L, this.plasmaTemperature);
    }

    protected void simulateHeatExchange() {
        this.amplifyPlasma();
        this.plasmaToEnergyExchange();
        this.heatLossExchange();
    }

    protected void heatLossExchange() {
        double sizeFactor = Math.log(Math.pow(this.size + 2, 2.0)) / 100.0;
        this.changePlasmaTemperature((long)(-((double)this.plasmaTemperature / Math.pow(this.getControlPartsEfficiency(), 2.0) * sizeFactor)));
        this.changeReactorHeat((double)Math.min(this.plasmaTemperature, 100000000L) / (10000.0 * Math.log(this.size + 4) * this.getControlPartsEfficiency()));
    }

    protected void plasmaToEnergyExchange() {
        double optimalTemp = this.getOptimalTemperature();
        double sizeFactor = Math.log(Math.pow(this.size + 1, 8.0)) / 8.0;
        this.energyPerTick = (double)this.plasmaTemperature < optimalTemp ? (int)((double)this.plasmaTemperature / optimalTemp * this.recipeInfo().recipe().getEnergy()) : (int)(optimalTemp / (double)this.plasmaTemperature * this.recipeInfo().recipe().getEnergy());
        this.changePlasmaTemperature(-((long)((double)this.plasmaTemperature / (150.0 * (double)this.energyPerTick / this.recipeInfo().recipe().getEnergy()))));
        this.energyPerTick = (int)((double)this.energyPerTick * this.calculateEfficiency() * (double)this.size * sizeFactor * (Double)FusionConfig.FUSION_CONFIG.PLASMA_TO_ENERGY_CONVERTION.get());
        if (this.plasmaTemperature < 1000000L) {
            this.energyPerTick = 0;
        }
        this.energyPerTick = (int)((double)this.energyPerTick * this.getControlPartsEfficiency());
    }

    protected void amplifyPlasma() {
        double sizeFactor = Math.log(Math.pow(this.size + 1, 5.0)) / 10.0;
        double pRatio = Math.log(this.getOptimalTemperature() / 1.5E8);
        double plasmaHeatScale = (pRatio - Math.sqrt(pRatio) + 5.0) / 7.0;
        double amplificationVolume = (double)this.rfAmplification * sizeFactor;
        double amplification = amplificationVolume * plasmaHeatScale * this.rfAmplifierRatio() * this.getHeatDeviationMultiplier() * (Double)FusionConfig.FUSION_CONFIG.RF_AMPLIFICATION_MULTIPLIER.get();
        this.prevAmplification += (long)(amplification / 1000.0);
        this.prevAmplification = (long)Math.min((double)this.prevAmplification, amplification);
        this.changePlasmaTemperature(this.prevAmplification);
    }

    protected void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo().isCompleted()) {
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo().recipe();
            }
            if (this.recipe.handleOutputs(this.contentHandler)) {
                this.updateRecipe();
            } else {
                this.recipeInfo().stuck = true;
            }
            this.m_6596_();
        }
    }

    protected void updateRecipe() {
        if (this.recipe != null) {
            if (this.recipe.test(this.contentHandler())) {
                this.recipeInfo().ticksProcessed = 0.0;
                if (this.recipeInfo().consumeInputs(this.contentHandler())) {
                    return;
                }
                this.recipe = null;
                this.recipeInfo().clear();
            } else {
                this.recipeInfo().clear();
            }
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = (int)(this.recipeInfo().recipe().getTimeModifier() * 10.0);
            this.recipeInfo().energy = this.recipeInfo().recipe.getEnergy();
            this.recipeInfo().heat = ((Recipe)this.recipeInfo().recipe()).getHeat();
            this.recipeInfo().radiation = this.recipeInfo().recipe().getRadiation();
            this.recipeInfo().be = this;
            if (!this.recipe.consumeInputs(this.contentHandler, 1)) {
                this.recipeInfo().clear();
                this.recipe = null;
            }
        } else {
            this.recipeInfo().clear();
        }
    }

    @Override
    public Recipe getRecipe() {
        if (this.contentHandler().fluidHandler.getFluidInSlot(0).isEmpty() || this.contentHandler().fluidHandler.getFluidInSlot(0).isEmpty()) {
            return null;
        }
        return (Recipe)super.getRecipe();
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo().isStuck();
    }

    protected void handleMeltdown() {
        if (!this.isCasingValid) {
            return;
        }
        if (this.reactorHeat > this.getMaxHeat() && this.plasmaTemperature > 10000L) {
            this.meltDown();
            this.plasmaTemperature = (long)((double)this.plasmaTemperature / 5.0);
            this.reactorHeat /= 2.0;
        }
    }

    private void meltDown() {
        double explosionRadius = (Double)FusionConfig.FUSION_CONFIG.EXPLOSION_RADIUS.get();
        if (explosionRadius > 0.0) {
            BlockPos pos = this.getRandomPosAtRing();
            this.m_58904_().m_254849_((Entity)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)explosionRadius, Level.ExplosionInteraction.TNT);
        }
    }

    private BlockPos getRandomPosAtRing() {
        BlockPos pos = this.m_58899_();
        int xDir = this.m_58904_().f_46441_.m_188499_() ? 1 : -1;
        int zDir = this.m_58904_().f_46441_.m_188499_() ? 1 : -1;
        int x = xDir * this.size;
        int z = zDir * this.size;
        int y = 1;
        return pos.m_7918_(x, y, z);
    }

    public boolean hasRedstoneSignal() {
        return this.inputRedstoneSignal > 0;
    }

    public boolean hasRecipe() {
        return this.recipeInfo().recipe() != null;
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public void voidFuel() {
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).setFluid(FluidStack.EMPTY);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).setFluid(FluidStack.EMPTY);
        this.contentHandler().clearHolded();
    }

    @Override
    public void handleSliderUpdate(int buttonId, int ratio) {
        if (buttonId == 0) {
            this.amplificationAdjustment = Math.min(100, Math.max(ratio, 1));
            this.changed = this.getMultiblock().updateCharacteristics();
        }
    }

    public boolean hasCoolant() {
        FluidStack coolant = this.contentHandler().fluidHandler.getFluidInSlot(2);
        if (coolant.isEmpty()) {
            this.coolantRecipe = null;
            return false;
        }
        if (this.coolantRecipe == null) {
            for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
                if (!recipe.getInputFluids()[0].test(coolant)) continue;
                this.coolantRecipe = recipe;
                return true;
            }
        } else if (!this.coolantRecipe.getInputFluids()[0].test(coolant)) {
            this.coolantRecipe = null;
            return false;
        }
        return this.coolantRecipe instanceof FusionCoolantRecipe;
    }

    public boolean hasEnoughEnergy() {
        return this.energyStorage().getEnergyStored() > this.rfAmplifiersPower + this.magnetsPower;
    }

    public boolean isRunning() {
        return this.powered && this.energyPerTick > 0 && this.plasmaTemperature > 0L && this.efficiency > 0.0;
    }

    public boolean canAnalyze() {
        return this.analyzeDelay < 1;
    }

    @Override
    public HashMap<String, String> getAnalyzeReport() {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("report.nc.1.fusion_size", String.valueOf(this.size));
        report.put("report.nc.2.magnets", String.valueOf(this.magnets));
        report.put("report.nc.3.amplifiers", String.valueOf(this.amplifiers));
        report.put("report.nc.4.fusion_rf_amplification", String.valueOf(this.rfAmplification));
        report.put("report.nc.5.casing_blocks", String.valueOf(this.casingBlocks));
        report.put("report.nc.6.connectors", String.valueOf(this.connectors));
        return report;
    }

    public void voidFluidSlot(int slotId) {
        if (this.contentHandler() != null) {
            this.contentHandler().voidFluidSlot(slotId);
            this.m_6596_();
        }
    }

    public static class SignalSource {
        public static final byte ENERGY = 11;
        public static final byte HEAT = 12;
        public static final byte EFFICIENCY = 13;
    }

    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiation, double temperature) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, radiation, temperature);
        }

        @Override
        @NotNull
        public String m_6076_() {
            return ((Block)FusionReactorRegistration.FUSION_BLOCKS.get(this.codeId).get()).m_49954_().getString();
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FusionReactorRegistration.FUSION_BLOCKS.get(this.codeId).get());
        }

        @Override
        public double getEnergy() {
            return this.powerModifier;
        }

        public double getHeat() {
            return this.powerModifier;
        }

        @Override
        public double getRadiation() {
            return this.radiationModifier;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            super.write(buffer);
            buffer.writeDouble(this.getOptimalTemperature());
        }

        public double getOptimalTemperature() {
            return this.rarityModifier;
        }

        @Override
        public String getCodeId() {
            return "fusion_core";
        }
    }

    public static class FusionCoolantRecipe
    extends NcRecipe {
        protected double coolingRate;

        public FusionCoolantRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double temperature, double powerModifier, double radiation, double rar) {
            super(id, input, output, inputFluids, outputFluids, temperature, powerModifier, radiation, rar);
            this.coolingRate = temperature;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "fusion_coolant";
        }

        @Override
        public String getCodeId() {
            return "fusion_coolant";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_core").get());
        }

        public double getCoolingRate() {
            return Math.max(this.rarityModifier, 1.0);
        }
    }
}

