/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.kugelblitz.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.FusionReactorDevice;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.kugelblitz.KugelblitzMultiblock;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ChamberPortBE
extends NuclearCraftBE
implements MultiblockAttachable {
    public static String NAME = "chamber_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte comparatorMode = 1;
    @NBTField
    public BlockPos controllerPos;
    protected KugelblitzMultiblock multiblock;
    public boolean refreshCacheFlag = true;
    public byte validationRuns = 0;
    public ChamberTerminalBE controller;

    public ChamberPortBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)KugelblitzRegistration.KUGELBLITZ_BE.get(NAME).get(), pPos, pBlockState);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public void setMultiblock(AbstractMultiblock multiblock) {
        if (this.multiblock == multiblock) {
            return;
        }
        this.multiblock = (KugelblitzMultiblock)multiblock;
        if (this.multiblock != null) {
            this.controllerPos = this.multiblock.controller().controllerBE().m_58899_();
            this.controller = (ChamberTerminalBE)this.multiblock.controller().controllerBE();
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public KugelblitzMultiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        super.tickServer();
        byte wasSignal = this.analogSignal;
        if (this.getMultiblock() != null || this.controller() != null) {
            this.sendOutPower();
        }
        boolean updated = this.updateController();
        if (this.hasRedstoneSignal() && this.controller() != null) {
            this.controller().controllerEnabled = true;
        }
        if (this.controller() != null) {
            this.updateAnalogSignal();
            updated = wasSignal != this.analogSignal || updated;
            switch (this.comparatorMode) {
                case 5: {
                    this.controller().frequency = this.analogSignal;
                    break;
                }
                case 6: {
                    this.controller().energyConvertionRate = this.analogSignal / 15 * 100;
                }
            }
            Direction dir = this.getFacing();
            if (this.fluidHandler() != null) {
                boolean bl = updated = this.fluidHandler().pullFluids(dir, false, this.f_58858_) || updated;
            }
        }
        if (updated) {
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    private boolean updateController() {
        boolean result = false;
        if (this.controller != this.controller()) {
            this.controller = this.controller();
            this.controllerPos = BlockPos.f_121853_;
            result = true;
        }
        if (this.controller != null) {
            this.controllerPos = new BlockPos((Vec3i)this.controller.m_58899_());
            result = true;
        }
        return result;
    }

    @Override
    protected void transferEnergyToSide(Direction direction) {
        if (this.getEnergyStored() <= 0) {
            return;
        }
        int wasEnergy = this.getEnergyStored();
        BlockEntity be = this.f_58857_.getExistingBlockEntity(this.f_58858_.m_121945_(direction));
        if (be == null || be instanceof ChamberPortBE || be instanceof ChamberTerminalBE) {
            return;
        }
        if (ModUtil.isGtLoaded() && ChamberPortBE.isGTEUCapEnabled()) {
            GTUtils.transferEU(this.controller(), be, this.controller().energyStorage(), direction);
        }
        if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
            return;
        }
        if (wasEnergy - this.getEnergyStored() >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int extracted = wasEnergy - this.controller().energyStorage().getEnergyStored();
        if (extracted >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int canExtract = Math.min(this.controller().energyStorage().getMaxExtract() - extracted, this.getEnergyStored());
        be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
            if (handler.canReceive()) {
                int received = handler.receiveEnergy(canExtract, false);
                this.controller().energyStorage().consumeEnergy(received);
                this.controller().m_6596_();
                return this.getEnergyStored() > 0;
            }
            return true;
        });
    }

    private void updateAnalogSignal() {
        if (this.controller() == null) {
            this.analogSignal = 0;
            return;
        }
        switch (this.comparatorMode) {
            case 1: {
                this.analogSignal = (byte)(this.controller().energyStorage().getEnergyStored() * 15 / this.controller().energyStorage().getMaxEnergyStored());
                break;
            }
            case 2: {
                this.analogSignal = (byte)(this.controller().mass * 15L / BlackHoleBE.MAX_MASS);
                break;
            }
            case 3: {
                this.analogSignal = (byte)(this.getProgress() / 100.0 * 15.0);
                break;
            }
            case 4: {
                this.analogSignal = (byte)(this.controller().contentHandler().itemHandler.getStackInSlot(0).m_41613_() * 15 / this.controller().contentHandler().itemHandler.getStackInSlot(0).m_41741_());
                break;
            }
            case 5: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
                break;
            }
            case 6: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
            }
        }
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler().fluidHandler;
    }

    protected <T> LazyOptional<T> fluidHandler(@Nullable Direction side) {
        return this.controller().contentHandler().getFluidCapability(side);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && ChamberPortBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this.controller(), side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.controller().getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == FusionReactorDevice.DEVICE_CAPABILITY) {
            return this.controller().getOCDevice(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public ChamberTerminalBE controller() {
        if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().f_46443_ && this.controllerPos != null) {
            return (ChamberTerminalBE)this.m_58904_().getExistingBlockEntity(this.controllerPos);
        }
        try {
            return (ChamberTerminalBE)this.getMultiblock().controller().controllerBE();
        }
        catch (NullPointerException e) {
            if (this.controllerPos != null) {
                return (ChamberTerminalBE)this.m_58904_().getExistingBlockEntity(this.controllerPos);
            }
            return null;
        }
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyPerTick;
    }

    public void toggleComparatorMode() {
        this.comparatorMode = (byte)(this.comparatorMode + 1);
        if (this.comparatorMode > 6) {
            this.comparatorMode = 1;
        }
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public double getProgress() {
        if (this.controller() == null) {
            return 0.0;
        }
        return this.controller().recipeInfo().getProgress();
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte MASS = 2;
        public static final byte PROGRESS = 3;
        public static final byte ITEMS = 4;
        public static final byte FREQUENCY = 5;
        public static final byte TRANSFORMATION_ENERGY_RATE = 6;
    }
}

