/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.target_chamber.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.target_chamber.TargetChamberControllerBlock;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.TargetChamberPeripheral;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.TargetChamberDevice;
import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.content.particles.IParticleStackHandler;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.ParticleStorage;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.particle_chamber.TargetChamberMultiblock;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.TargetChamberRecipe;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class TargetChamberControllerBE
extends MultiblockControllerBE {
    public static final String NAME = "target_chamber_controller";
    public final SidedContentHandler contentHandler = new SidedContentHandler(1, 1, 1, 1, new int[0]);
    public final CustomEnergyStorage energyStorage;
    protected final LazyOptional<IEnergyStorage> energy;
    protected final LazyOptional<IParticleStackHandler> particleHandler;
    public final ParticleStorage particleStorage;
    @NBTField
    public int detectorsCount = 0;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public boolean powered = false;
    public int connectedPorts = 0;
    protected boolean forceShutdown = false;
    @NBTField
    public boolean enabledByController = false;
    public boolean controllerEnabled = false;
    private Direction facing;
    private List<ItemStack> allowedInputs;
    @NBTField
    public boolean hasRedstoneSignal = false;
    @NBTField
    public int allDetectors = 0;
    @NBTField
    public boolean hasParticle = false;
    private LazyOptional<TargetChamberPeripheral> peripheralCap;
    public float speed = 0.001f;

    public TargetChamberControllerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TargetChamberRegistration.TARGET_CHAMBER_BE.get(NAME).get(), pPos, pBlockState);
        this.contentHandler().setBlockEntity(this);
        this.contentHandler().itemHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().itemHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler().fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().fluidHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(this.getBaseGTEnergyTier()).setOutputEnergyTier(0L).setInputAmperage(16L).setOutputAmperage(0L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
        this.particleStorage = new ParticleStorage();
        this.particleStorage.setTileEntity(this);
        this.particleHandler = CapabilityParticleStackHandler.createHandler(this.particleStorage);
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.ACCELERATORS_ENERGY_TIER.get())).ordinal();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("target_chamber", this.m_58904_())) {
                for (Ingredient ingredient : recipe.getItemIngredients()) {
                    this.allowedInputs.addAll(List.of(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputs;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.particleStorage.readFromNBT(infoTag.m_128469_("particle_storage"));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128365_("particle_storage", (Tag)this.particleStorage.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        super.loadClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.particleStorage.readFromNBT(infoTag.m_128469_("particle_storage"));
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        super.saveClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128365_("particle_storage", (Tag)this.particleStorage.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 100000000, 0){

            @Override
            protected void onEnergyChanged() {
                TargetChamberControllerBE.this.m_6596_();
            }
        };
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new TargetChamberPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> TargetChamberDevice.createDevice(this)).cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.particleHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler().getFluidCapability(side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.contentHandler().getItemCapability(side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && TargetChamberControllerBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isOC2Loaded() && cap == TargetChamberDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            this.controllerEnabled = false;
            return;
        }
        this.changed = false;
        super.tickServer();
        boolean wasFormed = this.getMultiblock().isFormed();
        boolean wasEnabled = this.controllerEnabled;
        boolean wasPowered = this.powered;
        this.handleValidation();
        this.hasParticle = this.particleStorage.getParticleStack() != null;
        this.trackChanges(this.hasParticle);
        this.controllerEnabled = this.hasRedstoneSignal() && this.getMultiblock().isFormed();
        boolean bl = this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        if (this.getMultiblock().isFormed()) {
            this.trackChanges(this.contentHandler().tick());
            this.powered = this.controllerEnabled ? this.processReaction() : false;
        }
        this.changed = this.powered != wasPowered || this.changed;
        boolean bl2 = this.refreshCacheFlag = !this.getMultiblock().isFormed();
        if (this.refreshCacheFlag || this.changed || NuclearCraft.currentTick % 40L == 0L) {
            try {
                assert (this.f_58857_ != null);
                this.m_6596_();
                if (this.powered != wasPowered) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TargetChamberControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
                }
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)TargetChamberControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.particleStorage.setParticleStack(null);
        this.particleStorage.outputParticles.clear();
    }

    @Override
    public HashMap<String, String> getAnalyzeReport() {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("report.nc.1.target_chamber.all_detectors", String.valueOf(this.allDetectors));
        report.put("report.nc.2.target_chamber.valid_detectors", String.valueOf(this.detectorsCount));
        return report;
    }

    @Override
    protected void handleValidation() {
        super.handleValidation();
    }

    @Override
    public TargetChamberMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new TargetChamberMultiblock(this);
        }
        return (TargetChamberMultiblock)this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private boolean processReaction() {
        if (this.recipeInfo().recipe != null && this.recipeInfo().isCompleted() && this.contentHandler().itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            this.recipeInfo().clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    private boolean process() {
        if (this.recipeInfo().be == null) {
            this.recipeInfo().be = this;
        }
        if (this.particleStorage.getParticle() == null) {
            return false;
        }
        this.recipeInfo().process((double)this.particleStorage.getParticle().getAmount() * ((Recipe)this.recipe).crossSection * this.efficiency / 100.0);
        this.extractParticles();
        if (this.recipeInfo().radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo().radiation / 10000.0, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        this.energyStorage().consumeEnergy(this.energyPerTick);
        this.handleRecipeOutput();
        return true;
    }

    private void extractParticles() {
        int id = 0;
        for (ParticleStack outputParticle : ((Recipe)this.recipeInfo().recipe()).outputParticles) {
            if (outputParticle == null || outputParticle.getAmount() <= 0) continue;
            this.getMultiblock().extractParticle(id, outputParticle);
            this.particleStorage.outputParticles.add(outputParticle);
        }
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo().isCompleted()) {
            if (this.recipe == null) {
                this.recipe = this.recipeInfo().recipe();
            }
            if (this.recipe.handleOutputs(this.contentHandler)) {
                this.updateRecipe();
            } else {
                this.recipeInfo().stuck = true;
            }
            this.m_6596_();
        }
    }

    @Override
    public Recipe getRecipe() {
        if (this.contentHandler().itemHandler.getStackInSlot(0).equals(ItemStack.f_41583_)) {
            return null;
        }
        Recipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey("target_chamber")) {
            return null;
        }
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("target_chamber", this.m_58904_())) {
            if (!((Recipe)recipe).test(this.contentHandler(), this.particleStorage)) continue;
            this.addToCache(recipe);
            return (Recipe)recipe;
        }
        return null;
    }

    @Override
    public Recipe getCachedRecipe() {
        Recipe recipeTest;
        Object v;
        String key = this.contentHandler().getCacheKey() + this.particleStorage.getCacheKey();
        if (this.cachedRecipes.containsKey(key) && (v = this.cachedRecipes.get(key)) instanceof Recipe && (recipeTest = (Recipe)v).test(this.contentHandler(), this.particleStorage)) {
            return recipeTest;
        }
        return null;
    }

    @Override
    protected void addToCache(NcRecipe recipe) {
        String key = this.contentHandler().getCacheKey() + this.particleStorage.getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    protected void updateRecipe() {
        if (this.recipe != null) {
            if (((Recipe)this.recipe).test(this.contentHandler(), this.particleStorage)) {
                this.recipeInfo().ticksProcessed = 0.0;
                if (this.recipeInfo().consumeInputs(this.contentHandler())) {
                    return;
                }
                this.recipe = null;
                this.recipeInfo().clear();
            } else {
                this.recipeInfo().clear();
            }
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = ((Recipe)this.recipe).getAmount();
            this.recipeInfo().energy = this.recipeInfo().recipe().getEnergy();
            this.recipeInfo().radiation = this.recipeInfo().recipe().getRadiation();
            this.recipeInfo().be = this;
            if (!this.recipe.consumeInputs(this.contentHandler, 1)) {
                this.recipe = null;
                this.recipeInfo().clear();
            }
        } else {
            this.recipeInfo().clear();
        }
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo().isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo().recipe() != null;
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    public double getRecipeProgress() {
        return this.recipeInfo().getProgress();
    }

    public boolean hasRedstoneSignal() {
        if (NuclearCraft.currentTick % 10L == 0L) {
            this.hasRedstoneSignal = this.m_58904_().m_276867_(this.m_58899_());
        }
        return this.enabledByController || this.hasRedstoneSignal;
    }

    public Object[] getFuel() {
        return this.contentHandler().itemHandler.getSlotContent(0);
    }

    public void voidFuel() {
        this.contentHandler().voidSlot(0);
        this.contentHandler().itemHandler.holdedInputs.clear();
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public ItemStack getCurrentFuel() {
        if (!this.hasRecipe()) {
            return ItemStack.f_41583_;
        }
        return this.recipeInfo().recipe().getFirstItemStackIngredient(0);
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo().ticksProcessed > 0.0 && !this.recipeInfo().isCompleted();
    }

    public void enableReactor() {
        this.toggleReactor(true);
    }

    public void toggleReactor(boolean mode) {
        this.controllerEnabled = mode || this.getRedstoneSignal() > 0;
        this.enabledByController = mode;
    }

    @Override
    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    public void refresh() {
        this.m_6596_();
    }

    public ParticleStack getParticleStack() {
        return this.particleStorage.getParticle();
    }

    public ParticleStack getOutputParticle(int i) {
        if (!this.hasRecipe()) {
            return null;
        }
        return ((Recipe)this.recipeInfo().recipe).outputParticles.length > i ? ((Recipe)this.recipeInfo().recipe).outputParticles[i] : null;
    }

    public static class Recipe
    extends TargetChamberRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, ParticleStack[] inputParticles, ParticleStack[] outputParticles, long maxEnergy, double crossSection) {
            super(id, input, output, inputFluids, outputFluids, inputParticles, outputParticles, maxEnergy, crossSection);
            GlobalVars.CATALYSTS.put(TargetChamberControllerBE.NAME, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return "target_chamber";
        }

        @Override
        @NotNull
        public String m_6076_() {
            return ((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(this.codeId).get()).m_49954_().getString();
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(TargetChamberControllerBE.NAME).get());
        }

        public ParticleStack getOutputParticle(int i) {
            return i < this.outputParticles.length ? this.outputParticles[i] : null;
        }

        public boolean test(SidedContentHandler sidedContentHandler, ParticleStorage particleStorage) {
            return super.test(sidedContentHandler) && this.testParticle(particleStorage);
        }

        private boolean testParticle(ParticleStorage particleStorage) {
            if (this.inputParticles == null || this.inputParticles.length == 0) {
                return true;
            }
            ParticleStack particleStack = particleStorage.getParticle();
            if (particleStack == null) {
                return false;
            }
            for (ParticleStack inputParticle : this.inputParticles) {
                if (!inputParticle.getParticle().equals(particleStack.getParticle()) || inputParticle.getMeanEnergy() > particleStack.getMeanEnergy() || this.maxEnergy < particleStack.getMeanEnergy() || !(inputParticle.getFocus() <= particleStack.getFocus())) continue;
                return true;
            }
            return false;
        }

        public int getAmount() {
            if (this.inputParticles == null || this.inputParticles.length == 0) {
                return 10000;
            }
            return this.inputParticles[0].getAmount();
        }
    }
}

