/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.target_chamber.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.TargetChamberDevice;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.particle_chamber.TargetChamberMultiblock;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TargetChamberPortBE
extends NuclearCraftBE
implements MultiblockAttachable {
    public static final String NAME = "target_chamber_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte redstoneMode = (byte)2;
    @NBTField
    public BlockPos controllerPos;
    public boolean isSteamMode = false;
    @NBTField
    public boolean connected = false;
    protected TargetChamberMultiblock multiblock;
    protected TargetChamberControllerBE controller;

    public TargetChamberPortBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TargetChamberRegistration.TARGET_CHAMBER_BE.get(NAME).get(), pPos, pBlockState);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    public TargetChamberMultiblock getMultiblock() {
        return this.multiblock;
    }

    private boolean updateController() {
        boolean result = false;
        if (this.controller != this.controller()) {
            this.controller = this.controller();
            this.controllerPos = BlockPos.f_121853_;
            result = true;
        }
        if (this.controller != null) {
            this.controllerPos = new BlockPos((Vec3i)this.controller.m_58899_());
            result = true;
        }
        return result;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        byte wasSignal = this.analogSignal;
        boolean wasConnected = this.connected;
        if (this.getMultiblock() != null && this.controller() != null) {
            this.sendOutPower();
        }
        boolean updated = this.updateController();
        if (NuclearCraft.currentTick % 20L == 0L && this.controller() != null) {
            this.pushPull();
        }
        if (NuclearCraft.currentTick % 10L == 0L && this.controller() != null) {
            this.updateAnalogSignal();
            boolean bl = updated = wasSignal != this.analogSignal || updated;
            if (this.redstoneMode == 5) {
                this.controller().toggleReactor(this.analogSignal > 0);
            }
        }
        boolean bl = this.connected = this.getMultiblock() != null && this.getMultiblock().isFormed();
        if (updated || wasConnected != this.connected || NuclearCraft.currentTick % 20L == 0L) {
            if (this.connected) {
                MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            }
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private boolean pushPull() {
        boolean pushed = false;
        if (this.itemHandler() != null) {
            Direction dir = this.getFacing();
            pushed = this.itemHandler().pushItems(dir, true, this.f_58858_);
            pushed = this.itemHandler().pullItems(dir, true, this.f_58858_) || pushed;
        }
        return pushed;
    }

    private void updateAnalogSignal() {
        switch (this.redstoneMode) {
            case 1: {
                this.analogSignal = (byte)(this.controller().energyStorage().getEnergyStored() * 15 / this.controller().energyStorage().getMaxEnergyStored());
                break;
            }
            case 3: {
                this.analogSignal = (byte)(this.controller().recipeInfo().ticksProcessed * 15.0 / (double)this.controller().recipeInfo().ticks);
                break;
            }
            case 4: {
                this.analogSignal = (byte)(this.itemHandler().getStackInSlot(0).m_41613_() * 15 / this.itemHandler().getStackInSlot(0).m_41741_());
                break;
            }
            case 5: {
                this.analogSignal = (byte)Math.max(0, this.getRedstoneSignal());
            }
        }
    }

    @Override
    protected void transferEnergyToSide(Direction direction) {
    }

    protected ItemCapabilityHandler itemHandler() {
        return this.controller().contentHandler().itemHandler;
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler().fluidHandler;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && TargetChamberPortBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this.controller(), side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.controller().getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isOC2Loaded() && cap == TargetChamberDevice.DEVICE_CAPABILITY) {
            return this.controller().getOCDevice(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    public void setMultiblock(AbstractMultiblock multiblock) {
        if (multiblock == this.multiblock) {
            return;
        }
        this.multiblock = (TargetChamberMultiblock)multiblock;
        if (this.multiblock != null) {
            this.controllerPos = this.multiblock.controller().controllerBE().m_58899_();
            this.controller = (TargetChamberControllerBE)this.multiblock.controller().controllerBE();
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public TargetChamberControllerBE controller() {
        block5: {
            MultiblockControllerBE be;
            if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
                return null;
            }
            if (this.controller == null && this.m_58904_().f_46443_ && this.controllerPos != null && (be = this.m_58904_().getExistingBlockEntity(this.controllerPos)) instanceof TargetChamberControllerBE) {
                TargetChamberControllerBE controllerBe;
                this.controller = controllerBe = (TargetChamberControllerBE)be;
                return this.controller;
            }
            try {
                be = this.getMultiblock().controller().controllerBE();
                if (be instanceof TargetChamberControllerBE) {
                    TargetChamberControllerBE controllerBe;
                    this.controller = controllerBe = (TargetChamberControllerBE)be;
                    return this.controller;
                }
            }
            catch (NullPointerException e) {
                TargetChamberControllerBE controllerBe;
                BlockEntity be2;
                if (this.controllerPos == null || !((be2 = this.m_58904_().getExistingBlockEntity(this.controllerPos)) instanceof TargetChamberControllerBE)) break block5;
                this.controller = controllerBe = (TargetChamberControllerBE)be2;
            }
        }
        return this.controller;
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getEnergyStored();
    }

    public double getDepletionProgress() {
        if (this.controller() == null) {
            return 0.0;
        }
        return this.controller().getRecipeProgress();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyPerTick;
    }

    public ParticleStack getParticleStack() {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().particleStorage.getParticle();
    }

    public ParticleStack getOutputParticle(int i) {
        return this.controller() != null && this.controller().getRecipe() != null ? this.controller().getRecipe().getOutputParticle(i) : null;
    }

    public void toggleRedstoneMode() {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode > 6) {
            this.redstoneMode = 1;
        }
        this.analogSignal = 0;
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public boolean hasParticle() {
        if (this.controller() == null) {
            return false;
        }
        return this.controller().hasParticle;
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte HEAT = 2;
        public static final byte PROGRESS = 3;
        public static final byte ITEMS = 4;
        public static final byte SWITCH = 5;
        public static final byte MODERATOR = 6;
    }
}

