/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.turbine;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.container.TurbineControllerContainer;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class TurbineControllerScreen
extends AbstractContainerScreen<TurbineControllerContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = NuclearCraft.rl("textures/gui/turbine/controller.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();

    public TurbineControllerContainer container() {
        return (TurbineControllerContainer)this.f_97732_;
    }

    public TurbineControllerScreen(TurbineControllerContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 176;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(this.f_97726_ - 19, 80, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(this.f_97726_ - 32, 80, this, this.isInteriorValid());
        this.widgets.add(new ProgressBar(74, 35, this, 7));
        this.widgets.add(new Button.ReportIssue(163, 6, this, ((TurbineControllerContainer)this.f_97732_).getPosition()));
        this.energyBar = new VerticalBar.Energy(17, 16, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.addWidget(FluidTankRenderer.tank(this.getFluidTank(0)).id(0).size(18, 18).pos(56, 35).canVoid());
        this.addWidget(FluidTankRenderer.tank(this.getFluidTank(1)).id(1).size(24, 24).pos(112, 31).canVoid());
    }

    protected void addWidget(NCGuiElement widget) {
        widget.setScreen(this);
        this.widgets.add(widget);
    }

    protected FluidTank getFluidTank(int i) {
        return ((TurbineControllerContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid() && this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid() && this.isCasingValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid() && this.isCasingValid()) {
            this.checkboxInterior.addTooltip((Component)TextUtils.__("turbine.active.coils", this.container().getActiveCoils()));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("turbine.blades.flow", this.container().getMaxFlow()));
            if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
                this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.turbine.max_eu_energy", GTUtils.formatEUEnergy(this.container().getMaxEnergyGen())));
            } else {
                this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.turbine.max_energy", TextUtils.formatEnergy(this.container().getMaxEnergyGen())));
            }
        }
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((TurbineControllerContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        this.casingTootip = this.isCasingValid() ? TextUtils.applyFormat((Component)TextUtils.__("tooltip.nc.structure.size", this.getMultiblockHeight(), this.getMultiblockWidth(), this.getMultiblockDepth()), ChatFormatting.GOLD) : TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                if (this.container().getRealFlow() != 0 && !this.container().getEfficiency().equals("0") && this.container().isRunning()) {
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("turbine.efficiency", this.container().getEfficiency()), 35, 82, 0xFFFFFF);
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("turbine.real_flow", this.container().getRealFlow()), 35, 72, 0xFFFFFF);
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("turbine.ratio", this.container().getFlowRatio()), 35, 62, 0xFFFFFF);
                }
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    private int getMultiblockHeight() {
        return this.container().getHeight();
    }

    private int getMultiblockWidth() {
        return this.container().getWidth();
    }

    private int getMultiblockDepth() {
        return this.container().getDepth();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.container().getMaxEnergy() > 0) {
            this.energyBar.clearTooltips();
            if (this.container().isRunning()) {
                this.energyBar.addTooltip((Component)TextUtils.__(TextUtils.energyGenLine(), this.container().energyPerTick()));
            }
            if (this.energyBar.m_5953_(pMouseX, pMouseY)) {
                graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return 0.0;
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }

    @Override
    public double getProgress() {
        return 0.0;
    }
}

