/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.model;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.model.animation.AttackAnimation;
import igentuman.nc.client.model.animation.BossAnimation;
import igentuman.nc.client.model.animation.RadiationBurstAnimation;
import igentuman.nc.client.model.animation.RangeAttackAnimation;
import igentuman.nc.client.model.animation.SlamAnimation;
import igentuman.nc.client.model.animation.SummonAnimation;
import igentuman.nc.entity.EntityWastelandBoss;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ModelWastelandBoss<T extends EntityWastelandBoss>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(NuclearCraft.rl("wasteland_boss"), "main");
    private BossAnimation currentAnimation = null;
    private float animationEndTime = 2.1474836E9f;
    private float currentAnimationTime = 0.0f;
    private boolean isAnimating = false;
    public ModelPart root;

    public ModelWastelandBoss(ModelPart root) {
        super(root);
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation none = CubeDeformation.f_171458_;
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171488_(-7.0f, -16.0f, -7.0f, 14.0f, 13.0f, 14.0f, none).m_171514_(0, 86).m_171488_(-5.0f, -3.0f, -3.0f, 10.0f, 4.0f, 8.0f, none), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition bottom = head.m_171599_("bottom", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.25f, (float)-7.0f, (float)0.25f));
        bottom.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(36, 86).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)5.0f, (float)0.9718f, (float)-7.3048f, (float)0.1772f, (float)-0.1719f, (float)-0.0306f));
        bottom.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(48, 89).m_171488_(-0.5f, 0.5f, -0.5f, 1.0f, 1.0f, 1.0f, none), PartPose.m_171423_((float)3.5f, (float)0.9718f, (float)-7.3048f, (float)0.1752f, (float)0.0859f, (float)0.0152f));
        bottom.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(84, 56).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none).m_171514_(44, 89).m_171488_(-3.5f, 0.5f, -0.5f, 1.0f, 1.0f, 1.0f, none).m_171514_(68, 56).m_171488_(-8.0f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)2.0f, (float)0.9718f, (float)-7.3048f, (float)0.1745f, (float)0.0f, (float)0.0f));
        bottom.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(80, 56).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)0.5f, (float)0.9718f, (float)-7.3048f, (float)0.1752f, (float)0.0859f, (float)0.0152f));
        bottom.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(76, 56).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-2.5f, (float)0.9718f, (float)-7.3048f, (float)0.1787f, (float)-0.2148f, (float)-0.0385f));
        bottom.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(72, 56).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-4.0f, (float)0.9718f, (float)-7.3048f, (float)0.439f, (float)0.1719f, (float)0.0306f));
        PartDefinition top = head.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.25f, (float)-7.0f, (float)0.25f));
        top.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(40, 89).m_171488_(4.75f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, none).m_171514_(36, 89).m_171488_(3.25f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, none).m_171514_(48, 86).m_171488_(-1.25f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, none).m_171514_(52, 89).m_171488_(-2.75f, -0.25f, -0.5f, 1.0f, 1.0f, 1.0f, none), PartPose.m_171423_((float)-0.25f, (float)-1.2897f, (float)-7.1745f, (float)2.8362f, (float)0.0f, (float)0.0f));
        top.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(88, 56).m_171488_(1.75f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-0.25f, (float)-1.2897f, (float)-7.1745f, (float)2.6616f, (float)0.0f, (float)0.0f));
        top.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(52, 86).m_171488_(0.25f, -1.25f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-0.25f, (float)-1.2897f, (float)-7.1745f, (float)2.8292f, (float)0.2079f, (float)-0.0666f));
        top.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(44, 86).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-3.9964f, (float)-1.1004f, (float)-7.4057f, (float)2.8292f, (float)-0.2079f, (float)0.0666f));
        top.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(40, 86).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, none), PartPose.m_171423_((float)-5.5f, (float)-1.0512f, (float)-7.2497f, (float)2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)9.0f, (float)4.0f));
        body.m_171599_("stomach_r1", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-11.5f, -8.0f, -5.5f, 23.0f, 17.0f, 11.0f, none), PartPose.m_171423_((float)1.5f, (float)-7.8998f, (float)0.7157f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("chest_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-15.0f, -2.0f, -5.0f, 32.0f, 16.0f, 15.0f, none), PartPose.m_171423_((float)0.0f, (float)-17.0f, (float)-4.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.25f, (float)-17.0f, (float)0.25f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)17.7934f, (float)-6.2538f, (float)4.75f));
        left_arm.m_171599_("left_lower_arm_r1", CubeListBuilder.m_171558_().m_171514_(56, 59).m_171488_(-4.5f, -7.5f, -5.0f, 9.0f, 15.0f, 10.0f, none), PartPose.m_171423_((float)2.7066f, (float)18.7538f, (float)-1.75f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        left_arm.m_171599_("left_upper_arm_r1", CubeListBuilder.m_171558_().m_171514_(56, 84).m_171488_(-3.0f, -7.5f, -3.5f, 6.0f, 16.0f, 7.0f, none), PartPose.m_171423_((float)1.2066f, (float)4.7538f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-18.75f, (float)-6.5f, (float)3.75f));
        right_arm.m_171599_("right_lower_arm_r1", CubeListBuilder.m_171558_().m_171514_(68, 31).m_171488_(-4.5f, -7.5f, -5.0f, 9.0f, 15.0f, 10.0f, none), PartPose.m_171423_((float)-1.75f, (float)19.0f, (float)-0.75f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        right_arm.m_171599_("right_upper_arm_r1", CubeListBuilder.m_171558_().m_171514_(82, 84).m_171488_(-3.0f, -7.5f, -3.5f, 6.0f, 16.0f, 7.0f, none), PartPose.m_171423_((float)-0.25f, (float)5.0f, (float)0.75f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)10.0f, (float)5.0f));
        left_leg.m_171599_("left_lower_leg", CubeListBuilder.m_171558_().m_171514_(94, 0).m_171488_(-5.0f, 1.0f, -5.6632f, 9.0f, 8.0f, 7.0f, none), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        left_leg.m_171599_("left_upper_leg", CubeListBuilder.m_171558_().m_171514_(94, 56).m_171488_(-3.5f, -5.0f, -3.5f, 7.0f, 8.0f, 7.0f, none), PartPose.m_171423_((float)-0.5f, (float)4.5f, (float)-1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)10.0f, (float)4.0f));
        right_leg.m_171599_("right_lower_leg", CubeListBuilder.m_171558_().m_171514_(94, 15).m_171488_(-4.0f, 1.0f, -4.6632f, 9.0f, 8.0f, 7.0f, none), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        right_leg.m_171599_("right_upper_leg", CubeListBuilder.m_171558_().m_171514_(0, 98).m_171488_(-3.5f, -5.0f, -3.5f, 7.0f, 8.0f, 7.0f, none), PartPose.m_171423_((float)0.5f, (float)4.5f, (float)-0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.f_102810_, this.f_102811_, this.f_102812_, this.f_102813_, this.f_102814_);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_5608_().forEach(ModelPart::m_233569_);
        this.m_5607_().forEach(ModelPart::m_233569_);
        if (this.isAnimating && this.currentAnimation != null) {
            if (ageInTicks >= this.animationEndTime) {
                this.isAnimating = false;
                this.currentAnimation = null;
                this.currentAnimationTime = 0.0f;
                this.animationEndTime = 2.1474836E9f;
            } else {
                if (this.animationEndTime == 2.1474836E9f) {
                    this.animationEndTime = ageInTicks + this.currentAnimation.getAnimationDuration();
                }
                this.currentAnimationTime = ageInTicks - (this.animationEndTime - this.currentAnimation.getAnimationDuration());
                this.animateWithDefinition(this.currentAnimation, this.currentAnimationTime);
            }
        } else {
            this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.5f;
            float walkSpeed = 0.5f;
            float walkAmount = Math.min(limbSwingAmount * 1.5f, 1.0f);
            this.f_102814_.f_104203_ = (float)Math.cos(limbSwing * walkSpeed) * 0.8f * walkAmount;
            this.f_102813_.f_104203_ = (float)Math.cos((double)(limbSwing * walkSpeed) + Math.PI) * 0.8f * walkAmount;
            this.f_102812_.f_104203_ = (float)Math.cos((double)(limbSwing * walkSpeed) + Math.PI) * 0.5f * walkAmount;
            this.f_102811_.f_104203_ = (float)Math.cos(limbSwing * walkSpeed) * 0.5f * walkAmount;
            this.f_102810_.f_104204_ = (float)Math.cos(limbSwing * walkSpeed * 0.5f) * 0.1f * walkAmount;
            float idleIntensity = 0.05f * (1.0f - walkAmount);
            this.f_102810_.f_104205_ = (float)Math.sin(ageInTicks * 0.05f) * idleIntensity;
            float breathingSpeed = 0.1f;
            float breathingAmount = 0.025f;
            this.f_102810_.f_233553_ = (float)((double)this.f_102810_.f_233553_ + Math.sin(ageInTicks * breathingSpeed * 3.0f) * (double)breathingAmount / 5.0);
            this.f_102810_.f_233555_ = (float)((double)this.f_102810_.f_233555_ + Math.sin(ageInTicks * breathingSpeed * 3.0f) * (double)breathingAmount / 5.0);
            this.f_102810_.f_104203_ = (float)((double)this.f_102810_.f_104203_ + Math.sin(ageInTicks * breathingSpeed) * (double)breathingAmount);
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.f_102808_);
    }

    private void animateWithDefinition(BossAnimation animation, float time) {
        animation.playAnimation(this, time);
    }

    public void handleEntityEvent(byte eventId) {
        switch (eventId) {
            case 4: {
                this.runAnimation(SlamAnimation.instance);
                break;
            }
            case 5: {
                this.runAnimation(RadiationBurstAnimation.instance);
                break;
            }
            case 6: {
                this.runAnimation(SummonAnimation.instance);
                break;
            }
            case 7: {
                this.runAnimation(RangeAttackAnimation.instance);
                break;
            }
            case 8: {
                this.runAnimation(AttackAnimation.instance);
            }
        }
    }

    private void runAnimation(BossAnimation animation) {
        this.currentAnimation = animation;
        this.animationEndTime = 2.1474836E9f;
        this.currentAnimationTime = 0.0f;
        this.isAnimating = true;
    }
}

