/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.sound;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.sound.PlayerSound;
import igentuman.nc.registry.SoundEventRegistryObject;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundHandler {
    private static final Long2ObjectMap<SoundInstance> soundMap = new Long2ObjectOpenHashMap();
    private static SoundEngine soundEngine;

    private SoundHandler() {
    }

    public static void playSound(SoundEventRegistryObject<?> soundEventRO) {
        SoundHandler.playSound((SoundEvent)soundEventRO.get());
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)1.0f));
    }

    public static void playSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    public static void stopSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120399_(sound);
    }

    public static SoundInstance startTileSound(SoundEvent soundEvent, SoundSource category, float volume, RandomSource random, BlockPos pos) {
        Object s = (SoundInstance)soundMap.get(pos.m_121878_());
        if (s == null || !Minecraft.m_91087_().m_91106_().m_120403_(s)) {
            s = new TileTickableSound(soundEvent, category, random, pos, volume);
            if (!SoundHandler.isClientPlayerInRange(s)) {
                return null;
            }
            SoundHandler.playSound(s);
            s = (SoundInstance)soundMap.get(pos.m_121878_());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.m_121878_();
        SoundInstance s = (SoundInstance)soundMap.get(posKey);
        if (s != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(s);
            soundMap.remove(posKey);
        }
    }

    public static boolean isClientPlayerInRange(SoundInstance sound) {
        if (sound.m_7796_() || sound.m_7438_() == SoundInstance.Attenuation.NONE) {
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        Sound s = sound.m_5891_();
        if (s == null) {
            sound.m_6775_(Minecraft.m_91087_().m_91106_());
            s = sound.m_5891_();
        }
        int attenuationDistance = s.m_119798_();
        float scaledDistance = Math.max(sound.m_7769_(), 1.0f) * (float)attenuationDistance;
        return player.m_20182_().m_82531_(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()) < (double)(scaledDistance * scaledDistance);
    }

    @SubscribeEvent
    public static void onSoundEngineSetup(SoundEngineLoadEvent event) {
        if (soundEngine == null) {
            soundEngine = event.getEngine();
        }
    }

    public static void onTilePlaySound(PlaySoundEvent event) {
        SoundInstance resultSound = event.getSound();
        ResourceLocation soundLoc = event.getOriginalSound().m_7904_();
        if (!soundLoc.m_135827_().startsWith("nuclearcraft")) {
            return;
        }
        SoundInstance soundInstance = event.getOriginalSound();
        if (soundInstance instanceof PlayerSound) {
            PlayerSound sound = (PlayerSound)soundInstance;
            event.setSound((SoundInstance)sound);
            return;
        }
        if (event.getName().startsWith("tile.") && resultSound != null) {
            BlockPos pos = new BlockPos((int)(resultSound.m_7772_() - 0.5), (int)(resultSound.m_7780_() - 0.5), (int)(resultSound.m_7778_() - 0.5));
            soundMap.put(pos.m_121878_(), (Object)resultSound);
        }
    }

    private static class TileTickableSound
    extends AbstractTickableSoundInstance {
        private final float originalVolume;
        private final int checkInterval = 20 + ThreadLocalRandom.current().nextInt(20);

        TileTickableSound(SoundEvent soundEvent, SoundSource category, RandomSource random, BlockPos pos, float volume) {
            super(soundEvent, category, random);
            this.originalVolume = volume * 1.0f;
            this.f_119575_ = (float)pos.m_123341_() + 0.5f;
            this.f_119576_ = (float)pos.m_123342_() + 0.5f;
            this.f_119577_ = (float)pos.m_123343_() + 0.5f;
            this.f_119573_ = this.originalVolume * this.distanceToPlayerMultiplier((SoundInstance)this);
            this.f_119578_ = true;
            this.f_119579_ = 0;
        }

        public void m_7788_() {
            if (NuclearCraft.currentTick % (long)this.checkInterval == 0L) {
                if (!SoundHandler.isClientPlayerInRange((SoundInstance)this)) {
                    this.m_119609_();
                    return;
                }
                this.f_119573_ = this.originalVolume;
                SoundInstance s = ForgeHooksClient.playSound((SoundEngine)soundEngine, (SoundInstance)this);
                if (s == this) {
                    this.f_119573_ = this.originalVolume;
                } else if (s == null) {
                    this.m_119609_();
                } else {
                    this.f_119573_ = s.m_7769_() * 1.0f;
                }
                this.f_119573_ *= this.distanceToPlayerMultiplier(s);
            }
        }

        private float distanceToPlayerMultiplier(SoundInstance sound) {
            if (sound == null) {
                return 1.0f;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            double distance = player.m_20182_().m_82531_(sound.m_7772_(), sound.m_7780_(), sound.m_7778_());
            return Math.max(0.0f, Math.min(1.0f, 1.0f - (float)distance / 400.0f));
        }

        public float m_7769_() {
            if (this.f_119570_ == null) {
                this.m_6775_(Minecraft.m_91087_().m_91106_());
            }
            return super.m_7769_();
        }

        public boolean m_7784_() {
            return true;
        }
    }
}

