/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi;

import com.refinedmods.refinedstorage.RSContainerMenus;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.client.NcClient;
import igentuman.nc.client.gui.processor.NCProcessorScreen;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.emi.AcceleratorCoolantEmiCategory;
import igentuman.nc.compat.emi.CoolerPlacementEmiCategory;
import igentuman.nc.compat.emi.CoolerPlacementEmiRecipe;
import igentuman.nc.compat.emi.FissionBoilingEmiCategory;
import igentuman.nc.compat.emi.FissionEmiCategory;
import igentuman.nc.compat.emi.FusionCoolantEmiCategory;
import igentuman.nc.compat.emi.FusionEmiCategory;
import igentuman.nc.compat.emi.HeatSinkPlacementEmiCategory;
import igentuman.nc.compat.emi.HeatSinkPlacementEmiRecipe;
import igentuman.nc.compat.emi.KugelblitzEmiCategory;
import igentuman.nc.compat.emi.KugelblitzInfoEmiCategory;
import igentuman.nc.compat.emi.OreVeinEmiCategory;
import igentuman.nc.compat.emi.ParticleInfoEmiCategory;
import igentuman.nc.compat.emi.ParticleSourceEmiCategory;
import igentuman.nc.compat.emi.ProcessorEmiCategory;
import igentuman.nc.compat.emi.ProcessorEmiRecipeHandler;
import igentuman.nc.compat.emi.TargetChamberEmiCategory;
import igentuman.nc.compat.emi.TurbineControllerEmiCategory;
import igentuman.nc.compat.emi.ingredient.ParticleEmiStack;
import igentuman.nc.compat.jei.ParticleRecipe;
import igentuman.nc.compat.jei.ParticleSourceRecipe;
import igentuman.nc.compat.refined_storage.ProcessorEmiRecipeHandlerRS;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.config.ClientConfig;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.accelerator.CoolerDef;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fission.HeatSinkDef;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.ModUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@EmiEntrypoint
public class EMIPlugin
implements EmiPlugin {
    private static final Map<String, EmiRecipeCategory> CATEGORIES = new HashMap<String, EmiRecipeCategory>();

    public static void displayRecipes(AbstractContainerScreen<?> screen) {
        EmiRecipeCategory cat = EMIPlugin.getRecipeCategory(screen);
        if (cat != null) {
            EmiApi.displayRecipeCategory((EmiRecipeCategory)cat);
        }
    }

    private static EmiRecipeCategory getRecipeCategory(AbstractContainerScreen<?> screen) {
        NCProcessorScreen processorScreen;
        if (screen instanceof NCProcessorScreen && CATEGORIES.containsKey((processorScreen = (NCProcessorScreen)screen).getRecipeTypeName())) {
            return CATEGORIES.get(processorScreen.getRecipeTypeName());
        }
        return null;
    }

    public void register(EmiRegistry registry) {
        this.registerParticleStackRenderer(registry);
        this.registerProcessorCategories(registry);
        this.registerMultiblockCategories(registry);
        this.registerParticleSourceCategory(registry);
        this.registerParticleInfoCategory(registry);
        this.registerKugelblitzInfoCategory(registry);
        this.registerHeatSinkPlacementCategory(registry);
        this.registerCoolerPlacementCategory(registry);
        this.registerWorkstations(registry);
        this.registerRecipeHandlers(registry);
    }

    private void registerProcessorCategories(EmiRegistry registry) {
        for (String name : GlobalVars.RECIPE_CLASSES.keySet()) {
            if (name.equals("nuclear_furnace") || Processors.all().containsKey(name) && !Processors.all().get(name).isRegistered() || name.equals("fusion_core") || name.equals("fusion_coolant") || name.equals("fission_reactor_controller") || name.equals("fission_boiling") || name.equals("kugelblitz_chamber") || name.equals("target_chamber") || name.equals("turbine_controller") || name.equals("accelerator_coolant") || name.equals("nc_ore_veins")) continue;
            EmiRecipeCategory category = ProcessorEmiCategory.createCategory(name);
            CATEGORIES.put(name, category);
            registry.addCategory(category);
            List recipes = NcRecipeType.ALL_RECIPES.get(name).getRecipes(NcClient.tryGetClientWorld());
            for (NcRecipe recipe : recipes) {
                registry.addRecipe((EmiRecipe)new ProcessorEmiCategory(category, recipe, name));
            }
        }
    }

    private void registerMultiblockCategories(EmiRegistry registry) {
        registry.addCategory(KugelblitzEmiCategory.CATEGORY);
        CATEGORIES.put("kugelblitz_chamber", KugelblitzEmiCategory.CATEGORY);
        List kugelblitzRecipes = NcRecipeType.ALL_RECIPES.get("kugelblitz_chamber").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : kugelblitzRecipes) {
            if (!(recipe instanceof ChamberTerminalBE.Recipe)) continue;
            ChamberTerminalBE.Recipe chamberRecipe = (ChamberTerminalBE.Recipe)recipe;
            registry.addRecipe((EmiRecipe)new KugelblitzEmiCategory(chamberRecipe));
        }
        registry.addCategory(TargetChamberEmiCategory.CATEGORY);
        CATEGORIES.put("target_chamber", TargetChamberEmiCategory.CATEGORY);
        List targetChamberRecipes = NcRecipeType.ALL_RECIPES.get("target_chamber").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : targetChamberRecipes) {
            if (!(recipe instanceof TargetChamberControllerBE.Recipe)) continue;
            TargetChamberControllerBE.Recipe targetRecipe = (TargetChamberControllerBE.Recipe)recipe;
            registry.addRecipe((EmiRecipe)new TargetChamberEmiCategory(targetRecipe));
        }
        registry.addCategory(FusionEmiCategory.CATEGORY);
        CATEGORIES.put("fusion_core", FusionEmiCategory.CATEGORY);
        List fusionRecipes = NcRecipeType.ALL_RECIPES.get("fusion_core").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : fusionRecipes) {
            if (!(recipe instanceof FusionCoreBE.Recipe)) continue;
            FusionCoreBE.Recipe fusionRecipe = (FusionCoreBE.Recipe)recipe;
            registry.addRecipe((EmiRecipe)new FusionEmiCategory(fusionRecipe));
        }
        registry.addCategory(FusionCoolantEmiCategory.CATEGORY);
        CATEGORIES.put("fusion_coolant", FusionCoolantEmiCategory.CATEGORY);
        List fusionCoolantRecipes = NcRecipeType.ALL_RECIPES.get("fusion_coolant").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : fusionCoolantRecipes) {
            if (!(recipe instanceof FusionCoreBE.FusionCoolantRecipe)) continue;
            FusionCoreBE.FusionCoolantRecipe coolantRecipe = (FusionCoreBE.FusionCoolantRecipe)recipe;
            registry.addRecipe((EmiRecipe)new FusionCoolantEmiCategory(coolantRecipe));
        }
        registry.addCategory(AcceleratorCoolantEmiCategory.CATEGORY);
        CATEGORIES.put("accelerator_coolant", AcceleratorCoolantEmiCategory.CATEGORY);
        List acceleratorCoolantRecipes = NcRecipeType.ALL_RECIPES.get("accelerator_coolant").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : acceleratorCoolantRecipes) {
            if (!(recipe instanceof LinearAcceleratorControllerBE.CoolantRecipe)) continue;
            LinearAcceleratorControllerBE.CoolantRecipe coolantRecipe = (LinearAcceleratorControllerBE.CoolantRecipe)recipe;
            registry.addRecipe((EmiRecipe)new AcceleratorCoolantEmiCategory(coolantRecipe));
        }
        registry.addCategory(FissionEmiCategory.CATEGORY);
        CATEGORIES.put("fission_reactor_controller", FissionEmiCategory.CATEGORY);
        List fissionRecipes = NcRecipeType.ALL_RECIPES.get("fission_reactor_controller").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : fissionRecipes) {
            if (!(recipe instanceof FissionControllerBE.Recipe)) continue;
            FissionControllerBE.Recipe fissionRecipe = (FissionControllerBE.Recipe)recipe;
            registry.addRecipe((EmiRecipe)new FissionEmiCategory(fissionRecipe));
        }
        registry.addCategory(FissionBoilingEmiCategory.CATEGORY);
        CATEGORIES.put("fission_boiling", FissionBoilingEmiCategory.CATEGORY);
        List fissionBoilingRecipes = NcRecipeType.ALL_RECIPES.get("fission_boiling").getRecipes(NcClient.tryGetClientWorld());
        for (Object recipe : fissionBoilingRecipes) {
            if (!(recipe instanceof FissionControllerBE.FissionBoilingRecipe)) continue;
            FissionControllerBE.FissionBoilingRecipe boilingRecipe = (FissionControllerBE.FissionBoilingRecipe)recipe;
            registry.addRecipe((EmiRecipe)new FissionBoilingEmiCategory(boilingRecipe));
        }
        registry.addCategory(TurbineControllerEmiCategory.CATEGORY);
        CATEGORIES.put("turbine_controller", TurbineControllerEmiCategory.CATEGORY);
        List turbineRecipes = NcRecipeType.ALL_RECIPES.get("turbine_controller").getRecipes(NcClient.tryGetClientWorld());
        for (NcRecipe recipe : turbineRecipes) {
            if (!(recipe instanceof TurbineControllerBE.Recipe)) continue;
            TurbineControllerBE.Recipe turbineRecipe = (TurbineControllerBE.Recipe)recipe;
            registry.addRecipe((EmiRecipe)new TurbineControllerEmiCategory(turbineRecipe));
        }
        registry.addCategory(OreVeinEmiCategory.CATEGORY);
        CATEGORIES.put("nc_ore_veins", OreVeinEmiCategory.CATEGORY);
        List oreVeinRecipes = NcRecipeType.ALL_RECIPES.get("nc_ore_veins").getRecipes(NcClient.tryGetClientWorld());
        for (NcRecipe recipe : oreVeinRecipes) {
            if (!(recipe instanceof OreVeinRecipe)) continue;
            OreVeinRecipe oreVeinRecipe = (OreVeinRecipe)recipe;
            registry.addRecipe((EmiRecipe)new OreVeinEmiCategory(oreVeinRecipe));
        }
    }

    private void registerWorkstations(EmiRegistry registry) {
        for (Map.Entry<String, EmiRecipeCategory> entry : CATEGORIES.entrySet()) {
            String name = entry.getKey();
            if (name.equals("particle_info") || name.equals("kugelblitz_info")) continue;
            EmiRecipeCategory category = entry.getValue();
            EmiStack workstation = this.getWorkstationForCategory(name);
            if (workstation == null) continue;
            registry.addWorkstation(category, (EmiIngredient)workstation);
        }
    }

    private EmiStack getWorkstationForCategory(String categoryName) {
        if (GlobalVars.CATALYSTS.containsKey(categoryName)) {
            return EmiStack.of((ItemStack)GlobalVars.CATALYSTS.get(categoryName).get(0));
        }
        switch (categoryName) {
            case "kugelblitz_chamber": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get()));
            }
            case "target_chamber": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("target_chamber_controller").get()));
            }
            case "fusion_core": 
            case "fusion_coolant": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_core").get()));
            }
            case "accelerator_coolant": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get()));
            }
            case "fission_reactor_controller": 
            case "fission_boiling": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_controller").get()));
            }
            case "turbine_controller": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)TurbineRegistration.TURBINE_BLOCKS.get("turbine_controller").get()));
            }
            case "nc_ore_veins": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)Items.f_42390_));
            }
            case "particle_source_info": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get()));
            }
            case "heat_sink_placement": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)FissionReactorRegistration.FISSION_BLOCKS.get("empty_heat_sink").get()));
            }
            case "cooler_placement": {
                return EmiStack.of((ItemStack)new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("empty_cooler").get()));
            }
        }
        return EmiStack.of((ItemStack)new ItemStack((ItemLike)Items.f_42127_));
    }

    private void registerParticleSourceCategory(EmiRegistry registry) {
        registry.addCategory(ParticleSourceEmiCategory.CATEGORY);
        CATEGORIES.put("particle_source_info", ParticleSourceEmiCategory.CATEGORY);
        List<ParticleSourceRecipe> particleSourceRecipes = this.particleSourceRecipes();
        for (ParticleSourceRecipe recipe : particleSourceRecipes) {
            registry.addRecipe((EmiRecipe)new ParticleSourceEmiCategory(recipe));
        }
    }

    private List<ParticleSourceRecipe> particleSourceRecipes() {
        ArrayList<ParticleSourceRecipe> recipes = new ArrayList<ParticleSourceRecipe>();
        for (String item : ParticleSources.sources.keySet()) {
            if (ParticleSources.sources.get(item).getParticle() == null) continue;
            recipes.add(new ParticleSourceRecipe(NuclearCraft.rl(item), new ItemStack((ItemLike)NCItems.ION_SOURCES.get(item).get()), null, ParticleSources.sources.get(item).getParticle()));
        }
        for (String fluid : ParticleSources.fluidSources.keySet()) {
            if (!NCFluids.NC_GASES.containsKey(fluid)) continue;
            recipes.add(new ParticleSourceRecipe(NuclearCraft.rl(fluid), null, new FluidStack((Fluid)NCFluids.NC_GASES.get(fluid).still().get(), 1000), ParticleSources.fluidSources.get(fluid).getParticle()));
        }
        return recipes;
    }

    private void registerParticleInfoCategory(EmiRegistry registry) {
        registry.addCategory(ParticleInfoEmiCategory.CATEGORY);
        CATEGORIES.put("particle_info", ParticleInfoEmiCategory.CATEGORY);
        List<ParticleRecipe> particleInfoRecipes = this.particleInfoRecipes();
        for (ParticleRecipe recipe : particleInfoRecipes) {
            registry.addRecipe((EmiRecipe)new ParticleInfoEmiCategory(recipe));
        }
    }

    private void registerKugelblitzInfoCategory(EmiRegistry registry) {
        registry.addCategory(KugelblitzInfoEmiCategory.CATEGORY);
        CATEGORIES.put("kugelblitz_info", KugelblitzInfoEmiCategory.CATEGORY);
        registry.addRecipe((EmiRecipe)new KugelblitzInfoEmiCategory(NuclearCraft.rl("/kugelblitz_chamber_terminal_info"), new ItemStack((ItemLike)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get())));
        registry.addRecipe((EmiRecipe)new KugelblitzInfoEmiCategory(NuclearCraft.rl("/unknown_ingredient_info"), new ItemStack((ItemLike)NCItems.UNKNOWN_INGREDIENT.get())));
    }

    private void registerHeatSinkPlacementCategory(EmiRegistry registry) {
        registry.addCategory(HeatSinkPlacementEmiCategory.CATEGORY);
        CATEGORIES.put("heat_sink_placement", HeatSinkPlacementEmiCategory.CATEGORY);
        List<HeatSinkPlacementEmiRecipe> heatSinkPlacementRecipes = this.heatSinkPlacementRecipes();
        for (HeatSinkPlacementEmiRecipe recipe : heatSinkPlacementRecipes) {
            registry.addRecipe((EmiRecipe)new HeatSinkPlacementEmiCategory(recipe));
        }
    }

    private List<HeatSinkPlacementEmiRecipe> heatSinkPlacementRecipes() {
        ArrayList<HeatSinkPlacementEmiRecipe> recipes = new ArrayList<HeatSinkPlacementEmiRecipe>();
        for (Map.Entry<String, HeatSinkDef> entry : FissionReactorRegistration.heatsinks.entrySet()) {
            String blockKey;
            String heatSinkName = entry.getKey();
            HeatSinkDef heatSinkDef = entry.getValue();
            if (heatSinkName.equals("empty") || heatSinkName.equals("active") || !FissionReactorRegistration.FISSION_BLOCKS.containsKey(blockKey = heatSinkName + "_heat_sink")) continue;
            ItemStack heatSinkItem = new ItemStack((ItemLike)FissionReactorRegistration.FISSION_BLOCKS.get(blockKey).get());
            recipes.add(new HeatSinkPlacementEmiRecipe(NuclearCraft.rl(blockKey), heatSinkDef, heatSinkItem));
        }
        return recipes;
    }

    private void registerCoolerPlacementCategory(EmiRegistry registry) {
        registry.addCategory(CoolerPlacementEmiCategory.CATEGORY);
        CATEGORIES.put("cooler_placement", CoolerPlacementEmiCategory.CATEGORY);
        List<CoolerPlacementEmiRecipe> coolerPlacementRecipes = this.coolerPlacementRecipes();
        for (CoolerPlacementEmiRecipe recipe : coolerPlacementRecipes) {
            registry.addRecipe((EmiRecipe)new CoolerPlacementEmiCategory(recipe));
        }
    }

    private List<CoolerPlacementEmiRecipe> coolerPlacementRecipes() {
        ArrayList<CoolerPlacementEmiRecipe> recipes = new ArrayList<CoolerPlacementEmiRecipe>();
        for (Map.Entry<String, CoolerDef> entry : AcceleratorRegistration.COOLERS.entrySet()) {
            String blockKey;
            String coolerName = entry.getKey();
            CoolerDef coolerDef = entry.getValue();
            if (coolerName.equals("empty") || !AcceleratorRegistration.ACCELERATOR_BLOCKS.containsKey(blockKey = coolerName + "_cooler")) continue;
            ItemStack coolerItem = new ItemStack((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get(blockKey).get());
            recipes.add(new CoolerPlacementEmiRecipe(NuclearCraft.rl(blockKey), coolerDef, coolerItem));
        }
        return recipes;
    }

    private void registerRecipeHandlers(EmiRegistry registry) {
        for (String name : NCProcessors.PROCESSORS_CONTAINERS.keySet()) {
            MenuType menuType = (MenuType)NCProcessors.PROCESSORS_CONTAINERS.get(name).get();
            registry.addRecipeHandler(menuType, new ProcessorEmiRecipeHandler());
        }
        if (ModUtil.isRefinedStorageLoaded()) {
            registry.addRecipeHandler((MenuType)RSContainerMenus.GRID.get(), new ProcessorEmiRecipeHandlerRS());
        }
    }

    private List<ParticleRecipe> particleInfoRecipes() {
        ArrayList<ParticleRecipe> recipes = new ArrayList<ParticleRecipe>();
        for (Particle particle : Particles.particles.values()) {
            recipes.add(new ParticleRecipe(NuclearCraft.rl("/" + particle.getName()), particle));
        }
        return recipes;
    }

    private void registerParticleStackRenderer(EmiRegistry registry) {
        if (!((Boolean)ClientConfig.MISC_CONFIG.HIDE_PARTICLES.get()).booleanValue()) {
            for (Particle particle : Particles.particles.values()) {
                ParticleStack particleStack = new ParticleStack(particle, 1);
                registry.addEmiStack((EmiStack)new ParticleEmiStack(particleStack));
            }
        }
    }
}

