/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ProcessorEmiCategory
extends BasicEmiRecipe {
    public static final ResourceLocation TEXTURE = NuclearCraft.rl("textures/gui/processor_jei.png");
    private final NcRecipe recipe;
    private final ProcessorPrefab processor;
    private int xShift = -25;
    private int yShift = -28;
    private final int recipeHeight;

    public ProcessorEmiCategory(EmiRecipeCategory category, NcRecipe recipe, String processorName) {
        super(category, recipe.m_6423_(), 150, 45);
        int i;
        this.recipe = recipe;
        this.processor = Processors.all().get(processorName);
        if (this.processor.getSlotsConfig().isDoubleSlotHeight()) {
            this.yShift = -25;
            this.recipeHeight = 45;
        } else {
            this.yShift = -38;
            this.recipeHeight = 22;
        }
        this.height = this.recipeHeight;
        for (i = 0; i < recipe.getItemIngredients().size(); ++i) {
            ItemStack[] items = ((Ingredient)recipe.getItemIngredients().get(i)).m_43908_();
            this.inputs.add(EmiIngredient.of(Arrays.stream(items).map(EmiStack::of).toList()));
        }
        for (i = 0; i < recipe.getInputFluids().length; ++i) {
            List<FluidStack> fluids = recipe.getInputFluids(i);
            this.inputs.add(EmiIngredient.of(fluids.stream().map(fluid -> EmiStack.of((Fluid)fluid.getFluid(), (long)fluid.getAmount())).toList()));
        }
        for (i = 0; i < recipe.getResultItems().size(); ++i) {
            this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItems().get(i)));
        }
        for (FluidStack fluid2 : recipe.getOutputFluids()) {
            if (fluid2.isEmpty()) continue;
            this.outputs.add(EmiStack.of((Fluid)fluid2.getFluid(), (long)fluid2.getAmount()));
        }
    }

    public void addWidgets(WidgetHolder widgets) {
        int itemIdx = 0;
        int inputCounter = 0;
        int inputFluidCounter = 0;
        int outputCounter = 0;
        int outputFluidCounter = 0;
        int fluidsOut = this.processor.getSlotsConfig().getOutputFluids();
        int itemsOut = this.processor.getSlotsConfig().getOutputItems();
        int itemsIn = this.processor.getSlotsConfig().getInputItems();
        int fluidsIn = this.processor.getSlotsConfig().getInputFluids();
        int barXshift = 0;
        if (fluidsOut + itemsOut == 3 || fluidsOut + itemsOut == 6) {
            barXshift = -8;
        }
        int extraXshift = 0;
        if (fluidsOut + itemsOut > 6) {
            extraXshift = -20;
        }
        if (itemsIn + fluidsIn > 5) {
            extraXshift = 20;
        }
        for (int[] pos : this.processor.getSlotsConfig().getSlotPositions()) {
            String slotType = this.processor.getSlotsConfig().getSlotType(itemIdx);
            if (slotType.contains("item_in") && inputCounter < this.inputs.size()) {
                widgets.addSlot((EmiIngredient)this.inputs.get(inputCounter), pos[0] + this.xShift + barXshift, pos[1] + this.yShift);
                ++inputCounter;
            } else if (slotType.contains("item_out") && outputCounter < this.outputs.size()) {
                widgets.addSlot((EmiIngredient)this.outputs.get(outputCounter), pos[0] + this.xShift + barXshift, pos[1] + this.yShift).recipeContext((EmiRecipe)this);
                ++outputCounter;
            } else if (slotType.contains("fluid_in") && inputFluidCounter < this.recipe.getInputFluids().length) {
                if (inputCounter < this.inputs.size()) {
                    widgets.addSlot((EmiIngredient)this.inputs.get(inputCounter), pos[0] + this.xShift + barXshift, pos[1] + this.yShift);
                    ++inputCounter;
                }
                ++inputFluidCounter;
            } else if (slotType.contains("fluid_out") && outputFluidCounter < this.recipe.getOutputFluids().size()) {
                if (!this.recipe.getOutputFluids().get(outputFluidCounter).isEmpty() && outputCounter < this.outputs.size()) {
                    widgets.addSlot((EmiIngredient)this.outputs.get(outputCounter), pos[0] + this.xShift + barXshift, pos[1] + this.yShift).recipeContext((EmiRecipe)this);
                    ++outputCounter;
                }
                ++outputFluidCounter;
            }
            ++itemIdx;
        }
        int duration = (int)(this.recipe.getTimeModifier() * (double)this.processor.config().getTime() * 10.0);
        widgets.addFillingArrow(47 + this.xShift + 25 + barXshift + extraXshift, this.recipeHeight / 2 - 8, duration);
    }

    public static EmiRecipeCategory createCategory(String processorName) {
        ResourceLocation id = NuclearCraft.rl(processorName);
        EmiStack icon = GlobalVars.CATALYSTS.containsKey(processorName) ? EmiStack.of((ItemStack)GlobalVars.CATALYSTS.get(processorName).get(0)) : EmiStack.of((ItemStack)new ItemStack((ItemLike)Items.f_42127_));
        return new EmiRecipeCategory(id, (EmiRenderable)icon);
    }

    public NcRecipe getRecipe() {
        return this.recipe;
    }
}

