/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.gregtech;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.utils.GTMath;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.util.capability.CustomEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;

public class GTEnergyContainer
implements IEnergyContainer {
    protected final CustomEnergyStorage feStorage;
    protected Direction side;
    private long feBuffer;
    private NuclearCraftBE owner;

    public GTEnergyContainer(CustomEnergyStorage feStorage, Direction side, NuclearCraftBE tile) {
        this.feStorage = feStorage;
        this.side = side;
        this.owner = tile;
    }

    public static LazyOptional<GTEnergyContainer> wrapped(CustomEnergyStorage feStorage, Direction side, NuclearCraftBE tile) {
        return LazyOptional.of(() -> new GTEnergyContainer(feStorage, side, tile));
    }

    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        if (voltage > this.getInputVoltage()) {
            this.owner.handleOverVoltage();
        }
        int receive = 0;
        if (this.feBuffer > 0L) {
            receive = this.feStorage.receiveEnergy(GTMath.saturatedCast((long)this.feBuffer), true);
            if (receive == 0) {
                return 0L;
            }
            if (this.feBuffer > (long)receive) {
                this.feBuffer -= (long)receive;
                this.feStorage.receiveEnergy(receive, false);
                return 0L;
            }
            receive = GTMath.saturatedCast((long)this.feBuffer);
            this.feBuffer = 0L;
        }
        long maxPacket = FeCompat.toFeLong((long)voltage, (int)FeCompat.ratio((boolean)false));
        long maximalValue = maxPacket * amperage;
        if (receive != 0) {
            int consumable = this.feStorage.receiveEnergy(GTMath.saturatedCast((long)(maximalValue + (long)receive)), true);
            if (consumable == 0) {
                return 0L;
            }
            if (consumable == receive) {
                this.feStorage.receiveEnergy(consumable, false);
                return 0L;
            }
            if ((long)consumable == maximalValue + (long)receive) {
                this.feStorage.receiveEnergy(consumable, false);
                return amperage;
            }
            long newPower = consumable - receive;
            if (newPower % maxPacket == 0L) {
                return (long)this.feStorage.receiveEnergy(consumable, false) / maxPacket;
            }
            int ampsToConsume = GTMath.saturatedCast((long)(newPower / maxPacket + 1L));
            this.feBuffer = GTMath.saturatedCast((long)(maxPacket * (long)ampsToConsume - (long)consumable));
            this.feStorage.receiveEnergy(consumable, false);
            return ampsToConsume;
        }
        int consumable = this.feStorage.receiveEnergy(GTMath.saturatedCast((long)maximalValue), true);
        if (consumable == 0) {
            return 0L;
        }
        if ((long)consumable == maximalValue) {
            this.feStorage.receiveEnergy(consumable, false);
            return amperage;
        }
        if ((long)consumable % maxPacket == 0L) {
            return (long)this.feStorage.receiveEnergy(consumable, false) / maxPacket;
        }
        int ampsToConsume = GTMath.saturatedCast((long)((long)consumable / maxPacket + 1L));
        this.feBuffer = GTMath.saturatedCast((long)(maxPacket * (long)ampsToConsume - (long)consumable));
        this.feStorage.receiveEnergy(consumable, false);
        return ampsToConsume;
    }

    public boolean inputsEnergy(Direction side) {
        return this.feStorage.canReceive();
    }

    public boolean outputsEnergy(Direction side) {
        return this.feStorage.canExtract();
    }

    public long changeEnergy(long differenceAmount) {
        if (differenceAmount > 0L) {
            return this.addEnergy(differenceAmount);
        }
        if (differenceAmount < 0L) {
            return this.removeEnergy(-differenceAmount);
        }
        return differenceAmount;
    }

    public long addEnergy(long energyToAdd) {
        long wasEU = this.getEnergyStored();
        this.feStorage.addEnergy(FeCompat.toFe((long)energyToAdd, (int)FeCompat.ratio((boolean)false)));
        long newEU = this.getEnergyStored();
        return newEU - wasEU;
    }

    public long removeEnergy(long energyToRemove) {
        return this.feStorage.extractEnergy(FeCompat.toFe((long)energyToRemove, (int)FeCompat.ratio((boolean)false)), false);
    }

    public long getEnergyCanBeInserted() {
        return super.getEnergyCanBeInserted();
    }

    public long getEnergyStored() {
        return FeCompat.toEu((long)this.feStorage.getEnergyStored(), (int)FeCompat.ratio((boolean)true));
    }

    public long getEnergyCapacity() {
        return FeCompat.toEu((long)this.feStorage.getMaxEnergyStored(), (int)FeCompat.ratio((boolean)true));
    }

    public IEnergyInfoProvider.EnergyInfo getEnergyInfo() {
        return super.getEnergyInfo();
    }

    public boolean supportsBigIntEnergyValues() {
        return super.supportsBigIntEnergyValues();
    }

    public long getOutputAmperage() {
        return this.feStorage.getGTOutputAmperage();
    }

    public long getOutputVoltage() {
        return this.feStorage.getGTOuputVoltage();
    }

    public long getInputAmperage() {
        return this.feStorage.getGTInputAmperage();
    }

    public long getInputVoltage() {
        return this.feStorage.getGTInputVoltage();
    }

    public long getInputPerSec() {
        return super.getInputPerSec();
    }

    public long getOutputPerSec() {
        return super.getOutputPerSec();
    }

    public boolean isOneProbeHidden() {
        return false;
    }
}

