/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.jei.ParticleRecipe;
import igentuman.nc.compat.jei.ingredient.ParticleType;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.Units;
import java.awt.Color;
import java.text.DecimalFormat;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ParticleInfoCategory
implements IRecipeCategory<ParticleRecipe> {
    public static final ResourceLocation UID = NuclearCraft.rl("particle_info");
    public static final RecipeType<ParticleRecipe> TYPE = RecipeType.create((String)"nuclearcraft", (String)"particle_info", ParticleRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public ParticleInfoCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 120);
        this.icon = guiHelper.createDrawableIngredient(ParticleType.Particle, (Object)new ParticleStack(Particles.proton));
        this.title = Component.m_237115_((String)"jei.category.nuclearcraft.particle_info");
    }

    public RecipeType<ParticleRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ParticleRecipe recipe, IFocusGroup focuses) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient(ParticleType.Particle, (Object)recipe.getIngredient());
        builder.addInputSlot().addIngredient(ParticleType.Particle, (Object)recipe.getIngredient());
    }

    public void draw(ParticleRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        DecimalFormat df = new DecimalFormat("#.##");
        graphics.m_280430_(font, (Component)TextUtils.__(recipe.getName(), new Object[0]), 20, 2, -1);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        graphics.m_280554_(font, (FormattedText)TextUtils.__("gui.nuclearcraft.jei.particle.mass", Units.getSIFormat(recipe.getMass(), 6, "eV/c^2")), 0, 30, 220, Color.darkGray.getRGB());
        graphics.m_280554_(font, (FormattedText)TextUtils.__("gui.nuclearcraft.jei.particle.charge", df.format(recipe.getCharge())), 0, 40, 220, Color.darkGray.getRGB());
        graphics.m_280554_(font, (FormattedText)TextUtils.__("gui.nuclearcraft.jei.particle.spin", recipe.getSpin()), 0, 50, 220, Color.darkGray.getRGB());
        graphics.m_280554_(font, (FormattedText)TextUtils.__("gui.nuclearcraft.jei.particle.colour", recipe.interactsWithStrong()), 0, 60, 220, Color.darkGray.getRGB());
        graphics.m_280554_(font, (FormattedText)TextUtils.__("gui.nuclearcraft.jei.particle.weak", recipe.interactsWithWeak()), 0, 70, 220, Color.darkGray.getRGB());
        graphics.m_280554_(font, (FormattedText)TextUtils.__("nuclearcraft.particle." + recipe.output.getParticle().getName() + ".desc", new Object[0]), 0, 90, 220, Color.darkGray.getRGB());
        graphics.m_280168_().m_85849_();
    }
}

