/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.network.toServer.PacketRecipeTransfer;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.type.NcRecipe;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ProcessorRecipeTransferHandler<T extends NcRecipe>
implements IRecipeTransferHandler<NCProcessorContainer<?>, T> {
    private final Class<NCProcessorContainer<?>> containerClass = NCProcessorContainer.class;
    private final RecipeType<T> recipeType;

    public ProcessorRecipeTransferHandler(RecipeType<T> recipeType) {
        this.recipeType = recipeType;
    }

    public Class<NCProcessorContainer<?>> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<NCProcessorContainer<?>>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(NCProcessorContainer<?> container, T recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return this.checkIngredients(container, recipe, recipeSlots, player);
        }
        return this.performTransfer(container, recipe, recipeSlots, player, maxTransfer);
    }

    @Nullable
    private IRecipeTransferError checkIngredients(NCProcessorContainer<?> container, T recipe, IRecipeSlotsView recipeSlots, Player player) {
        List<List> inputs = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().map(slotView -> slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList()).toList();
        for (List ingredientOptions : inputs) {
            if (ingredientOptions.isEmpty()) continue;
            boolean hasIngredient = false;
            for (ItemStack option : ingredientOptions) {
                if (!this.hasItemInInventory(player, option)) continue;
                hasIngredient = true;
                break;
            }
            if (hasIngredient) continue;
            return new ProcessorRecipeTransferError("Missing ingredients in inventory");
        }
        return null;
    }

    @Nullable
    private IRecipeTransferError performTransfer(NCProcessorContainer<?> container, T recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer) {
        NuclearCraft.packetHandler().sendToServer(new PacketRecipeTransfer(container.getPosition(), ((AbstractRecipe)recipe).m_6423_()));
        return null;
    }

    private boolean hasItemInInventory(Player player, ItemStack required) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required) || stack.m_41613_() < required.m_41613_()) continue;
            return true;
        }
        return false;
    }

    private static class ProcessorRecipeTransferError
    implements IRecipeTransferError {
        private final String message;

        public ProcessorRecipeTransferError(String message) {
            this.message = message;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.USER_FACING;
        }
    }
}

