/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei.ingredient;

import com.google.common.base.MoreObjects;
import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.jei.ingredient.ParticleType;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ParticleStackHelper
implements IIngredientHelper<ParticleStack> {
    public IIngredientType<ParticleStack> getIngredientType() {
        return ParticleType.Particle;
    }

    public String getDisplayName(ParticleStack ingredient) {
        return ingredient.getParticle().getUnlocalizedName();
    }

    public String getUniqueId(ParticleStack ingredient, UidContext uidContext) {
        return "nuclearcraft:particle/" + ingredient.getParticle().getName();
    }

    public String getWildcardId(ParticleStack ingredient) {
        return this.getUniqueId(ingredient, null);
    }

    public ResourceLocation getResourceLocation(ParticleStack particleStack) {
        return NuclearCraft.rl(particleStack.getParticle().getName());
    }

    public ItemStack getCheatItemStack(ParticleStack ingredient) {
        return ItemStack.f_41583_;
    }

    public ParticleStack copyIngredient(ParticleStack ingredient) {
        return ingredient.copy();
    }

    public String getErrorInfo(@Nullable ParticleStack ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ParticleStack.class);
        Particle particle = ingredient.getParticle();
        if (particle != null) {
            toStringHelper.add("Particle", (Object)particle.getName());
        } else {
            toStringHelper.add("Particle", (Object)"null");
        }
        toStringHelper.add("amount", ingredient.getAmount());
        toStringHelper.add("Energy", ingredient.getMeanEnergy());
        toStringHelper.add("Focus", ingredient.getFocus());
        return toStringHelper.toString();
    }
}

