/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei.ingredient;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.Units;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

public class ParticleStackRenderer
implements IIngredientRenderer<ParticleStack> {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int amount;
    private final long energy;
    private final double focus;
    private final int width;
    private final int height;
    @Nullable
    private final IDrawable overlay;

    public ParticleStackRenderer() {
        this(0, 0L, 0.0, 16, 16, null);
    }

    public ParticleStackRenderer(int amount, long energy, double focus, int width, int height, @Nullable IDrawable overlay) {
        this.amount = amount;
        this.energy = energy;
        this.focus = focus;
        this.width = width;
        this.height = height;
        this.overlay = overlay;
    }

    public void render(GuiGraphics guiGraphics, ParticleStack particleStack) {
        this.render(guiGraphics, particleStack, 0, 0);
    }

    public void render(GuiGraphics graphics, @Nullable ParticleStack particleStack, int posX, int posY) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)posX, (float)posY, 0.0f);
        this.drawParticle(graphics, 0, 0, particleStack);
        if (this.overlay != null) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            this.overlay.draw(graphics, 0, 0);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    public List<Component> getTooltip(ParticleStack particleStack, TooltipFlag tooltipFlag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, ParticleStack ingredient, TooltipFlag tooltipFlag) {
        super.getTooltip(tooltip, (Object)ingredient, tooltipFlag);
        tooltip.add((FormattedText)TextUtils.__(ingredient.getParticle().getUnlocalizedName(), new Object[0]));
        tooltip.add((FormattedText)Component.m_237113_((String)("nuclearcraft:particle/" + ingredient.getParticle().getName())).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((FormattedText)TextUtils.__("tooltip.nuclearcraft.particlestack.amount", Units.getSIFormat(ingredient.getAmount(), "pu")).m_130940_(ChatFormatting.GRAY));
        if (ingredient.getMeanEnergy() > 0L) {
            tooltip.add((FormattedText)TextUtils.__("tooltip.nuclearcraft.particlestack.mean_energy", Units.getParticleEnergy(ingredient.getMeanEnergy())).m_130940_(ChatFormatting.GRAY));
        }
        if (ingredient.getFocus() > 0.0) {
            tooltip.add((FormattedText)TextUtils.__("tooltip.nuclearcraft.particlestack.focus", Units.getSIFormat(ingredient.getFocus(), "")).m_130940_(ChatFormatting.GRAY));
        }
    }

    private void drawParticle(GuiGraphics graphics, int xPosition, int yPosition, @Nullable ParticleStack particleStack) {
        if (particleStack == null) {
            return;
        }
        Particle particle = particleStack.getParticle();
        if (particle == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)particleStack.getParticle().getTexture());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(particleStack.getParticle().getTexture(), xPosition, yPosition, 0.0f, 0.0f, 16, 16, 16, 16);
    }
}

