/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.kubejs;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import igentuman.nc.compat.kubejs.InputParticle;
import igentuman.nc.compat.kubejs.NCKubeJsEvents;
import igentuman.nc.compat.kubejs.NCRecipeJS;
import igentuman.nc.compat.kubejs.OutputParticle;
import igentuman.nc.compat.kubejs.ParticleComponents;
import igentuman.nc.recipes.NcRecipeType;

public class NuclearCraftKubeJSPlugin
extends KubeJSPlugin {
    RecipeKey<InputFluid[]> INPUT_FLUIDS = FluidComponents.INPUT_ARRAY.key("inputFluids").defaultOptional();
    RecipeKey<InputItem[]> INPUT_ITEMS = ItemComponents.INPUT_ARRAY.key("input").defaultOptional();
    RecipeKey<OutputItem[]> OUTPUT_ITEMS = ItemComponents.OUTPUT_ARRAY.key("output").defaultOptional();
    RecipeKey<OutputFluid[]> OUTPUT_FLUIDS = FluidComponents.OUTPUT_ARRAY.key("outputFluids").defaultOptional();
    RecipeKey<InputParticle[]> INPUT_PARTICLES = ParticleComponents.INPUT_ARRAY.key("inputParticles").defaultOptional();
    RecipeKey<OutputParticle[]> OUTPUT_PARTICLES = ParticleComponents.OUTPUT_ARRAY.key("outputParticles").defaultOptional();
    RecipeKey<Double> POWER_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("powerModifier").defaultOptional();
    RecipeKey<Double> TIME_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("timeModifier").defaultOptional();
    RecipeKey<Double> RADIATION_MODIFIER = NumberComponent.DoubleRange.ANY_DOUBLE.min(-1000.0).max(1000.0).key("radiation").defaultOptional();
    RecipeKey<Double> CROSS_SECTION = NumberComponent.DoubleRange.ANY_DOUBLE.min(0.0).max(1000.0).key("crossSection").defaultOptional();
    RecipeKey<Long> MAX_ENERGY = NumberComponent.LongRange.ANY_LONG.min(0L).key("maxEnergy").defaultOptional();
    RecipeSchema SCHEMA = new RecipeSchema(NCRecipeJS.class, NCRecipeJS::new, new RecipeKey[]{this.INPUT_ITEMS, this.INPUT_FLUIDS, this.INPUT_PARTICLES, this.OUTPUT_ITEMS, this.OUTPUT_FLUIDS, this.OUTPUT_PARTICLES, this.POWER_MODIFIER, this.TIME_MODIFIER, this.RADIATION_MODIFIER});
    RecipeSchema TARGET_CHAMBER_SCHEMA = new RecipeSchema(NCRecipeJS.class, NCRecipeJS::new, new RecipeKey[]{this.INPUT_ITEMS, this.INPUT_FLUIDS, this.INPUT_PARTICLES, this.OUTPUT_ITEMS, this.OUTPUT_FLUIDS, this.OUTPUT_PARTICLES, this.POWER_MODIFIER, this.TIME_MODIFIER, this.RADIATION_MODIFIER, this.CROSS_SECTION, this.MAX_ENERGY});

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        for (String recipeType : NcRecipeType.ALL_RECIPES.keySet()) {
            if (recipeType.equals("target_chamber")) {
                event.namespace("nuclearcraft").register(recipeType, this.TARGET_CHAMBER_SCHEMA);
            }
            event.namespace("nuclearcraft").register(recipeType, this.SCHEMA);
        }
    }

    public void onServerReload() {
        NcRecipeType.invalidateCache();
    }

    public void registerEvents() {
        NCKubeJsEvents.GROUP.register();
    }
}

