/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.mekanism;

import java.util.Optional;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MekInteractions {
    public static boolean handleMultitoolInteractionWithMek(BlockEntity be, Player player, Direction side) {
        Optional capability;
        if (be instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)be;
            for (TransmissionType transmissionType : TransmissionType.values()) {
                if (!config.getConfig().supports(transmissionType)) continue;
                ConfigInfo info = config.getConfig().getConfig(transmissionType);
                if (info != null) {
                    RelativeSide relativeSide = RelativeSide.fromDirections((Direction)config.getDirection(), (Direction)side);
                    DataType dataType = info.getDataType(relativeSide);
                    if (!player.m_6144_()) {
                        player.m_5661_((Component)MekanismLang.CONFIGURATOR_VIEW_MODE.translateColored(EnumColor.GRAY, new Object[]{transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()}), true);
                    } else {
                        if (!ISecurityUtils.INSTANCE.canAccessOrDisplayError(player, (ICapabilityProvider)be)) {
                            return false;
                        }
                        DataType old = dataType;
                        dataType = info.incrementDataType(relativeSide);
                        if (dataType != old) {
                            player.m_5661_((Component)MekanismLang.CONFIGURATOR_TOGGLE_MODE.translateColored(EnumColor.GRAY, new Object[]{transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName()}), true);
                            config.getConfig().sideChanged(transmissionType, relativeSide);
                        }
                    }
                }
                return true;
            }
        }
        if ((capability = CapabilityUtils.getCapability((ICapabilityProvider)be, (Capability)Capabilities.CONFIGURABLE, (Direction)side).resolve()).isPresent()) {
            IConfigurable config = (IConfigurable)capability.get();
            if (player.m_6144_()) {
                return config.onSneakRightClick(player) == InteractionResult.SUCCESS;
            }
            return config.onRightClick(player) == InteractionResult.SUCCESS;
        }
        return false;
    }
}

