/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.oc2;

import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import java.util.Collection;
import java.util.Collections;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.bus.device.object.ObjectDevice;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

public class TargetChamberDevice {
    public static final Capability<Device> DEVICE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Device>(){});

    public static RPCDevice createDevice(TargetChamberControllerBE blockEntity) {
        return new ObjectDevice((Object)new NCFissionReactorDeviceRecord(blockEntity));
    }

    public record NCFissionReactorDeviceRecord(TargetChamberControllerBE reactor) implements NamedDevice
    {
        @Callback
        public final String getName() {
            return this.reactor.getName();
        }

        @Callback
        public final boolean isFormed() {
            return this.reactor.isCasingValid && this.reactor.isInternalValid;
        }

        @Callback
        public final boolean hasRecipe() {
            return this.reactor.hasRecipe();
        }

        @Callback
        public final int getDepletionProgress() {
            return (int)(this.reactor.getRecipeProgress() * 100.0);
        }

        @Callback
        public final void enableReactor() {
            this.reactor.disableForceShutdown();
        }

        @Callback
        public final void disableReactor() {
            this.reactor.forceShutdown();
        }

        @Callback
        public final int getEnergyPerTick() {
            return this.reactor.energyPerTick;
        }

        @Callback
        public final int getEnergyStored() {
            return this.reactor.energyStorage.getEnergyStored();
        }

        @Callback
        public final void voidFuel() {
            this.reactor.voidFuel();
        }

        @Callback
        public final Object[] getFuelInSlot() {
            return this.reactor.getFuel();
        }

        @NotNull
        public Collection<String> getDeviceTypeNames() {
            return Collections.singletonList(this.getName());
        }
    }
}

