/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.container.elements.NCSlotItemHandler;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ChamberTerminalContainer
extends AbstractContainerMenu {
    protected final ChamberTerminalBE blockEntity;
    protected final Player playerEntity;
    protected final String name = "chamber_terminal";
    private int slotIndex = 0;
    protected final IItemHandler playerInventory;

    public ChamberTerminalContainer(int pContainerId, BlockPos pos, Inventory playerInventory) {
        super((MenuType)KugelblitzRegistration.CHAMBER_TERMINAL_CONTAINER.get(), pContainerId);
        this.playerEntity = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.blockEntity = (ChamberTerminalBE)this.playerEntity.m_20193_().m_7702_(pos);
        this.layoutPlayerInventorySlots();
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new NCSlotItemHandler.Input((IItemHandler)h, 0, 135, 80));
            this.m_38897_((Slot)new NCSlotItemHandler.Output((IItemHandler)h, 1, 189, 80));
        });
    }

    public ItemStack m_7648_(Player pPlayer, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (slot instanceof NCSlotItemHandler.Output || slot instanceof NCSlotItemHandler.Input ? !this.m_38903_(stack, 0, 36, true) : !this.m_38903_(stack, this.f_38839_.size() - 2, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player playerIn) {
        return ChamberTerminalContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get()));
    }

    public Component getTitle() {
        return TextUtils.__("block.nuclearcraft.chamber_terminal", new Object[0]);
    }

    public boolean isCasingValid() {
        return this.blockEntity.isCasingValid;
    }

    public int[] getDimensions() {
        return new int[]{this.getHeight(), this.getWidth(), this.getDepth()};
    }

    public int getDepth() {
        return this.blockEntity.getDepth();
    }

    public int getWidth() {
        return this.blockEntity.getWidth();
    }

    public int getHeight() {
        return this.blockEntity.getHeight();
    }

    public boolean isInteriorValid() {
        return this.blockEntity.isInternalValid;
    }

    public BlockPos getValidationResultData() {
        return this.blockEntity.errorBlockPos;
    }

    public String getValidationResultKey() {
        return this.blockEntity.validationResult.messageKey;
    }

    public int getEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage.getEnergyStored());
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 27;
        int topRow = 163;
        this.addSlotRange(this.playerInventory, leftCol, topRow, 9, 18);
        this.addSlotBox(this.playerInventory, leftCol, topRow -= 58, 9, 18, 3, 18);
    }

    public ItemStack getResultStack() {
        if (this.blockEntity.recipeInfo.recipe != null) {
            return this.blockEntity.recipeInfo.recipe.getResultItem();
        }
        return ItemStack.f_41583_;
    }

    public int getMaxEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage.getMaxEnergyStored());
    }

    public String getEfficiency() {
        return TextUtils.roundFormat(this.blockEntity.efficiency);
    }

    public int energyPerTick() {
        return TextUtils.energy2Display(this.blockEntity.energyPerTick);
    }

    public boolean hasRecipe() {
        return this.blockEntity.hasRecipe();
    }

    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }

    public FluidTank getFluidTank(int i) {
        return this.blockEntity.getFluidTank(i);
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }

    public int getEnergyRate() {
        return this.blockEntity.energyConvertionRate;
    }

    public int getFrequency() {
        return this.blockEntity.frequency;
    }

    public boolean hasBlackhole() {
        return this.blockEntity.mass > 0L;
    }

    public long getMass() {
        return this.blockEntity.mass;
    }

    public int getEvaporation() {
        return this.blockEntity.evaporation;
    }

    public long getFeeding() {
        return this.blockEntity.feeding;
    }

    public int getFluxRegulators() {
        return this.blockEntity.fluxRegulators;
    }

    public int getTransformers() {
        return this.blockEntity.transformers;
    }

    public double getProgress() {
        return this.blockEntity.recipeInfo().getProgress();
    }

    public int getStability() {
        return this.blockEntity.blackholeStability;
    }

    public int getStabilizers() {
        return this.blockEntity.stabilizers;
    }
}

