/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.energy;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.block.entity.energy.solar.AdvancedSolarBE;
import igentuman.nc.block.entity.energy.solar.BasicSolarBE;
import igentuman.nc.block.entity.energy.solar.DuSolarBE;
import igentuman.nc.block.entity.energy.solar.EliteSolarBE;
import igentuman.nc.handler.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SolarPanels {
    private static final HashMap<String, SolarPanelPrefab> all = new HashMap();
    private static final HashMap<String, SolarPanelPrefab> registered = new HashMap();

    public static HashMap<String, SolarPanelPrefab> all() {
        if (all.isEmpty()) {
            all.put("basic", new SolarPanelPrefab("basic", 28, 0).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)BasicSolarBE::new)));
            all.put("advanced", new SolarPanelPrefab("advanced", 112, 1).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)AdvancedSolarBE::new)));
            all.put("du", new SolarPanelPrefab("du", 448, 2).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)DuSolarBE::new)));
            all.put("elite", new SolarPanelPrefab("elite", 1792, 3).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)EliteSolarBE::new)));
        }
        return all;
    }

    public static HashMap<String, SolarPanelPrefab> registered() {
        if (registered.isEmpty()) {
            for (String name : SolarPanels.all().keySet()) {
                if (!SolarPanels.all().get(name).config().isRegistered()) continue;
                registered.put(name, SolarPanels.all().get(name));
            }
        }
        return registered;
    }

    public static List<Boolean> initialRegistered() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String name : SolarPanels.all().keySet()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialPower() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : SolarPanels.all().keySet()) {
            tmp.add(SolarPanels.all().get(name).getGeneration());
        }
        return tmp;
    }

    public static String getCode(String name) {
        for (String code : SolarPanels.all().keySet()) {
            if (!name.equals("solar_panel_" + code)) continue;
            return "solar_panel/" + code;
        }
        return "";
    }

    public static class SolarPanelPrefab {
        private boolean registered = true;
        private boolean initialized = false;
        private final String name;
        protected int generation = 0;
        protected int tier = 0;
        private BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity;

        public SolarPanelPrefab(String name, int generation, int tier) {
            this.generation = generation;
            this.name = name;
            this.tier = tier;
        }

        public int getGeneration() {
            return this.generation;
        }

        public int getActualGeneration() {
            return (int)((double)this.config().generation * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
        }

        public SolarPanelPrefab setGeneration(int generation) {
            this.generation = generation;
            return this;
        }

        public SolarPanelPrefab config() {
            if (!this.initialized) {
                try {
                    int id = SolarPanels.all().keySet().stream().toList().indexOf(this.name);
                    this.registered = (Boolean)((List)CommonConfig.ENERGY_GENERATION.REGISTER_SOLAR_PANELS.get()).get(id);
                    this.generation = (Integer)((List)CommonConfig.ENERGY_GENERATION.SOLAR_PANELS_GENERATION.get()).get(id);
                    this.initialized = true;
                }
                catch (Exception e) {
                    NuclearCraft.LOGGER.error("Error while loading config for " + this.name + "!");
                }
            }
            return this;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public BlockEntityType.BlockEntitySupplier<? extends NCEnergy> getBlockEntity() {
            return this.blockEntity;
        }

        public SolarPanelPrefab setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        public CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getEnergyTier() {
            return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.values()[this.tier];
        }
    }
}

