/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles;

import igentuman.nc.content.particles.IParticleStackHandler;
import igentuman.nc.content.particles.IParticleStorage;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.ParticleStorage;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityParticleStackHandler {
    public static final Capability<IParticleStackHandler> PARTICLE_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IParticleStackHandler>(){});

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IParticleStackHandler.class);
    }

    public static LazyOptional<IParticleStackHandler> createHandler(ParticleStorage storage) {
        return LazyOptional.of(() -> storage);
    }

    public static class ParticleHandlerStorage
    implements INBTSerializable<CompoundTag> {
        private final IParticleStackHandler handler;

        public ParticleHandlerStorage(IParticleStackHandler handler) {
            this.handler = handler;
        }

        public CompoundTag serializeNBT() {
            if (!(this.handler instanceof IParticleStorage)) {
                throw new RuntimeException("IParticleStackHandler instance does not implement IParticleStorage");
            }
            CompoundTag nbt = new CompoundTag();
            IParticleStorage tank = (IParticleStorage)((Object)this.handler);
            ParticleStack particle = tank.getParticleStack();
            if (particle != null) {
                particle.writeToNBT(nbt);
            } else {
                nbt.m_128359_("Empty", "");
            }
            nbt.m_128356_("MaxEnergy", tank.getMaxEnergy());
            nbt.m_128405_("Capacity", tank.getCapacity());
            nbt.m_128356_("MinEnergy", tank.getMinEnergy());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (!(this.handler instanceof ParticleStorage)) {
                throw new RuntimeException("IParticleStackHandler instance is not instance of ParticleStorage");
            }
            ParticleStorage tank = (ParticleStorage)this.handler;
            tank.setMaxEnergy(nbt.m_128454_("MaxEnergy"));
            tank.setCapacity(nbt.m_128451_("Capacity"));
            tank.setMinEnergy(nbt.m_128454_("MinEnergy"));
            tank.readFromNBT(nbt);
        }
    }
}

