/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles;

import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public interface IItemParticleAmount {
    public int getItemCapacity(ItemStack var1);

    public static int getCapacity(ItemStack stack) {
        CompoundTag nbt = IItemParticleAmount.getStorageNBT(stack);
        if (!nbt.m_128441_("particle_capacity")) {
            return 1000000;
        }
        return nbt.m_128451_("particle_capacity");
    }

    default public Particle getParticle(ItemStack stack) {
        if (!ParticleSources.sources.containsKey(stack.m_41720_().toString())) {
            return null;
        }
        if (ParticleSources.sources.get(stack.m_41720_().toString()).getParticle() == null) {
            return null;
        }
        CompoundTag nbt = IItemParticleAmount.getStorageNBT(stack);
        if (!nbt.m_128441_("particle")) {
            nbt.m_128359_("particle", ParticleSources.sources.get((Object)stack.m_41720_().toString()).getParticle().name);
        }
        return Particles.particles.get(nbt.m_128461_("particle"));
    }

    default public int getAmountStored(ItemStack stack) {
        CompoundTag nbt = IItemParticleAmount.getStorageNBT(stack);
        if (!nbt.m_128441_("particle_amount")) {
            return 0;
        }
        return nbt.m_128451_("particle_amount");
    }

    default public void setAmountStored(ItemStack stack, int amount) {
        if (stack.m_41720_() instanceof IItemParticleAmount) {
            CompoundTag nbt = IItemParticleAmount.getStorageNBT(stack);
            nbt.m_128405_("particle_amount", Math.min(amount, IItemParticleAmount.getCapacity(stack)));
        }
    }

    default public ItemStack fill(ItemStack stack, int amount, String type) {
        if (this.getAmountStored(stack) + amount <= IItemParticleAmount.getCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    default public ItemStack use(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return this.getEmptyItem();
        }
        return stack;
    }

    default public ItemStack getEmptyItem() {
        return ItemStack.f_41583_;
    }

    default public boolean isEmptyItem(ItemStack stack) {
        return stack == this.getEmptyItem() || this.getAmountStored(stack) <= 0;
    }

    public static ItemStack cleanNBT(ItemStack stack) {
        ItemStack newStack = stack.m_41777_();
        newStack.m_41751_(null);
        return newStack;
    }

    public static ItemStack fullItem(ItemStack stack) {
        if (stack.m_41720_() instanceof IItemParticleAmount) {
            IItemParticleAmount.setStorageNBT(stack);
            IItemParticleAmount item = (IItemParticleAmount)stack.m_41720_();
            item.setAmountStored(stack, item.getItemCapacity(stack));
        }
        return stack;
    }

    public static CompoundTag getStorageNBT(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("particle_storage")) {
            CompoundTag storage = new CompoundTag();
            storage.m_128405_("particle_amount", ParticleSources.getCapacity(stack));
            storage.m_128405_("particle_capacity", ParticleSources.getCapacity(stack));
            nbt.m_128365_("particle_storage", (Tag)storage);
        }
        return nbt.m_128469_("particle_storage");
    }

    public static void setStorageNBT(ItemStack stack) {
        if (!(stack.m_41720_() instanceof IItemParticleAmount)) {
            return;
        }
        IItemParticleAmount item = (IItemParticleAmount)stack.m_41720_();
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("particle_storage")) {
            CompoundTag storage = new CompoundTag();
            storage.m_128405_("particle_amount", 1000000);
            storage.m_128405_("particle_capacity", item.getItemCapacity(stack));
            nbt.m_128365_("particle_storage", (Tag)storage);
            stack.m_41751_(nbt);
        } else if (!nbt.m_128469_("particle_storage").m_128441_("particle_capacity")) {
            nbt.m_128469_("particle_storage").m_128405_("particle_capacity", item.getItemCapacity(stack));
            stack.m_41751_(nbt);
        }
    }

    default public ParticleStack getParticleStack(ItemStack stack) {
        return new ParticleStack(this.getParticle(stack), 10000, 0L, 0.0);
    }
}

