/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles;

import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.content.particles.IParticleStackHandler;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.ParticleStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    private final ParticleStorage storage;
    private final LazyOptional<IParticleStackHandler> lazyHandler;
    private final CapabilityParticleStackHandler.ParticleHandlerStorage serializer;

    public ParticleCapabilityProvider(@Nullable ParticleStack initialStack, long maxEnergy, int capacity, long minEnergy) {
        this.storage = new ParticleStorage(initialStack, maxEnergy, capacity, minEnergy);
        this.lazyHandler = LazyOptional.of(() -> this.storage);
        this.serializer = new CapabilityParticleStackHandler.ParticleHandlerStorage(this.storage);
    }

    public ParticleCapabilityProvider(@Nullable ParticleStack initialStack, long maxEnergy, int capacity) {
        this(initialStack, maxEnergy, capacity, 0L);
    }

    public ParticleCapabilityProvider(@Nullable ParticleStack initialStack, long maxEnergy) {
        this(initialStack, maxEnergy, Integer.MAX_VALUE, 0L);
    }

    public ParticleCapabilityProvider() {
        this(null, Long.MAX_VALUE, Integer.MAX_VALUE, 0L);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.lazyHandler.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.serializer.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.serializer.deserializeNBT(nbt);
    }

    public void invalidate() {
        this.lazyHandler.invalidate();
    }
}

