/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.util.math.MathUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ParticleStack {
    public static final ParticleStack EMPTY = new ParticleStack();
    private Particle particle;
    private int amount;
    private long meanEnergy;
    private double focus;

    public ParticleStack() {
        this.particle = null;
        this.amount = 0;
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle, int amount, long meanEnergy, double focus) {
        this.particle = particle;
        this.amount = (int)MathUtils.clamp(amount, 0L, Integer.MAX_VALUE);
        this.meanEnergy = MathUtils.clamp(meanEnergy, 0L, Long.MAX_VALUE);
        this.focus = focus;
    }

    public ParticleStack(Particle particle, int amount, long meanEnergy) {
        this.particle = particle;
        this.meanEnergy = MathUtils.clamp(meanEnergy, 0L, Long.MAX_VALUE);
        this.amount = (int)MathUtils.clamp(amount, 0L, Integer.MAX_VALUE);
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle, int amount) {
        this.particle = particle;
        this.amount = (int)MathUtils.clamp(amount, 0L, Integer.MAX_VALUE);
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public ParticleStack(Particle particle) {
        this.particle = particle;
        this.amount = 1;
        this.meanEnergy = 0L;
        this.focus = 0.0;
    }

    public static ParticleStack fromJSON(JsonElement in) {
        if (in == null || !in.isJsonObject()) {
            return null;
        }
        JsonObject json = in.getAsJsonObject();
        String particleName = json.get("particle").getAsString();
        int amount = json.get("amount").getAsInt();
        long meanEnergy = json.get("meanEnergy").getAsLong();
        double focus = json.get("focus").getAsDouble();
        return new ParticleStack(Particles.getParticleFromName(particleName), amount, meanEnergy, focus);
    }

    public static ParticleStack readBuffer(@NotNull FriendlyByteBuf buffer) {
        String particleName = buffer.m_130277_();
        int amount = buffer.readInt();
        long meanEnergy = buffer.readLong();
        double focus = buffer.readDouble();
        return new ParticleStack(Particles.getParticleFromName(particleName), amount, meanEnergy, focus);
    }

    public void writeBuffer(FriendlyByteBuf buffer) {
        if (this.particle != null) {
            buffer.m_130070_(this.particle.getName());
        } else {
            buffer.m_130070_("");
        }
        buffer.writeInt(this.amount);
        buffer.writeLong(this.meanEnergy);
        buffer.writeDouble(this.focus);
    }

    public Particle getParticle() {
        return this.particle;
    }

    public long getMeanEnergy() {
        return this.meanEnergy;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getFocus() {
        return this.focus;
    }

    public void setParticle(Particle newParticle) {
        this.particle = newParticle;
    }

    public void setMeanEnergy(long newMeanEnergy) {
        this.meanEnergy = newMeanEnergy;
    }

    public void addMeanEnergy(long add) {
        this.meanEnergy += add;
    }

    public void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public void addAmount(long add) {
        this.amount = (int)((long)this.amount + add);
    }

    public void removeAmount(long remove) {
        this.amount = (int)((long)this.amount - remove);
        if (this.amount < 0) {
            this.amount = 0;
            this.particle = null;
        }
    }

    public void setFocus(double newFocus) {
        this.focus = newFocus;
    }

    public void addFocus(double add) {
        this.focus += add;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.particle != null) {
            nbt.m_128359_("particle", this.particle.getName());
        }
        nbt.m_128405_("amount", this.amount);
        nbt.m_128356_("meanEnergy", this.meanEnergy);
        nbt.m_128347_("focus", this.focus);
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.particle = nbt.m_128441_("particle") ? Particles.getParticleFromName(nbt.m_128461_("particle")) : null;
        this.amount = nbt.m_128451_("amount");
        this.meanEnergy = nbt.m_128454_("meanEnergy");
        this.focus = nbt.m_128459_("focus");
    }

    public ParticleStack copy() {
        return new ParticleStack(this.particle, this.amount, this.meanEnergy, this.focus);
    }

    public static ParticleStack loadParticleStackFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.m_128441_("particle")) {
            return null;
        }
        String particleName = nbt.m_128461_("particle");
        int amount = nbt.m_128451_("amount");
        long energy = nbt.m_128454_("meanEnergy");
        double focus = nbt.m_128459_("focus");
        ParticleStack beam = new ParticleStack(Particles.getParticleFromName(particleName), amount, energy, focus);
        return beam;
    }

    public static ParticleStack getParticleStack(String particleName, int amount, long meanEnergy, double focus) {
        return new ParticleStack(Particles.getParticleFromName(particleName), amount, meanEnergy, focus);
    }

    public boolean matchesType(ParticleStack particleStack) {
        return particleStack != null && particleStack.getParticle() == this.particle;
    }

    public boolean isInRange(ParticleStack particleStack, long maxEnergy) {
        return particleStack != null && particleStack.getParticle() == this.particle && particleStack.getFocus() >= this.focus - 0.002 && particleStack.getMeanEnergy() >= this.meanEnergy && particleStack.getMeanEnergy() <= maxEnergy;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.particle != null) {
            json.addProperty("particle", this.particle.getName());
        }
        json.addProperty("amount", (Number)this.amount);
        json.addProperty("meanEnergy", (Number)this.meanEnergy);
        json.addProperty("focus", (Number)this.focus);
        return json;
    }

    public boolean isEmpty() {
        return this.particle == null;
    }
}

