/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles;

import igentuman.nc.content.particles.IParticleStackHandler;
import igentuman.nc.content.particles.IParticleStorage;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.ParticleStorageInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ParticleStorage
implements IParticleStorage,
IParticleStackHandler {
    protected ParticleStack particleStack;
    public List<ParticleStack> outputParticles = new ArrayList<ParticleStack>();
    protected BlockEntity tile;
    protected long maxEnergy;
    protected long minEnergy;
    protected int capacity;
    protected Direction sourceDir = Direction.UP;

    public ParticleStorage(ParticleStack stack, long maxEnergy, int capacity, long minEnergy) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = capacity;
        this.minEnergy = minEnergy;
    }

    public ParticleStorage(ParticleStack stack, long maxEnergy, int capacity) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = capacity;
        this.minEnergy = 0L;
    }

    public ParticleStorage(ParticleStack stack, long maxEnergy) {
        this.particleStack = stack;
        this.maxEnergy = maxEnergy;
        this.capacity = Integer.MAX_VALUE;
        this.minEnergy = 0L;
    }

    public ParticleStorage() {
        this.particleStack = null;
        this.maxEnergy = Long.MAX_VALUE;
        this.capacity = Integer.MAX_VALUE;
        this.minEnergy = 0L;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.particleStack = nbt.m_128441_("particle_stack") ? ParticleStack.loadParticleStackFromNBT(nbt.m_128469_("particle_stack")) : null;
        this.maxEnergy = nbt.m_128454_("maxEnergy");
        this.capacity = nbt.m_128451_("capacity");
        this.minEnergy = nbt.m_128454_("minEnergy");
        this.sourceDir = Direction.m_122402_((String)nbt.m_128461_("sourceDir"));
        int outputCount = nbt.m_128451_("outputParticlesCount");
        this.outputParticles = new ArrayList<ParticleStack>(outputCount);
        if (nbt.m_128441_("outputParticles")) {
            CompoundTag outputs = nbt.m_128469_("outputParticles");
            for (int i = 0; i < outputCount; ++i) {
                ParticleStack stack;
                if (!outputs.m_128441_("particle_" + i) || (stack = ParticleStack.loadParticleStackFromNBT(outputs.m_128469_("particle_" + i))) == null) continue;
                this.outputParticles.add(stack);
            }
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        if (this.particleStack != null) {
            this.particleStack.writeToNBT(tag);
        } else {
            new ParticleStack().writeToNBT(tag);
        }
        nbt.m_128365_("particle_stack", (Tag)tag);
        nbt.m_128356_("maxEnergy", this.maxEnergy);
        nbt.m_128405_("capacity", this.capacity);
        nbt.m_128356_("minEnergy", this.minEnergy);
        nbt.m_128405_("outputParticlesCount", this.outputParticles.size());
        CompoundTag outputs = new CompoundTag();
        int id = 0;
        for (ParticleStack stack : this.outputParticles) {
            outputs.m_128365_("particle_" + id, (Tag)stack.writeToNBT(outputs));
        }
        nbt.m_128365_("outputParticles", (Tag)outputs);
        if (this.sourceDir == null) {
            this.sourceDir = Direction.UP;
        }
        nbt.m_128359_("sourceDir", this.sourceDir.name());
        return nbt;
    }

    public CompoundTag writeToNBT(CompoundTag nbt, int id) {
        CompoundTag tag = new CompoundTag();
        this.writeToNBT(tag);
        nbt.m_128365_("ParticleStorage" + id, (Tag)tag);
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt, int id) {
        if (nbt.m_128441_("ParticleStorage" + id)) {
            CompoundTag tag = nbt.m_128469_("ParticleStorage" + id);
            this.readFromNBT(tag);
        }
    }

    public void setParticleStack(ParticleStack stack) {
        this.particleStack = stack;
    }

    public void setTileEntity(BlockEntity tile) {
        this.tile = tile;
    }

    @Override
    public ParticleStorageInfo getInfo() {
        return new ParticleStorageInfo(this);
    }

    @Override
    public boolean reciveParticle(Direction side, ParticleStack stack) {
        if (stack != null) {
            if (this.particleStack == null) {
                this.particleStack = stack.copy();
                this.tile.m_6596_();
                return true;
            }
            if (this.particleStack.getParticle() == stack.getParticle() && stack.getMeanEnergy() >= this.minEnergy && stack.getMeanEnergy() <= this.maxEnergy && this.particleStack.getAmount() + stack.getAmount() <= this.capacity) {
                this.particleStack.setMeanEnergy((stack.getMeanEnergy() * (long)stack.getAmount() + this.particleStack.getMeanEnergy() * (long)this.particleStack.getAmount()) / (long)(stack.getAmount() + this.particleStack.getAmount()));
                this.particleStack.addAmount(stack.getAmount());
                this.sourceDir = side != null ? side : Direction.UP;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canReciveParticle(Direction side, ParticleStack stack) {
        if (stack != null) {
            if (this.particleStack == null) {
                return true;
            }
            if (this.particleStack.getParticle() == stack.getParticle() && stack.getMeanEnergy() > this.minEnergy && stack.getMeanEnergy() < this.maxEnergy && this.particleStack.getAmount() + stack.getAmount() <= this.capacity) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractParticle(Direction side) {
        return this.particleStack != null;
    }

    @Override
    public ParticleStack getParticleStack() {
        return this.particleStack;
    }

    @Override
    public long getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public long getMinEnergy() {
        return this.minEnergy;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public void setMinEnergy(long minEnergy) {
        this.minEnergy = minEnergy;
    }

    @Override
    public ParticleStack extractParticle(Direction side) {
        if ((this.sourceDir == null || !this.sourceDir.equals((Object)side)) && this.canExtractParticle(side)) {
            ParticleStack stack = this.particleStack;
            this.particleStack = null;
            return stack;
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(Direction side, Particle type) {
        if ((this.sourceDir == null || !this.sourceDir.equals((Object)side)) && this.canExtractParticle(side) && this.particleStack.getParticle() == type) {
            return this.extractParticle(side);
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(Direction side, int amount) {
        if ((this.sourceDir == null || !this.sourceDir.equals((Object)side)) && this.canExtractParticle(side)) {
            ParticleStack stack = this.particleStack.copy();
            if (this.particleStack.getAmount() > amount) {
                stack.setAmount(amount);
            } else {
                stack.setAmount(this.particleStack.getAmount());
            }
            this.particleStack.removeAmount(amount);
        }
        return null;
    }

    @Override
    public ParticleStack extractParticle(Direction side, Particle type, int Amount) {
        if (!this.sourceDir.equals((Object)side) && this.canExtractParticle(side) && this.particleStack.getParticle() == type) {
            return this.extractParticle(side, Amount);
        }
        return null;
    }

    @Override
    public ParticleStack getParticle() {
        if (this.particleStack != null) {
            return this.particleStack.copy();
        }
        return null;
    }

    public String getCacheKey() {
        return this.particleStack == null || this.particleStack.getParticle() == null ? "" : this.particleStack.getParticle().getName();
    }

    public void clear() {
        this.particleStack = null;
        this.outputParticles.clear();
    }
}

