/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen;

import igentuman.nc.datagen.EmiLangProvider;
import igentuman.nc.datagen.NCEntityLootTables;
import igentuman.nc.datagen.NCLanguageProvider;
import igentuman.nc.datagen.NCLootTables;
import igentuman.nc.datagen.NCWorldGenProvider;
import igentuman.nc.datagen.blockstates.NCBlockStates;
import igentuman.nc.datagen.blockstates.NCFluidBlockStates;
import igentuman.nc.datagen.models.NCItemModels;
import igentuman.nc.datagen.recipes.NCRecipes;
import igentuman.nc.datagen.tags.FluidTags;
import igentuman.nc.datagen.tags.NCBiomeTags;
import igentuman.nc.datagen.tags.NCBlockTags;
import igentuman.nc.datagen.tags.NCItemTags;
import igentuman.nc.datagen.tags.NCStructureSetTags;
import igentuman.nc.datagen.tags.PoiTypeTags;
import igentuman.nc.recipes.ingredient.NcIngredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        NcIngredient.ping();
        generator.addProvider(event.includeServer(), (DataProvider)new NCRecipes(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(NCLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(NCEntityLootTables::new, LootContextParamSets.f_81415_))));
        NCBlockTags blockTags = new NCBlockTags(generator, event);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new NCItemTags(generator, blockTags, event));
        generator.addProvider(event.includeServer(), (DataProvider)new FluidTags(generator, event));
        generator.addProvider(event.includeServer(), (DataProvider)new NCStructureSetTags(generator, event));
        generator.addProvider(event.includeClient(), (DataProvider)new NCBlockStates(generator, event));
        generator.addProvider(event.includeClient(), (DataProvider)new NCFluidBlockStates(generator, event));
        generator.addProvider(event.includeClient(), (DataProvider)new NCItemModels(generator, event));
        generator.addProvider(event.includeClient(), (DataProvider)new NCLanguageProvider(generator, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new EmiLangProvider(generator, "en_gb"));
        generator.addProvider(event.includeServer(), (DataProvider)new NCBiomeTags(generator, event));
        generator.addProvider(event.includeServer(), (DataProvider)new NCWorldGenProvider(generator, event));
        generator.addProvider(event.includeServer(), (DataProvider)new PoiTypeTags(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
    }
}

