/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.blockstates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import igentuman.nc.datagen.models.ModelProviderUtil;
import igentuman.nc.datagen.models.NongeneratedModels;
import igentuman.nc.util.DataGenUtil;
import igentuman.nc.util.NCProperties;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.ObjModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ExtendedBlockstateProvider
extends BlockStateProvider {
    protected static final List<Vec3i> COLUMN_THREE = ImmutableList.of((Object)BlockPos.f_121853_, (Object)BlockPos.f_121853_.m_7494_(), (Object)BlockPos.f_121853_.m_6630_(2));
    protected static final Map<ResourceLocation, String> generatedParticleTextures = new HashMap<ResourceLocation, String>();
    protected final ExistingFileHelper existingFileHelper;
    protected final NongeneratedModels innerModels;

    public ExtendedBlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "nuclearcraft_fluids", exFileHelper);
        this.existingFileHelper = exFileHelper;
        this.innerModels = new NongeneratedModels(gen, this.existingFileHelper);
    }

    protected String name(Supplier<? extends Block> b) {
        return this.name(b.get());
    }

    protected String name(Block b) {
        return ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_();
    }

    public void simpleBlockAndItem(Supplier<? extends Block> b, ModelFile model) {
        this.simpleBlockAndItem(b, new ConfiguredModel(model));
    }

    protected void simpleBlockAndItem(Supplier<? extends Block> b, ConfiguredModel model) {
        this.simpleBlock(b.get(), new ConfiguredModel[]{model});
        this.itemModel(b, model.model);
    }

    protected void cubeSideVertical(Supplier<? extends Block> b, ResourceLocation side, ResourceLocation vertical) {
        this.simpleBlockAndItem(b, (ModelFile)this.models().cubeBottomTop(this.name(b), side, vertical, vertical));
    }

    protected void cubeAll(Supplier<? extends Block> b, ResourceLocation texture) {
        this.cubeAll(b, texture, null);
    }

    protected void cubeAll(Supplier<? extends Block> b, ResourceLocation texture, @Nullable RenderType layer) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.name(b), texture);
        this.setRenderType(layer, new ModelBuilder[]{model});
        this.simpleBlockAndItem(b, (ModelFile)model);
    }

    protected void setRenderType(@Nullable RenderType type, ModelBuilder<?> ... builders) {
        if (type != null) {
            String typeName = ModelProviderUtil.getName(type);
            for (ModelBuilder<?> model : builders) {
                model.renderType(typeName);
            }
        }
    }

    protected ResourceLocation addModelsPrefix(ResourceLocation in) {
        return ResourceLocation.m_214293_((String)in.m_135827_(), (String)("models/" + in.m_135815_()));
    }

    protected void itemModel(Supplier<? extends Block> block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(this.name(block))).parent(model);
    }

    protected NongeneratedModels.NongeneratedModel innerObj(String loc, @Nullable RenderType layer) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        NongeneratedModels.NongeneratedModel result = this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc), this.innerModels);
        this.setRenderType(layer, result);
        return result;
    }

    protected NongeneratedModels.NongeneratedModel innerObj(String loc) {
        return this.innerObj(loc, null);
    }

    protected BlockModelBuilder obj(String loc) {
        return this.obj(loc, (RenderType)null);
    }

    protected BlockModelBuilder obj(String loc, @Nullable RenderType layer) {
        BlockModelBuilder model = (BlockModelBuilder)this.obj(loc, (ModelProvider)this.models());
        this.setRenderType(layer, new ModelBuilder[]{model});
        return model;
    }

    protected <T extends ModelBuilder<T>> T obj(String loc, ModelProvider<T> modelProvider) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        return this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc), modelProvider);
    }

    protected <T extends ModelBuilder<T>> T obj(String name, ResourceLocation model, ModelProvider<T> provider) {
        return this.obj(name, model, (Map<String, ResourceLocation>)ImmutableMap.of(), provider);
    }

    protected <T extends ModelBuilder<T>> T obj(String name, ResourceLocation model, Map<String, ResourceLocation> textures, ModelProvider<T> provider) {
        return (T)this.obj(provider.withExistingParent(name, this.mcLoc("block")), model, textures);
    }

    protected <T extends ModelBuilder<T>> T obj(T base, ResourceLocation model, Map<String, ResourceLocation> textures) {
        this.assertModelExists(model);
        ModelBuilder ret = ((ObjModelBuilder)base.customLoader(ObjModelBuilder::begin)).automaticCulling(false).modelLocation(this.addModelsPrefix(model)).flipV(true).end();
        String particleTex = DataGenUtil.getTextureFromObj(model, this.existingFileHelper);
        if (particleTex.charAt(0) == '#') {
            particleTex = textures.get(particleTex.substring(1)).toString();
        }
        ret.texture("particle", particleTex);
        generatedParticleTextures.put(ret.getLocation(), particleTex);
        for (Map.Entry<String, ResourceLocation> e : textures.entrySet()) {
            ret.texture(e.getKey(), e.getValue());
        }
        return (T)ret;
    }

    protected void addParticleTextureFrom(BlockModelBuilder result, ModelFile model) {
        String particles = generatedParticleTextures.get(model.getLocation());
        if (particles != null) {
            result.texture("particle", particles);
            generatedParticleTextures.put(result.getLocation(), particles);
        }
    }

    protected ConfiguredModel emptyWithParticles(String name, String particleTexture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/ie_empty"))).texture("particle", particleTexture);
        generatedParticleTextures.put(this.modLoc(name), particleTexture);
        return new ConfiguredModel((ModelFile)model);
    }

    public void assertModelExists(ResourceLocation name) {
        String suffix = name.m_135815_().contains(".") ? "" : ".json";
        Preconditions.checkState((boolean)this.existingFileHelper.exists(name, PackType.CLIENT_RESOURCES, suffix, "models"), (Object)("Model \"" + name + "\" does not exist"));
    }

    protected int getAngle(Direction dir, int offset) {
        return (int)((dir.m_122435_() + (float)offset) % 360.0f);
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, ModelFile model) {
        this.createHorizontalRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, List.of());
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, ModelFile model, int offsetRotY) {
        this.createRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, (Property<Direction>)NCProperties.FACING_HORIZONTAL, List.of(), 0, offsetRotY);
    }

    protected void createHorizontalRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, (Property<Direction>)NCProperties.FACING_HORIZONTAL, additionalProps, 0, 180);
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, ModelFile model) {
        this.createAllRotatedBlock(block, $ -> model, List.of());
    }

    protected void createAllRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, List<Property<?>> additionalProps) {
        this.createRotatedBlock(block, model, (Property<Direction>)NCProperties.FACING_ALL, additionalProps, 90, 0);
    }

    protected void createRotatedBlock(Supplier<? extends Block> block, ModelFile model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        this.createRotatedBlock(block, (VariantBlockStateBuilder.PartialBlockstate $) -> model, facing, additionalProps, offsetRotX, offsetRotY);
    }

    protected void createRotatedBlock(Supplier<? extends Block> block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, Property<Direction> facing, List<Property<?>> additionalProps, int offsetRotX, int offsetRotY) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block.get());
        ExtendedBlockstateProvider.forEachState(stateBuilder.partialState(), additionalProps, state -> {
            ModelFile modelLoc = (ModelFile)model.apply((VariantBlockStateBuilder.PartialBlockstate)state);
            for (Direction d : facing.m_6908_()) {
                int y;
                int x;
                switch (d) {
                    case UP: {
                        x = 90;
                        y = 0;
                        break;
                    }
                    case DOWN: {
                        x = -90;
                        y = 0;
                        break;
                    }
                    default: {
                        y = this.getAngle(d, offsetRotY);
                        x = 0;
                    }
                }
                state.with(facing, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(modelLoc, x + offsetRotX, y, false)});
            }
        });
    }

    protected static String getName(RenderStateShard state) {
        try {
            Field f = RenderStateShard.class.getDeclaredField("name");
            f.setAccessible(true);
            return (String)f.get(state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Comparable<T>> void forEach(VariantBlockStateBuilder.PartialBlockstate base, Property<T> prop, List<Property<?>> remaining, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        for (Comparable value : prop.m_6908_()) {
            ExtendedBlockstateProvider.forEachState(base, remaining, map -> {
                map = map.with(prop, value);
                out.accept((VariantBlockStateBuilder.PartialBlockstate)map);
            });
        }
    }

    public static void forEachState(VariantBlockStateBuilder.PartialBlockstate base, List<Property<?>> props, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        if (props.size() > 0) {
            List<Property<?>> remaining = props.subList(1, props.size());
            Property<?> main = props.get(0);
            ExtendedBlockstateProvider.forEach(base, main, remaining, out);
        } else {
            out.accept(base);
        }
    }
}

