/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.blockstates;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.block.BatteryBlockLoader;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.setup.registration.NCStorageBlocks;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class NCBlockStates
extends BlockStateProvider {
    public NCBlockStates(DataGenerator gen, GatherDataEvent event) {
        super(gen.getPackOutput(), "nuclearcraft", event.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        this.wasteland();
        this.ores();
        this.blocks();
        this.processors();
        this.solarPanels();
        this.energyBlocks();
        this.rtgs();
        this.materialFluidBlocks();
        this.heatSinks();
        this.coolers();
        this.fissionReactor();
        this.turbine();
        this.storageBlocks();
        this.fusionReactor();
        this.kugelblitz();
        this.accelerator();
        this.targetChamber();
    }

    private void accelerator() {
        this.horizontalBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get(), st -> this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get(), "accelerator/accelerator_ion_source_port"));
        this.horizontalBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_port").get(), st -> this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_port").get(), "accelerator/accelerator_port"));
        this.horizontalBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get(), "accelerator/controller")));
        this.horizontalBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("ring_accelerator_controller").get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("ring_accelerator_controller").get(), "accelerator/controller")));
        this.simpleBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("electromagnet_yoke").get(), this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("electromagnet_yoke").get(), "accelerator/electromagnet_yoke"));
        this.simpleBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_casing").get(), this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_casing").get(), "accelerator/accelerator_casing"));
        this.simpleBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_casing_glass").get(), this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_casing_glass").get(), "accelerator/accelerator_casing_glass"));
        this.simpleBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get(), this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get(), "accelerator/particle_beam"));
    }

    private void targetChamber() {
        this.horizontalBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_port").get(), st -> this.multiBlockModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_port").get(), "particle_chamber/port"));
        this.horizontalBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_controller").get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_controller").get(), "particle_chamber/target_chamber_controller")));
        for (String name : TargetChamberRegistration.TARGET_CHAMBER_DETECTORS.keySet()) {
            this.simpleBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(name).get(), this.multiBlockModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get(name).get(), "particle_chamber/" + name));
        }
        this.simpleBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_camera").get(), this.multiBlockModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_camera").get(), "particle_chamber/camera"));
        this.simpleBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_casing").get(), this.multiBlockModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_casing").get(), "particle_chamber/casing"));
        this.simpleBlock((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_casing_glass").get(), this.multiBlockModel((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_casing_glass").get(), "particle_chamber/glass"));
    }

    private void turbine() {
        this.horizontalBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_controller").get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_controller").get(), "turbine/controller")));
        this.horizontalBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_port").get(), this.multiBlockModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_port").get(), "turbine/port"));
        this.faceBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_rotor_shaft").get(), $ -> this.models().getExistingFile(NuclearCraft.rl("block/multiblock/turbine_rotor_shaft")));
        this.simpleBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_bearing").get(), this.multiBlockModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_bearing").get(), "turbine/bearing"));
        this.simpleBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_casing").get(), this.multiBlockModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_casing").get(), "turbine/casing"));
        this.simpleBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_glass").get(), this.multiBlockModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_glass").get(), "turbine/glass"));
        for (String string : TurbineRegistration.blades().keySet()) {
        }
        for (String type : TurbineRegistration.coils.keySet()) {
            this.simpleBlock((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_" + type + "_coil").get(), this.multiBlockModel((Block)TurbineRegistration.TURBINE_BLOCKS.get("turbine_" + type + "_coil").get(), "turbine/" + type + "_coil"));
        }
    }

    private void kugelblitz() {
        this.horizontalBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get(), "kugelblitz/controller")));
        this.horizontalBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_port").get(), st -> this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_port").get(), "kugelblitz/port"));
        this.simpleBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("neutronium_frame").get(), this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("neutronium_frame").get(), "kugelblitz/neutronium_frame"));
        this.simpleBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("event_horizon_stabilizer").get(), this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("event_horizon_stabilizer").get(), "kugelblitz/event_horizon_stabilizer"));
        this.simpleBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("photon_concentrator").get(), this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("photon_concentrator").get(), "kugelblitz/photon_concentrator"));
        this.simpleBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_flux_regulator").get(), this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_flux_regulator").get(), "kugelblitz/quantum_flux_regulator"));
        this.simpleBlock((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_transformer").get(), this.multiBlockModel((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("quantum_transformer").get(), "kugelblitz/quantum_transformer"));
    }

    public static int[] getRotationByDirection(Direction dir) {
        int[] result = new int[2];
        switch (dir) {
            case UP: {
                result[0] = 270;
                result[1] = 0;
                break;
            }
            case DOWN: {
                result[0] = 90;
                result[1] = 0;
                break;
            }
            case NORTH: {
                result[0] = 0;
                result[1] = 0;
                break;
            }
            case EAST: {
                result[0] = 0;
                result[1] = 270;
                break;
            }
            case SOUTH: {
                result[0] = 0;
                result[1] = 180;
                break;
            }
            case WEST: {
                result[0] = 0;
                result[1] = 90;
            }
        }
        return result;
    }

    public void faceBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(NCBlockStates.getRotationByDirection((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))[0]).rotationY(NCBlockStates.getRotationByDirection((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))[1]).build(), new Property[0]);
    }

    private void storageBlocks() {
        for (String name : BarrelBlocks.all().keySet()) {
            this.simpleBlock((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/barrel/" + name)));
        }
        for (String name : ContainerBlocks.all().keySet()) {
            this.simpleBlock((Block)NCStorageBlocks.STORAGE_BLOCKS.get(name).get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/container/" + name)));
        }
    }

    private void coolers() {
        for (String name : AcceleratorRegistration.COOLERS.keySet()) {
            this.simpleBlock((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get(name + "_cooler").get(), this.multiBlockModel((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get(name + "_cooler").get(), "accelerator/cooler/" + name));
        }
    }

    private void heatSinks() {
        for (String name : FissionReactorRegistration.heatsinks.keySet()) {
            this.simpleBlock((Block)FissionReactorRegistration.FISSION_BLOCKS.get(name + "_heat_sink").get(), this.multiBlockModel((Block)FissionReactorRegistration.FISSION_BLOCKS.get(name + "_heat_sink").get(), "heat_sink/" + name));
        }
    }

    private void fissionReactor() {
        for (String name : FissionReactorRegistration.reactor) {
            if (name.matches(".*port.*")) {
                this.horizontalBlock((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), this.multiBlockModel((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), "fission/" + name));
                continue;
            }
            if (name.matches(".*controller.*")) {
                this.horizontalBlock((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), st -> this.controllerModel((BlockState)st, this.sidedModel((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), "fission/controller")));
                continue;
            }
            if (name.contains("slope")) {
                this.orientationalBlock((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), $ -> this.models().getExistingFile(NuclearCraft.rl("block/multiblock/fission_reactor_" + name)));
                continue;
            }
            this.simpleBlock((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), this.multiBlockModel((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_" + name).get(), "fission/" + name));
        }
    }

    private void fusionReactor() {
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_core").get()).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(NuclearCraft.rl("block/fusion/core_center"))).addModel()).partialState().with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(NuclearCraft.rl("block/dummy"))).addModel();
        this.simpleBlock((Block)FusionReactorRegistration.FUSION_CORE_PROXY.get(), (ModelFile)this.models().getExistingFile(NuclearCraft.rl("block/fusion/core_proxy")));
        this.simpleBlock((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_casing").get(), this.model((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_casing").get(), "fusion"));
        this.simpleBlock((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_casing_glass").get(), this.model((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_casing_glass").get(), "fusion"));
        this.simpleBlock((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_connector").get(), this.model((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_reactor_connector").get(), "fusion"));
    }

    private void rtgs() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            if (!name.contains("rtg")) continue;
            String type = name.replace("_rtg", "");
            this.simpleBlock((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), this.energyModel((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), "rtg/" + type + "/"));
        }
    }

    private void solarPanels() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            if (!name.contains("solar_panel")) continue;
            this.simpleBlock((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), this.energyModel((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), name + "_"));
        }
    }

    private void energyBlocks() {
        for (String name : NCEnergyBlocks.ENERGY_BLOCKS.keySet()) {
            if (name.matches(".*voltaic_pile|.*lithium_ion_battery")) {
                String tier = name.replaceAll("voltaic_pile|lithium_ion_battery", "");
                String category = name.replace(tier, "");
                this.simpleBlock((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), this.energyModel((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), category + "/" + tier.replace("_", "") + "/"));
                continue;
            }
            if (name.contains("rtg") || name.contains("solar")) continue;
            this.simpleBlock((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get(), (ModelFile)this.models().cubeAll(name, NuclearCraft.rl("block/energy/" + name)));
        }
    }

    private void processors() {
        for (String name : NCProcessors.PROCESSORS.keySet()) {
            if (name.equals("leacher")) continue;
            this.horizontalBlock((Block)NCProcessors.PROCESSORS.get(name).get(), st -> this.processorModel((BlockState)st, this.sidedModel((Block)NCProcessors.PROCESSORS.get(name).get(), "processor")));
        }
    }

    public BlockModelBuilder processorModel(BlockState st, ModelFile model) {
        String powered = (Boolean)st.m_61143_((Property)BlockStateProperties.f_61448_) != false ? "_powered" : "";
        BlockModelBuilder result = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/processor/" + this.key(st.m_60734_()).m_135815_() + powered)).texture("north", "block/processor/" + this.key(st.m_60734_()).m_135815_() + powered);
        if (((Boolean)st.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            result.parent(model);
        }
        return result;
    }

    public BlockModelBuilder controllerModel(BlockState st, ModelFile model) {
        String powered = (Boolean)st.m_61143_((Property)BlockStateProperties.f_61448_) != false ? "_powered" : "";
        String type = "";
        if (st.m_60734_() == FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_controller").get()) {
            type = "fission";
        } else if (st.m_60734_() == TurbineRegistration.TURBINE_BLOCKS.get("turbine_controller").get()) {
            type = "turbine";
        } else if (st.m_60734_() == KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get()) {
            type = "kugelblitz";
        } else if (st.m_60734_() == AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get()) {
            type = "accelerator";
        } else if (st.m_60734_() == AcceleratorRegistration.ACCELERATOR_BLOCKS.get("ring_accelerator_controller").get()) {
            type = "accelerator";
        } else if (st.m_60734_() == TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_controller").get()) {
            type = "particle_chamber";
        }
        BlockModelBuilder result = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/multiblock/" + this.key(st.m_60734_()).m_135815_() + powered)).texture("north", "block/" + type + "/controller/" + this.key(st.m_60734_()).m_135815_() + powered);
        if (((Boolean)st.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            result.parent(model);
        }
        return result;
    }

    public void directionalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_155997_)).m_122435_() + 180) % 360).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    private void materialFluidBlocks() {
    }

    private void blocks() {
        for (String name : NCBlocks.NC_BLOCKS.keySet()) {
            this.simpleBlock((Block)NCBlocks.NC_BLOCKS.get(name).get(), this.model((Block)NCBlocks.NC_BLOCKS.get(name).get(), "material/block"));
        }
        for (String name : NCBlocks.NC_MATERIAL_BLOCKS.keySet()) {
            this.simpleBlock((Block)NCBlocks.NC_MATERIAL_BLOCKS.get(name).get(), this.model((Block)NCBlocks.NC_MATERIAL_BLOCKS.get(name).get(), "material/block"));
        }
        for (String name : NCBlocks.NC_ELECTROMAGNETS.keySet()) {
            if (name.contains("slope")) {
                this.orientationalBlock((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), $ -> this.models().getExistingFile(NuclearCraft.rl("block/electromagnet/" + name)));
                continue;
            }
            this.simpleBlock((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), this.model((Block)NCBlocks.NC_ELECTROMAGNETS.get(name).get(), "electromagnet"));
        }
        for (String name : NCBlocks.NC_RF_AMPLIFIERS.keySet()) {
            this.simpleBlock((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), this.model((Block)NCBlocks.NC_RF_AMPLIFIERS.get(name).get(), "rf_amplifier"));
        }
    }

    public void orientationalBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> {
            FrontAndTop dir = (FrontAndTop)state.m_61143_((Property)BlockStateProperties.f_61375_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir.m_122625_() == Direction.DOWN ? 180 : 0).rotationY(((int)dir.m_122629_().m_122435_() + 180) % 360).build();
        });
    }

    private void ores() {
        for (String ore : NCBlocks.ORE_BLOCKS.keySet()) {
            this.simpleBlock((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), this.model((Block)NCBlocks.ORE_BLOCKS.get(ore).get(), "ore"));
        }
    }

    private void wasteland() {
        Block block = (Block)NCBlocks.PORTAL_BLOCK.get();
        ResourceLocation side = this.modLoc("block/portal");
        ResourceLocation top = this.modLoc("block/portal");
        this.simpleBlock(block, (ModelFile)this.models().cube(NCBlocks.PORTAL_BLOCK.getId().m_135815_(), side, top, side, side, side, side));
        this.simpleBlock((Block)NCBlocks.WASTELAND_EARTH.get());
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public ModelFile model(Block block, String subPath) {
        ResourceLocation name = this.key(block);
        String blockPath = "";
        switch (subPath) {
            case "ore": {
                blockPath = "block/ore/";
                break;
            }
            case "material/block": {
                blockPath = "block/material/";
                break;
            }
            case "processor": {
                blockPath = "block/processor/";
                break;
            }
            case "fusion": {
                blockPath = "block/fusion/";
                break;
            }
            case "kugelblitz": {
                blockPath = "block/kugelblitz/";
                break;
            }
            case "electromagnet": {
                blockPath = "block/electromagnet/";
                break;
            }
            case "rf_amplifier": {
                blockPath = "block/rf_amplifier/";
            }
        }
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(blockPath + this.key(block).m_135815_(), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/" + name.m_135815_())));
        if (name.m_135815_().matches(".*glass|.*cell.*|.*photon.*|.*event_horizon_stabilizer.*|.*quantum_transformer.*")) {
            model.renderType(ResourceLocation.m_214293_((String)"minecraft", (String)"cutout"));
        }
        return model;
    }

    public ModelFile multiBlockModel(Block block, String subPath) {
        ResourceLocation name = this.key(block);
        if (subPath.matches(".*controller|.*port.*")) {
            return this.sidedModel(block, subPath);
        }
        BlockModelBuilder m = (BlockModelBuilder)this.models().cubeAll("block/multiblock/" + this.key(block).m_135815_(), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath)));
        if (subPath.matches(".*glass|.*cell.*|.*photon.*|.*event_horizon_stabilizer.*|.*quantum_transformer.*")) {
            m.renderType(ResourceLocation.m_214293_((String)"minecraft", (String)"cutout"));
        }
        return m;
    }

    public ModelFile sidedModel(Block block, String subPath) {
        ResourceLocation name = this.key(block);
        String blockPath = "";
        switch (subPath) {
            case "ore": {
                blockPath = "block/ore/";
                break;
            }
            case "material/block": {
                blockPath = "block/material/";
                break;
            }
            case "processor": {
                blockPath = "block/processor/";
            }
        }
        if (subPath.matches(".*fission.*|.*fusion.*|.*port.*|.*controller.*")) {
            blockPath = "block/multiblock/";
        }
        return ((BlockModelBuilder)this.models().cube(blockPath + this.key(block).m_135815_(), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/top")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/bottom")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/" + name.m_135815_())), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/back")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/side")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/" + subPath + "/side")))).texture("particle", "block/" + subPath + "/side");
    }

    public ModelFile energyModel(Block block, String subPath) {
        ResourceLocation name = this.key(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cube(this.key(block).m_135815_(), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "side")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "top")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "side")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "side")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "side")), ResourceLocation.m_214293_((String)name.m_135827_(), (String)("block/energy/" + subPath + "side")));
        model.texture("particle", "block/energy/" + subPath + "top");
        if (subPath.matches(".*voltaic_pile.*|.*lithium_ion_battery.*")) {
            model.customLoader((blockModelBuilder, helper) -> new CustomLoaderBuilder<BlockModelBuilder>(BatteryBlockLoader.BATTERY_LOADER, blockModelBuilder, helper){});
        }
        return model;
    }
}

