/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.datagen.recipes.builder.RecipeBuilder;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class NcRecipeBuilder
extends RecipeBuilder<NcRecipeBuilder> {
    private List<NcIngredient> inputItems = List.of();
    private List<NcIngredient> outputItems = List.of();
    private List<FluidStackIngredient> inputFluids = List.of();
    private List<FluidStackIngredient> outputFluids = List.of();
    private List<ParticleStack> inputParticles = List.of();
    private List<ParticleStack> outputParticles = List.of();
    private static NcRecipeBuilder instance;
    private double timeModifier = 1.0;
    private double radiation = 1.0;
    private double powerModifier = 1.0;
    private long maxEnergy = 0L;
    public double coolingRate = 0.0;
    public double heatRequired = 0.0;
    public String ID;
    private double rarityModifier = 1.0;
    private double temperature = 0.0;
    private List<String> outputItemsText = List.of();
    private double crossSection = 0.0;
    private boolean useInputForId = false;

    protected NcRecipeBuilder(String id) {
        super(NcRecipeBuilder.ncSerializer(id));
        this.ID = id;
    }

    public static NcRecipeBuilder get(String id) {
        instance = new NcRecipeBuilder(id);
        return instance;
    }

    public NcRecipeBuilder items(List<NcIngredient> input, List<NcIngredient> output) {
        NcRecipeBuilder.instance.inputItems = input;
        NcRecipeBuilder.instance.outputItems = output;
        return instance;
    }

    public NcRecipeBuilder itemsString(List<NcIngredient> input, List<String> output) {
        NcRecipeBuilder.instance.inputItems = input;
        NcRecipeBuilder.instance.outputItemsText = output;
        return instance;
    }

    public NcRecipeBuilder fluids(List<FluidStackIngredient> input, List<FluidStackIngredient> output) {
        NcRecipeBuilder.instance.inputFluids = input;
        NcRecipeBuilder.instance.outputFluids = output;
        return instance;
    }

    public NcRecipeBuilder modifiers(double timeModifier, double radiation, double powerModifier, double rarity) {
        this.timeModifier = timeModifier;
        this.radiation = radiation;
        this.powerModifier = powerModifier;
        this.rarityModifier = rarity;
        return this;
    }

    public NcRecipeBuilder modifiers(double timeModifier, double radiation, double powerModifier) {
        this.timeModifier = timeModifier;
        this.radiation = radiation;
        this.powerModifier = powerModifier;
        return this;
    }

    @Override
    protected NcRecipeResult getResult(ResourceLocation id) {
        return new NcRecipeResult(id);
    }

    public ResourceLocation getRecipeId() {
        StringBuilder name = new StringBuilder();
        for (ParticleStack particleStack : this.inputParticles) {
            name.append(particleStack.getParticle().getName()).append("-").append(particleStack.getMeanEnergy()).append("-");
        }
        for (NcIngredient ncIngredient : this.inputItems) {
            name.append(ncIngredient.getName()).append("-");
        }
        for (FluidStackIngredient fluidStackIngredient : this.inputFluids) {
            name.append(fluidStackIngredient.getName()).append("-");
        }
        if (this.useInputForId) {
            for (FluidStackIngredient fluidStackIngredient : this.outputFluids) {
                name.append(fluidStackIngredient.getName()).append("-");
            }
        }
        name.replace(name.length() - 1, name.length(), "");
        return NuclearCraft.rl(this.ID + "/" + this.recipeIdReplacements(name.toString()));
    }

    protected String recipeIdReplacements(String val) {
        val = val.replace("nuclearcraft_", "");
        val = val.replace("depleted_fuel", "d_f");
        return val;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this.getRecipeId());
    }

    public NcRecipeBuilder temperature(double temperature) {
        this.temperature = temperature;
        return this;
    }

    public NcRecipeBuilder coolingRate(double coolingRate) {
        this.coolingRate = coolingRate;
        return this;
    }

    public NcRecipeBuilder heatRequired(double heatRequired) {
        this.heatRequired = heatRequired;
        return this;
    }

    public NcRecipeBuilder useInputForId(boolean b) {
        this.useInputForId = b;
        return this;
    }

    public NcRecipeBuilder particles(List<ParticleStack> inputParticles, List<ParticleStack> outputParticles) {
        this.inputParticles = inputParticles;
        this.outputParticles = outputParticles;
        return this;
    }

    public NcRecipeBuilder maxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
        return this;
    }

    public NcRecipeBuilder crossSection(double crossSection) {
        this.crossSection = crossSection;
        return this;
    }

    public class NcRecipeResult
    extends RecipeBuilder.RecipeResult {
        protected NcRecipeResult(ResourceLocation id) {
            super(NcRecipeBuilder.this, id);
        }

        public void m_7917_(@NotNull JsonObject json) {
            JsonArray inputJson = new JsonArray();
            if (!NcRecipeBuilder.this.inputItems.isEmpty()) {
                for (Ingredient ingredient : NcRecipeBuilder.this.inputItems) {
                    inputJson.add(RecipeBuilder.serializeIngredient(ingredient));
                }
                json.add("input", (JsonElement)inputJson);
            }
            JsonArray outJson = new JsonArray();
            if (!NcRecipeBuilder.this.outputItems.isEmpty()) {
                for (Ingredient ingredient : NcRecipeBuilder.this.outputItems) {
                    outJson.add(RecipeBuilder.serializeIngredient(ingredient));
                }
                json.add("output", (JsonElement)outJson);
            }
            if (!NcRecipeBuilder.this.outputItemsText.isEmpty()) {
                outJson = new JsonArray();
                for (String string : NcRecipeBuilder.this.outputItemsText) {
                    JsonObject item = new JsonObject();
                    item.addProperty("item", string);
                    outJson.add((JsonElement)item);
                }
                json.add("output", (JsonElement)outJson);
            }
            inputJson = new JsonArray();
            for (FluidStackIngredient fluidStackIngredient : NcRecipeBuilder.this.inputFluids) {
                inputJson.add(fluidStackIngredient.serialize());
            }
            if (!NcRecipeBuilder.this.inputFluids.isEmpty()) {
                json.add("inputFluids", (JsonElement)inputJson);
            }
            if (!NcRecipeBuilder.this.inputParticles.isEmpty()) {
                inputJson = new JsonArray();
                for (ParticleStack particleStack : NcRecipeBuilder.this.inputParticles) {
                    inputJson.add((JsonElement)particleStack.serialize());
                }
                json.add("inputParticles", (JsonElement)inputJson);
            }
            outJson = new JsonArray();
            if (!NcRecipeBuilder.this.outputFluids.isEmpty()) {
                for (FluidStackIngredient fluidStackIngredient : NcRecipeBuilder.this.outputFluids) {
                    outJson.add(fluidStackIngredient.serialize());
                }
                json.add("outputFluids", (JsonElement)outJson);
            }
            if (!NcRecipeBuilder.this.outputParticles.isEmpty()) {
                inputJson = new JsonArray();
                for (ParticleStack particleStack : NcRecipeBuilder.this.outputParticles) {
                    inputJson.add((JsonElement)particleStack.serialize());
                }
                json.add("outputParticles", (JsonElement)inputJson);
            }
            if (NcRecipeBuilder.this.heatRequired > 0.0) {
                json.addProperty("heatRequired", (Number)NcRecipeBuilder.this.heatRequired);
            }
            if (NcRecipeBuilder.this.coolingRate > 0.0) {
                json.addProperty("coolingRate", (Number)NcRecipeBuilder.this.coolingRate);
            }
            if (NcRecipeBuilder.this.timeModifier > 0.0) {
                json.addProperty("timeModifier", (Number)NcRecipeBuilder.this.timeModifier);
            }
            if (NcRecipeBuilder.this.radiation != 0.0) {
                json.addProperty("radiation", (Number)NcRecipeBuilder.this.radiation);
            }
            if (NcRecipeBuilder.this.powerModifier > 0.0) {
                json.addProperty("powerModifier", (Number)NcRecipeBuilder.this.powerModifier);
            }
            if (NcRecipeBuilder.this.rarityModifier != 1.0 && NcRecipeBuilder.this.rarityModifier != 0.0) {
                json.addProperty("rarityModifier", (Number)NcRecipeBuilder.this.rarityModifier);
            }
            if (NcRecipeBuilder.this.temperature != 0.0) {
                json.addProperty("temperature", (Number)NcRecipeBuilder.this.temperature);
            }
            if (!NcRecipeBuilder.this.inputParticles.isEmpty()) {
                NcRecipeBuilder.this.maxEnergy = NcRecipeBuilder.this.maxEnergy > 0L ? NcRecipeBuilder.this.maxEnergy : NcRecipeBuilder.this.inputParticles.get(0).getMeanEnergy() * 2L;
                NcRecipeBuilder.this.crossSection = NcRecipeBuilder.this.crossSection > 0.0 ? NcRecipeBuilder.this.crossSection : 5.0;
                json.addProperty("maxEnergy", (Number)NcRecipeBuilder.this.maxEnergy);
                json.addProperty("crossSection", (Number)NcRecipeBuilder.this.crossSection);
            }
        }
    }
}

