/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.server;

import igentuman.nc.item.ContainerBlockItem;
import igentuman.nc.item.HEVItem;
import igentuman.nc.item.HazmatItem;
import igentuman.nc.setup.registration.NCItems;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    @SubscribeEvent
    public static void onPickupItem(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack pickedUpItem = event.getItem().m_32055_();
        if (pickedUpItem.m_41619_()) {
            return;
        }
        block0: for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            IItemHandler inventory;
            ContainerBlockItem containerItem;
            ItemStack inventoryStack = player.m_150109_().m_8020_(i);
            Item item = inventoryStack.m_41720_();
            if (!(item instanceof ContainerBlockItem) || !(containerItem = (ContainerBlockItem)item).isMagnetModeEnabled(inventoryStack) || (inventory = containerItem.getInventory(inventoryStack)) == null) continue;
            ItemStack remainingStack = pickedUpItem.m_41777_();
            for (int slot = 0; slot < inventory.getSlots() && !remainingStack.m_41619_(); ++slot) {
                ItemStack simulatedRemaining = inventory.insertItem(slot, remainingStack, true);
                if (simulatedRemaining.m_41613_() >= remainingStack.m_41613_()) continue;
                if ((remainingStack = inventory.insertItem(slot, remainingStack, false)).m_41619_()) {
                    pickedUpItem.m_41764_(0);
                    event.setResult(Event.Result.DENY);
                    continue block0;
                }
                pickedUpItem.m_41764_(remainingStack.m_41613_());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            int protectionRate;
            Player player = (Player)livingEntity;
            if (event.getSource() != null && event.getSource().m_276093_(DamageTypes.f_268515_) && PlayerEvents.isFullyEquipped(player)) {
                event.setAmount(event.getAmount() / 10.0f);
            }
            if (event.getSource() != null && (event.getSource().m_276093_(DamageTypes.f_268671_) || event.getSource().m_276093_(DamageTypes.f_268669_) || event.getSource().m_276093_(DamageTypes.f_268434_))) {
                player.m_6168_().forEach(stack -> {
                    if (stack.m_41720_().equals(NCItems.HEV_BOOTS.get()) && PlayerEvents.isCharged(stack)) {
                        PlayerEvents.consumeEnergy(stack, 1000 * (event.getSource().m_276093_(DamageTypes.f_268669_) || event.getSource().m_276093_(DamageTypes.f_268434_) ? 2 : 1));
                        event.setCanceled(true);
                        return;
                    }
                });
            }
            if ((protectionRate = PlayerEvents.getHEVProtectionRate(player)) > 0) {
                event.setAmount(event.getAmount() - event.getAmount() * ((float)protectionRate * 0.1f));
                for (ItemStack stack2 : player.m_6168_()) {
                    PlayerEvents.consumeEnergy(stack2, 1000);
                }
            }
        }
    }

    public static int getHEVProtectionRate(Player player) {
        int rate = 0;
        for (ItemStack stack : player.m_6168_()) {
            if (!(stack.m_41720_() instanceof HEVItem) || !PlayerEvents.isCharged(stack)) continue;
            ++rate;
        }
        return rate;
    }

    public static boolean isFullyEquipped(Player player) {
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41720_() instanceof HazmatItem || stack.m_41720_() instanceof HEVItem) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharged(ItemStack item) {
        return item.getCapability(ForgeCapabilities.ENERGY).map(handler -> handler.getEnergyStored() > 0).orElse(false);
    }

    private static void consumeEnergy(ItemStack stack, int i) {
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> handler.extractEnergy(i, false));
    }
}

