/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.content.ArmorMaterials;
import igentuman.nc.handler.ItemEnergyHandler;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.capability.CapabilityUtils;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HEVItem
extends ArmorItem {
    public HEVItem(ArmorMaterials armorMaterials, ArmorItem.Type type, Item.Properties hazmatProps) {
        super((ArmorMaterial)armorMaterials, type, hazmatProps);
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    protected int getEnergyMaxStorage() {
        return 1000000;
    }

    public int m_142158_(ItemStack stack) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        float chargeRatio = (float)energyStorage.getEnergyStored() / (float)this.getEnergyMaxStorage();
        return (int)Math.min(13.0f, 13.0f * chargeRatio);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemEnergyHandler(stack, this.getEnergyMaxStorage(), 5000, this.getEnergyMaxStorage() / 4);
    }

    public void onInventoryTick(ItemStack st, Level level, Player player, int slotIndex, int selectedIndex) {
        if (this.charged(st)) {
            if (st.m_150930_((Item)NCItems.HEV_CHEST.get()) && player.m_6844_(EquipmentSlot.CHEST).equals(st)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1, 1, false, false));
            }
            if (st.m_150930_((Item)NCItems.HEV_HELMET.get()) && player.m_6844_(EquipmentSlot.HEAD).equals(st)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 1, 1, false, false));
            }
            if (st.m_150930_((Item)NCItems.HEV_PANTS.get()) && player.m_6844_(EquipmentSlot.LEGS).equals(st)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1, 1, false, false));
            }
        }
    }

    private boolean charged(ItemStack st) {
        return this.getEnergy(st).getEnergyStored() > 0;
    }

    public CustomEnergyStorage getEnergy(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)TextUtils.__("tooltip.nc.energy_stored", this.formatEnergy(this.getEnergy(stack).getEnergyStored()), this.formatEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.BLUE));
        list.add((Component)TextUtils.__("tooltip.nc.hev.desc", new Object[0]).m_130940_(ChatFormatting.AQUA));
    }

    public String formatEnergy(int energy) {
        return TextUtils.scaledFormat(energy) + " FE";
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }
}

