/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock;

import igentuman.api.nc.multiblock.Multiblock;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.api.nc.multiblock.MultiblockController;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.math.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMultiblock
implements Multiblock {
    public boolean hasToRefresh = true;
    public BlockPos errorBlockPos = BlockPos.f_121853_;
    public int connectedPorts = 0;
    protected int height;
    protected int width;
    protected int depth;
    protected MultiblockController controller;
    public ValidationResult validationResult = ValidationResult.INCOMPLETE;
    public String id;
    public int topCasing = 0;
    public int bottomCasing = 0;
    public int leftCasing = 0;
    public int rightCasing = 0;
    protected BlockPos bottomLeft;
    protected BlockPos topRight;
    protected boolean outerValid = false;
    protected boolean isFormed = false;
    protected boolean innerValid = false;
    protected final HashSet<Block> validOuterBlocks;
    protected final HashSet<Block> validInnerBlocks;
    protected final HashSet<BlockPos> controllers = new HashSet();
    protected final HashMap<Long, BlockEntity> beCache = new HashMap();
    protected final HashMap<Long, BlockState> bsCache = new HashMap(10000);
    protected final HashSet<Long> allBlocks = new HashSet(10000);
    protected BlockPosInstance controllerPos;
    protected BlockPosInstance initialPos;
    protected Direction multiblockDirection;
    protected MultiblockControllerBE controllerBe;
    private static final Pattern SPECIAL_BLOCKS = Pattern.compile(".*(fusion_proxy|fusion_core|controller|port|irradiator|rotor|chamber_terminal).*");
    private static final Pattern CONTROLLERS = Pattern.compile(".*(controller|terminal).*");
    private Level level;
    protected AABB structureBounds;
    private CompletableFuture<Void> validationFuture;
    public boolean isValidating = true;
    protected boolean canTick = true;

    protected AbstractMultiblock(HashSet<Block> validOuterBlocks, HashSet<Block> validInnerBlocks, MultiblockController controller) {
        this.validOuterBlocks = validOuterBlocks;
        this.validInnerBlocks = validInnerBlocks;
        this.controller = controller;
        this.controllerPos = BlockPosInstance.of(this.controller().controllerBE().m_58899_());
        NuclearCraft.debugLog("Created " + this.getClass().getSimpleName() + " at " + this.controllerPos.m_123344_() + " with " + validOuterBlocks.size() + " valid outer blocks and " + validInnerBlocks.size() + " valid inner blocks");
    }

    @Override
    public void dispose() {
        NuclearCraft.debugLog("Disposing multiblock " + this.getClass().getSimpleName() + " at " + this.controllerPos.m_123344_());
        if (this.validationFuture != null && !this.validationFuture.isDone()) {
            this.validationFuture.cancel(true);
        }
        this.validationFuture = null;
        MultiblockHandler.get((ResourceKey<Level>)this.getLevel().m_46472_()).removeMultiblock(this);
    }

    public CompletableFuture<Void> getValidationFuture() {
        return this.validationFuture;
    }

    public void setValidationFuture(CompletableFuture<Void> validationFuture) {
        this.validationFuture = validationFuture;
    }

    public HashSet<Block> validCornerBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public int maxHeight() {
        return 24;
    }

    @Override
    public int minHeight() {
        return 3;
    }

    @Override
    public int maxWidth() {
        return 24;
    }

    @Override
    public int minWidth() {
        return 3;
    }

    @Override
    public int maxDepth() {
        return 24;
    }

    @Override
    public int minDepth() {
        return 3;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    public boolean isPort(BlockState bs) {
        return bs.m_60734_().m_5456_().toString().contains("port");
    }

    @Override
    public HashSet<Block> validOuterBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public HashSet<Block> validInnerBlocks() {
        return this.validInnerBlocks;
    }

    protected Level getLevel() {
        if (this.level instanceof ServerLevel) {
            return this.level;
        }
        if (this.controller() == null || this.controller().controllerBE() == null) {
            return null;
        }
        return this.controller().controllerBE().m_58904_();
    }

    protected void addIfNotExists(BlockPos pos, HashSet<Long> list) {
        list.add(pos.m_121878_());
    }

    protected void addIfNotExists(long pos, HashSet<Long> list) {
        list.add(pos);
    }

    protected BlockPosInstance initialPos() {
        if (this.controllerPos == null) {
            this.controllerPos = BlockPosInstance.copy(this.controller().controllerBE().m_58899_());
        }
        if (this.initialPos == null) {
            this.initialPos = BlockPosInstance.copy(this.controllerPos);
        }
        return this.initialPos.revert();
    }

    public BlockPos getBottomLeftBlock() {
        if (this.controllerPos != null) {
            this.controllerPos.revert();
        }
        return new BlockPos((Vec3i)this.getLeftPos(this.leftCasing).m_6625_(this.bottomCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
    }

    public BlockPos getTopRightBlock() {
        if (this.controllerPos != null) {
            this.controllerPos.revert();
        }
        return new BlockPos((Vec3i)this.getRightPos(this.rightCasing).m_6630_(this.topCasing));
    }

    public BlockPos getCenterBlock() {
        BlockPos bottomLeft = this.getBottomLeftBlock();
        BlockPos topRight = this.getTopRightBlock();
        return new BlockPos((bottomLeft.m_123341_() + topRight.m_123341_()) / 2, (bottomLeft.m_123342_() + topRight.m_123342_()) / 2, (bottomLeft.m_123343_() + topRight.m_123343_()) / 2);
    }

    public BlockState getBlockState(long pos) {
        BlockState cached = this.bsCache.get(pos);
        if (cached != null) {
            return cached;
        }
        BlockState state = this.getLevel().m_8055_(BlockPos.m_122022_((long)pos));
        this.bsCache.put(pos, state);
        return state;
    }

    protected BlockState getBlockState(BlockPosInstance relative, boolean force) {
        BlockState bs = this.getBlockState(relative);
        if (bs.m_60795_() && force) {
            bs = this.getLevel().m_8055_((BlockPos)relative);
        }
        return bs;
    }

    public BlockState getCachedBlockState(BlockPos pos) {
        if (this.bsCache.containsKey(pos.m_121878_())) {
            return this.bsCache.get(pos.m_121878_());
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        long packedPos = pos.m_121878_();
        if (this.bsCache.containsKey(packedPos)) {
            return this.bsCache.get(packedPos);
        }
        BlockState state = this.getLevel().m_8055_(pos);
        this.bsCache.put(packedPos, state);
        return state;
    }

    public boolean isValidForOuter(BlockPos pos) {
        if (this.getLevel() == null) {
            NuclearCraft.debugLog("Level is null when checking outer block at " + pos.m_123344_());
            return false;
        }
        try {
            Block block = this.getBlockState(pos).m_60734_();
            return this.validOuterBlocks().contains(block);
        }
        catch (NullPointerException e) {
            NuclearCraft.debugLog("NullPointerException when checking outer block at " + pos.m_123344_() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean isValidCorner(BlockPos pos) {
        try {
            return this.validCornerBlocks().contains(this.getBlockState(pos).m_60734_());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isValidForInner(BlockState bs) {
        return bs.m_60795_() || this.validInnerBlocks().contains(bs.m_60734_());
    }

    public boolean isValidForInner(BlockPos pos) {
        if (this.getLevel() == null) {
            NuclearCraft.debugLog("Level is null when checking inner block at " + pos.m_123344_());
            return false;
        }
        return this.isValidForInner(this.getBlockState(pos));
    }

    public void cacheBlockStates(AABB excludeArea) {
        if (!((Boolean)CommonConfig.MISC_CONFIG.EXPERIMENTAL_BLOCK_INDEXING.get()).booleanValue()) {
            NuclearCraft.debugLog("Block indexing disabled, skipping cache");
            return;
        }
        long startTime = System.currentTimeMillis();
        int minX = this.bottomLeft.m_123341_();
        int minY = this.bottomLeft.m_123342_();
        int minZ = this.bottomLeft.m_123343_();
        int maxX = this.topRight.m_123341_();
        int maxY = this.topRight.m_123342_();
        int maxZ = this.topRight.m_123343_();
        NuclearCraft.debugLog("Caching block states for area: " + minX + "," + minY + "," + minZ + " to " + maxX + "," + maxY + "," + maxZ);
        ServerLevel serverLevel = (ServerLevel)this.getLevel();
        LevelChunk currentChunk = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int cachedBlocks = 0;
        int chunksProcessed = 0;
        for (int x = minX; x <= maxX; ++x) {
            int chunkX = x >> 4;
            for (int z = minZ; z <= maxZ; ++z) {
                int chunkZ = z >> 4;
                if (chunkX != lastChunkX || chunkZ != lastChunkZ) {
                    currentChunk = serverLevel.m_7726_().m_62227_(chunkX, chunkZ, true);
                    lastChunkX = chunkX;
                    lastChunkZ = chunkZ;
                    ++chunksProcessed;
                }
                if (currentChunk == null) continue;
                for (int y = minY; y <= maxY; ++y) {
                    int sectionIndex = serverLevel.m_151564_(y);
                    LevelChunkSection section = currentChunk.m_7103_()[sectionIndex];
                    if (section == null || section.m_188008_()) continue;
                    int localX = x & 0xF;
                    int localY = y & 0xF;
                    int localZ = z & 0xF;
                    if (excludeArea != null && excludeArea.m_82390_(new Vec3((double)x, (double)y, (double)z))) continue;
                    BlockState state = section.m_62982_(localX, localY, localZ);
                    this.bsCache.put(BlockPos.m_121882_((int)x, (int)y, (int)z), state);
                    ++cachedBlocks;
                }
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        NuclearCraft.debugLog("Cached " + cachedBlocks + " block states from " + chunksProcessed + " chunks in " + elapsedTime + "ms");
    }

    public int resolveHeight() {
        int i;
        NuclearCraft.debugLog("Resolving height from position " + this.initialPos().m_123344_());
        for (i = 1; i <= this.maxHeight() + 2; ++i) {
            if (this.isValidForOuter(this.initialPos().m_6630_(i))) continue;
            this.topCasing = i - 1;
            this.height = i;
            NuclearCraft.debugLog("Found top boundary at offset " + i + ", topCasing=" + this.topCasing);
            break;
        }
        for (i = 1; i <= this.maxHeight() + 2; ++i) {
            if (this.isValidForOuter(this.initialPos().m_6625_(i))) continue;
            this.bottomCasing = i - 1;
            this.height += i - 1;
            NuclearCraft.debugLog("Found bottom boundary at offset " + i + ", bottomCasing=" + this.bottomCasing);
            break;
        }
        NuclearCraft.debugLog("Resolved height: " + this.height + " (top=" + this.topCasing + ", bottom=" + this.bottomCasing + ")");
        return this.height;
    }

    public int resolveWidth() {
        int i;
        NuclearCraft.debugLog("Resolving width from position " + this.initialPos().m_123344_());
        for (i = 1; i <= this.maxWidth() + 2; ++i) {
            if (this.isValidForOuter(this.getLeftPos(i).m_6630_(this.topCasing))) continue;
            this.leftCasing = i - 1;
            this.width = i;
            NuclearCraft.debugLog("Found left boundary at offset " + i + ", leftCasing=" + this.leftCasing);
            break;
        }
        for (i = 1; i <= this.maxWidth() + 2; ++i) {
            if (this.isValidForOuter(this.getRightPos(i).m_6630_(this.topCasing))) continue;
            this.rightCasing = i - 1;
            this.width += i - 1;
            NuclearCraft.debugLog("Found right boundary at offset " + i + ", rightCasing=" + this.rightCasing);
            break;
        }
        NuclearCraft.debugLog("Resolved width: " + this.width + " (left=" + this.leftCasing + ", right=" + this.rightCasing + ")");
        return this.width;
    }

    public int resolveDepth() {
        NuclearCraft.debugLog("Resolving depth from position " + this.initialPos().m_123344_());
        for (int i = 1; i <= this.maxDepth() + 2; ++i) {
            if (this.isValidForOuter(this.getForwardPos(i).m_6625_(this.bottomCasing))) continue;
            this.depth = i;
            NuclearCraft.debugLog("Found depth boundary at offset " + i);
            break;
        }
        NuclearCraft.debugLog("Resolved depth: " + this.depth);
        return this.depth;
    }

    protected Block getBlock(BlockPos pos) {
        if (this.getLevel() == null) {
            return Blocks.f_50016_;
        }
        return this.getBlockState(pos).m_60734_();
    }

    protected MultiblockControllerBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return this.controllerBe;
    }

    public void resolveDimensions() {
        if (this.getMultiblockDirection() == null) {
            return;
        }
        this.resolveHeight();
        this.resolveDepth();
        this.resolveWidth();
        this.topRight = this.getTopRightBlock();
        this.bottomLeft = this.getBottomLeftBlock();
        this.controllerBE().topRight = new BlockPos((Vec3i)this.topRight);
        this.controllerBE().bottomLeft = new BlockPos((Vec3i)this.bottomLeft);
    }

    public void updateAABB() {
        if (this.bottomLeft == null || this.topRight == null) {
            this.findCorners();
        }
        this.structureBounds = new AABB(this.bottomLeft, this.topRight);
    }

    @Override
    public void validateOuter() {
        this.outerValid = false;
        NuclearCraft.debugLog("Starting outer validation for multiblock at " + this.controllerPos.m_123344_() + " (Type: " + this.getClass().getSimpleName() + ")");
        this.resolveDimensions();
        NuclearCraft.debugLog("Resolved dimensions: " + this.width + "x" + this.height + "x" + this.depth + " (WxHxD)");
        if (this.width > this.maxWidth() || this.height > this.maxHeight() || this.depth > this.maxDepth()) {
            this.validationResult = ValidationResult.TOO_BIG;
            NuclearCraft.debugLog("Validation failed - TOO_BIG: " + this.width + "x" + this.height + "x" + this.depth + " exceeds max " + this.maxWidth() + "x" + this.maxHeight() + "x" + this.maxDepth());
            return;
        }
        if (this.width < this.minWidth() || this.height < this.minHeight() || this.depth < this.minDepth()) {
            this.validationResult = ValidationResult.TOO_SMALL;
            NuclearCraft.debugLog("Validation failed - TOO_SMALL: " + this.width + "x" + this.height + "x" + this.depth + " below min " + this.minWidth() + "x" + this.minHeight() + "x" + this.minDepth());
            return;
        }
        this.findCorners();
        this.cacheBlockStates(null);
        NuclearCraft.debugLog("Cached block states for validation area");
        int totalOuterBlocks = 0;
        int validOuterBlocks = 0;
        int cornerBlocks = 0;
        int validCornerBlocks = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    if (y != 0 && x != 0 && z != 0 && y != this.height - 1 && x != this.width - 1 && z != this.depth - 1) continue;
                    BlockPos currentPos = this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                    ++totalOuterBlocks;
                    if (!((y != 0 && y != this.height - 1 || z != 0 && z != this.depth - 1) && (y != 0 && y != this.height - 1 || x != 0 && x != this.width - 1) && (z != 0 && z != this.depth - 1 || x != 0 && x != this.width - 1))) {
                        ++cornerBlocks;
                        if (!this.isValidCorner(currentPos)) {
                            this.validationResult = ValidationResult.WRONG_CORNER;
                            this.errorBlockPos = new BlockPos((Vec3i)currentPos);
                            NuclearCraft.debugLog("Validation failed - WRONG_CORNER at " + currentPos.m_123344_() + " - Expected corner block, found: " + this.getBlockState(currentPos).m_60734_().m_7705_());
                            return;
                        }
                        ++validCornerBlocks;
                    } else {
                        if (!this.isValidForOuter(currentPos)) {
                            this.validationResult = ValidationResult.WRONG_OUTER;
                            this.errorBlockPos = new BlockPos((Vec3i)currentPos);
                            NuclearCraft.debugLog("Validation failed - WRONG_OUTER at " + currentPos.m_123344_() + " - Expected outer block, found: " + this.getBlockState(currentPos).m_60734_().m_7705_());
                            return;
                        }
                        ++validOuterBlocks;
                    }
                    this.processOuterBlock(currentPos);
                }
            }
        }
        NuclearCraft.debugLog("Outer block validation complete - Total: " + totalOuterBlocks + ", Valid outer: " + validOuterBlocks + ", Corner blocks: " + cornerBlocks + ", Valid corners: " + validCornerBlocks);
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            NuclearCraft.debugLog("Validation failed - TOO_MANY_CONTROLLERS: Found " + this.controllers.size() + " controllers");
            return;
        }
        NuclearCraft.debugLog("Found " + this.connectedPorts + " connected ports");
        this.outerValid = true;
        this.validationResult = ValidationResult.VALID;
        NuclearCraft.debugLog("Outer validation completed successfully");
        this.updateAABB();
    }

    private void findCorners() {
        BlockPosInstance leftFront = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing));
        BlockPosInstance leftBack = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        BlockPosInstance rightFront = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing));
        BlockPosInstance rightBack = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        int minX = MathUtils.min(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int minZ = MathUtils.min(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        int maxX = MathUtils.max(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int maxZ = MathUtils.max(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        this.bottomLeft = new BlockPosInstance(minX, leftFront.m_123342_() - this.bottomCasing, minZ);
        this.topRight = new BlockPosInstance(maxX, leftFront.m_123342_() + this.topCasing, maxZ);
        NuclearCraft.debugLog("Calculated bounds: bottomLeft=" + this.bottomLeft.m_123344_() + ", topRight=" + this.topRight.m_123344_());
    }

    protected void processOuterBlock(BlockPos pos) {
        this.attachMultiblock(pos);
        this.addIfNotExists(pos, this.allBlocks);
        if (CONTROLLERS.matcher(this.getBlockState(pos).m_60734_().m_5456_().toString()).matches()) {
            this.controllers.add(pos);
        }
        if (this.isPort(this.getBlockState(pos))) {
            BlockEntity blockEntity = this.getBlockEntity(pos, true);
            if (blockEntity instanceof MultiblockAttachable) {
                MultiblockAttachable attachableBe = (MultiblockAttachable)blockEntity;
                attachableBe.setMultiblock(this);
            }
            ++this.connectedPorts;
        }
    }

    @Override
    public void validateInner() {
        this.validateInner(false);
    }

    public void validateInner(boolean force) {
        this.innerValid = false;
        NuclearCraft.debugLog("Starting inner validation for multiblock at " + this.controllerPos.m_123344_());
        int totalInnerBlocks = 0;
        int validInnerBlocks = 0;
        int airBlocks = 0;
        for (int y = 1; y < this.resolveHeight() - 1; ++y) {
            for (int x = 1; x < this.resolveWidth() - 1; ++x) {
                for (int z = 1; z < this.resolveDepth() - 1; ++z) {
                    BlockPosInstance toCheck = new BlockPosInstance((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                    ++totalInnerBlocks;
                    if (!this.isValidForInner(toCheck)) {
                        this.validationResult = ValidationResult.WRONG_INNER;
                        this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                        NuclearCraft.debugLog("Validation failed - WRONG_INNER at " + toCheck.m_123344_() + " - Invalid inner block: " + this.getBlockState(toCheck).m_60734_().m_7705_());
                        return;
                    }
                    if (this.getBlockState(toCheck).m_60795_()) {
                        ++airBlocks;
                    } else {
                        ++validInnerBlocks;
                    }
                    this.processInnerBlock(toCheck.copy());
                }
            }
        }
        NuclearCraft.debugLog("Inner validation complete - Total: " + totalInnerBlocks + ", Valid inner blocks: " + validInnerBlocks + ", Air blocks: " + airBlocks);
        this.innerValid = true;
        this.validationResult = ValidationResult.VALID;
        NuclearCraft.debugLog("Inner validation completed successfully");
    }

    protected boolean processInnerBlock(BlockPos toCheck) {
        this.addIfNotExists(toCheck, this.allBlocks);
        this.attachMultiblock(toCheck);
        return true;
    }

    protected void attachMultiblock(BlockPos pos) {
        this.attachMultiblock(this.getBlockEntity(pos, new boolean[0]));
    }

    protected BlockEntity getBlockEntity(BlockPos pos, boolean ... forceFlag) {
        boolean force;
        boolean bl = force = forceFlag.length > 0 && forceFlag[0];
        if (this.beCache.containsKey(pos.m_121878_())) {
            if (force) {
                this.beCache.put(pos.m_121878_(), this.getLevel().getExistingBlockEntity(pos));
            }
            return this.beCache.get(pos.m_121878_());
        }
        BlockEntity be = this.getLevel().getExistingBlockEntity(pos);
        if (!this.getBlockState(pos).m_60795_()) {
            this.beCache.put(pos.m_121878_(), be);
        }
        return be;
    }

    protected void attachMultiblock(BlockEntity be) {
        if (be instanceof MultiblockAttachable) {
            MultiblockAttachable part = (MultiblockAttachable)be;
            part.setMultiblock(this);
        }
    }

    public boolean isLoaded(BlockPos pos) {
        return this.getLevel().m_46749_(pos);
    }

    public void onControllerRemoved() {
        for (long packedPos : this.allBlocks) {
            BlockEntity be;
            if (!this.isLoaded(BlockPos.m_122022_((long)packedPos)) || !((be = this.getBlockEntity(packedPos)) instanceof MultiblockAttachable)) continue;
            MultiblockAttachable multiblockAttachable = (MultiblockAttachable)be;
            multiblockAttachable.setMultiblock(null);
        }
        this.dispose();
    }

    private BlockEntity getBlockEntity(long packedPos) {
        if (this.beCache.containsKey(packedPos)) {
            return this.beCache.get(packedPos);
        }
        BlockEntity be = this.getLevel().m_7702_(BlockPos.m_122022_((long)packedPos));
        this.beCache.put(packedPos, be);
        return be;
    }

    public BlockPos getForwardPos(int i) {
        return this.initialPos().relative(this.getControllerDirection(), -i);
    }

    public BlockPos getLeftPos(int i) {
        return this.getSidePos(-i);
    }

    public BlockPos getRightPos(int i) {
        return this.getSidePos(i);
    }

    public BlockPos getSidePos(int i) {
        return switch (this.getMultiblockDirection().ordinal()) {
            case 3 -> this.initialPos().m_122030_(i);
            case 5 -> this.initialPos().m_122013_(i);
            case 2 -> this.initialPos().m_122025_(i);
            case 4 -> this.initialPos().m_122020_(i);
            default -> null;
        };
    }

    protected abstract Direction getControllerDirection();

    protected Direction getMultiblockDirection() {
        if (this.multiblockDirection == null) {
            this.multiblockDirection = this.getControllerDirection();
        }
        return this.multiblockDirection;
    }

    @Override
    public void validate() {
        long elapsedTime;
        this.isValidating = true;
        this.connectedPorts = 0;
        long startTime = System.currentTimeMillis();
        NuclearCraft.debugLog("=== Starting full validation for " + this.getClass().getSimpleName() + " at " + this.initialPos().m_123344_() + " ===");
        this.topRight = null;
        this.bottomLeft = null;
        this.validationResult = ValidationResult.INCOMPLETE;
        this.controllers.clear();
        this.bsCache.clear();
        this.beCache.clear();
        this.allBlocks.clear();
        NuclearCraft.debugLog("Cleared validation caches and reset state");
        this.validateOuter();
        if (this.isOuterValid()) {
            NuclearCraft.debugLog("Outer validation passed, proceeding to inner validation");
            this.validateInner();
        } else {
            NuclearCraft.debugLog("Outer validation failed with result: " + this.validationResult + (String)(this.errorBlockPos != null ? " at " + this.errorBlockPos.m_123344_() : ""));
            this.innerValid = false;
            this.clearStats();
        }
        this.innerValid = this.validationResult.isValid;
        boolean bl = this.isFormed = this.outerValid && this.innerValid;
        if (this.isFormed) {
            this.validationResult = ValidationResult.VALID;
            NuclearCraft.debugLog("Multiblock formation successful!");
        } else {
            this.controller.clearStats();
            NuclearCraft.debugLog("Multiblock formation failed - Outer valid: " + this.outerValid + ", Inner valid: " + this.innerValid);
        }
        this.controllerBE().validationTime = elapsedTime = System.currentTimeMillis() - startTime;
        ++this.controllerBE().validationsCounter;
        NuclearCraft.debugLog("=== Validation completed for " + this.getClass().getSimpleName() + " at " + this.initialPos().m_123344_() + " in " + elapsedTime + "ms - Result: " + this.validationResult + " ===");
        this.isValidating = false;
    }

    @Override
    public boolean isInnerValid() {
        return this.innerValid;
    }

    @Override
    public boolean isOuterValid() {
        return this.outerValid;
    }

    @Override
    public MultiblockController controller() {
        return this.controller;
    }

    public void onNeighborChange(BlockState state, BlockPos pos, BlockPos neighbor) {
        if (this.shouldRefreshCache(state, pos, neighbor)) {
            this.hasToRefresh = true;
        }
    }

    private boolean shouldRefreshCache(BlockState state, BlockPos pos, BlockPos neighbor) {
        if (this.bottomLeft != null && this.topRight != null && (neighbor.m_123341_() < this.bottomLeft.m_123341_() || neighbor.m_123342_() < this.bottomLeft.m_123342_() || neighbor.m_123343_() < this.bottomLeft.m_123343_() || neighbor.m_123341_() > this.topRight.m_123341_() || neighbor.m_123342_() > this.topRight.m_123342_() || neighbor.m_123343_() > this.topRight.m_123343_())) {
            return false;
        }
        if (!this.allBlocks.contains(neighbor.m_121878_())) {
            return false;
        }
        BlockEntity neighborBe = this.getBlockEntity(neighbor, new boolean[0]);
        if (neighborBe instanceof MultiblockAttachable) {
            MultiblockAttachable part = (MultiblockAttachable)neighborBe;
            return part.canInvalidateCache();
        }
        return true;
    }

    public void tick(Level level) {
        if (this.controllerBE() != null) {
            ++this.controllerBE().multiblockTicksCounter;
        }
        if (!this.canTick || !this.hasToRefresh) {
            return;
        }
        this.level = level;
        this.canTick = false;
        NuclearCraft.debugLog("Tick triggered validation for " + this.getClass().getSimpleName() + " at " + this.controllerPos.m_123344_());
        this.validationResult = ValidationResult.INCOMPLETE;
        this.innerValid = false;
        this.outerValid = false;
        this.isFormed = false;
        this.hasToRefresh = false;
        this.validate();
        this.canTick = true;
    }

    public void removeFromCacheIfChanged(BlockPos pos) {
        BlockEntity be;
        if (this.beCache.containsKey(pos.m_121878_()) && (be = this.getLevel().m_7702_(pos)) != this.beCache.get(pos.m_121878_())) {
            this.beCache.remove(pos.m_121878_());
            this.hasToRefresh = true;
        }
        if (this.bsCache.containsKey(pos.m_121878_())) {
            BlockState bs = this.getLevel().m_8055_(pos);
            BlockState cachedBs = this.bsCache.get(pos.m_121878_());
            if (cachedBs == null || !bs.m_60713_(cachedBs.m_60734_())) {
                this.bsCache.remove(pos.m_121878_());
                this.hasToRefresh = true;
            }
        }
    }

    public void onBlockDestroyed(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        this.removeFromCacheIfChanged(pos);
        this.controller.clearStats();
    }

    public boolean onBlockChange(BlockPos pos) {
        this.removeFromCacheIfChanged(pos);
        if (this.hasToRefresh) {
            return true;
        }
        if (this.containsPos(pos)) {
            BlockState cachedState = this.getCachedBlockState(pos);
            BlockState actualState = this.getBlockState(pos);
            if (cachedState == null) {
                NuclearCraft.debugLog("Block change detected inside multiblock at " + pos.m_123344_() + " - no cached state, triggering refresh");
                this.hasToRefresh = true;
                return true;
            }
            if (SPECIAL_BLOCKS.matcher(cachedState.m_60734_().m_7705_()).matches() && actualState.m_60713_(cachedState.m_60734_())) {
                return true;
            }
            NuclearCraft.debugLog("Block change detected inside multiblock at " + pos.m_123344_() + " - changed from " + cachedState.m_60734_().m_7705_() + " to " + actualState.m_60734_().m_7705_() + ", triggering refresh");
            this.hasToRefresh = true;
            return true;
        }
        this.resolveDimensions();
        if (this.bottomLeft == null || this.topRight == null) {
            return false;
        }
        if (pos.m_123341_() >= this.bottomLeft.m_123341_() && pos.m_123342_() >= this.bottomLeft.m_123342_() && pos.m_123343_() >= this.bottomLeft.m_123343_() && pos.m_123341_() <= this.topRight.m_123341_() && pos.m_123342_() <= this.topRight.m_123342_() && pos.m_123343_() <= this.topRight.m_123343_()) {
            BlockState cachedState = this.getCachedBlockState(pos);
            BlockState actualState = this.getBlockState(pos);
            if (cachedState == null) {
                NuclearCraft.debugLog("Block change detected in multiblock bounds at " + pos.m_123344_() + " - no cached state, triggering refresh");
                this.hasToRefresh = true;
                return true;
            }
            if (SPECIAL_BLOCKS.matcher(cachedState.m_60734_().m_7705_()).matches() && actualState.m_60713_(cachedState.m_60734_())) {
                return true;
            }
            NuclearCraft.debugLog("Block change detected in multiblock bounds at " + pos.m_123344_() + " - changed from " + cachedState.m_60734_().m_7705_() + " to " + actualState.m_60734_().m_7705_() + ", triggering refresh");
            this.hasToRefresh = true;
            return true;
        }
        if (!this.isFormed) {
            NuclearCraft.debugLog("Block change detected near unformed multiblock at " + pos.m_123344_() + ", triggering refresh");
            this.hasToRefresh = true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        return false;
    }

    @Override
    public boolean isLoaded() {
        if (this.controllerPos == null) {
            return false;
        }
        if (this.getLevel() == null) {
            return false;
        }
        return this.getLevel().m_7726_().m_5563_(this.controllerPos.m_123341_() >> 4, this.controllerPos.m_123343_() >> 4);
    }

    public ChunkPos getChunk() {
        return new ChunkPos(this.controllerPos.m_123341_() >> 4, this.controllerPos.m_123343_() >> 4);
    }

    public boolean containsPos(BlockPos pos) {
        return this.allBlocks.contains(pos.m_121878_()) || this.inAABB(pos);
    }

    private boolean inAABB(BlockPos pos) {
        if (this.structureBounds == null) {
            return false;
        }
        return this.structureBounds.m_82390_(pos.m_252807_());
    }

    public boolean isValidForTicking() {
        return this.controller() != null && this.controller().controllerBE() != null;
    }

    public void wipeCache() {
        this.hasToRefresh = true;
        this.beCache.clear();
        this.bsCache.clear();
        this.allBlocks.clear();
        this.controllers.clear();
        this.bottomLeft = null;
        this.topRight = null;
        this.errorBlockPos = BlockPos.f_121853_;
        this.validationResult = ValidationResult.INCOMPLETE;
        this.isFormed = false;
        this.innerValid = false;
        this.outerValid = false;
        this.height = 0;
        this.width = 0;
        this.depth = 0;
    }

    public boolean isValidating() {
        return this.isValidating;
    }
}

