/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationScheduler {
    private final Map<String, List<String>> adjList = new HashMap<String, List<String>>();
    private final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private final Map<String, Integer> lowlinkMap = new HashMap<String, Integer>();
    private final Deque<String> stack = new ArrayDeque<String>();
    private final Set<String> onStack = new HashSet<String>();
    private final List<List<String>> sccs = new ArrayList<List<String>>();
    private int index = 0;

    public void graphAddEdge(String from, String to) {
        this.adjList.computeIfAbsent(from, k -> new ArrayList()).add(to);
        this.adjList.putIfAbsent(to, new ArrayList());
    }

    private boolean isCyclic(List<String> scc) {
        if (scc.size() > 1) {
            return true;
        }
        String node = scc.get(0);
        return this.adjList.get(node).contains(node);
    }

    private void strongConnect(String node) {
        this.indexMap.put(node, this.index);
        this.lowlinkMap.put(node, this.index++);
        this.stack.push(node);
        this.onStack.add(node);
        for (String neighbor : this.adjList.get(node)) {
            if (!this.indexMap.containsKey(neighbor)) {
                this.strongConnect(neighbor);
                this.lowlinkMap.put(node, Math.min(this.lowlinkMap.get(node), this.lowlinkMap.get(neighbor)));
                continue;
            }
            if (!this.onStack.contains(neighbor)) continue;
            this.lowlinkMap.put(node, Math.min(this.lowlinkMap.get(node), this.indexMap.get(neighbor)));
        }
        if (this.lowlinkMap.get(node).equals(this.indexMap.get(node))) {
            String w;
            ArrayList<String> scc = new ArrayList<String>();
            do {
                w = this.stack.pop();
                this.onStack.remove(w);
                scc.add(w);
            } while (!w.equals(node));
            this.sccs.add(scc);
        }
    }

    public List<String> getSchedule() {
        for (String node : this.adjList.keySet()) {
            if (this.indexMap.containsKey(node)) continue;
            this.strongConnect(node);
        }
        HashMap<String, Integer> nodeToSCC = new HashMap<String, Integer>();
        for (int i = 0; i < this.sccs.size(); ++i) {
            for (String node : this.sccs.get(i)) {
                nodeToSCC.put(node, i);
            }
        }
        HashMap sccGraph = new HashMap();
        for (String node : this.adjList.keySet()) {
            int fromSCC = (Integer)nodeToSCC.get(node);
            for (String dep : this.adjList.get(node)) {
                int toSCC = (Integer)nodeToSCC.get(dep);
                if (fromSCC == toSCC) continue;
                sccGraph.computeIfAbsent(toSCC, k -> new HashSet()).add(fromSCC);
            }
        }
        HashMap<Integer, Integer> inDegree = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.sccs.size(); ++i) {
            inDegree.putIfAbsent(i, 0);
        }
        for (Set deps : sccGraph.values()) {
            Iterator<String> iterator = deps.iterator();
            while (iterator.hasNext()) {
                int dep = (Integer)((Object)iterator.next());
                inDegree.put(dep, (Integer)inDegree.get(dep) + 1);
            }
        }
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        for (int i = 0; i < this.sccs.size(); ++i) {
            if ((Integer)inDegree.get(i) != 0) continue;
            queue.add(i);
        }
        ArrayList<Integer> topoOrder = new ArrayList<Integer>();
        while (!queue.isEmpty()) {
            int curr = (Integer)queue.poll();
            topoOrder.add(curr);
            Iterator iterator = sccGraph.getOrDefault(curr, Set.of()).iterator();
            while (iterator.hasNext()) {
                int neighbor = (Integer)iterator.next();
                inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                if ((Integer)inDegree.get(neighbor) != 0) continue;
                queue.add(neighbor);
            }
        }
        ArrayList<String> finalSchedule = new ArrayList<String>();
        Iterator iterator = topoOrder.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            List<String> scc = this.sccs.get(idx);
            if (this.isCyclic(scc)) {
                finalSchedule.addAll(scc);
                finalSchedule.addAll(scc);
                continue;
            }
            finalSchedule.addAll(scc);
        }
        return finalSchedule;
    }
}

