/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import com.google.gson.JsonArray;
import igentuman.nc.block.fission.FissionCasingBlock;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.block.fission.FissionFuelCellBlock;
import igentuman.nc.block.fission.FissionPortBlock;
import igentuman.nc.block.fission.HeatSinkBlock;
import igentuman.nc.block.fission.IrradiationChamberBlock;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.block.fission.entity.FissionPortBE;
import igentuman.nc.container.FissionControllerContainer;
import igentuman.nc.container.FissionPortContainer;
import igentuman.nc.multiblock.ValidationScheduler;
import igentuman.nc.multiblock.fission.HeatSinkDef;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import igentuman.nc.util.JSONUtil;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class FissionReactorRegistration {
    public static final Pattern TRANSPARENT_BLOCKS = Pattern.compile(".*glass|.*cell.*|photon.*|.*stabilizer.*");
    public static final Item.Properties FISSION_ITEM_PROPS = new Item.Properties();
    public static final HashMap<String, RegistryObject<Block>> FISSION_BLOCKS = new HashMap();
    public static final HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> FISSION_BE = new HashMap();
    public static final HashMap<String, RegistryObject<Item>> FISSION_BLOCK_ITEMS = new HashMap();
    private static final List<RegistryObject<Block>> hsBlocks = new ArrayList<RegistryObject<Block>>();
    public static final List<String> hsSchedule = new ArrayList<String>();
    public static final RegistryObject<MenuType<FissionControllerContainer>> FISSION_CONTROLLER_CONTAINER = Registries.CONTAINERS.register("fission_reactor_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new FissionControllerContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<FissionPortContainer>> FISSION_PORT_CONTAINER = Registries.CONTAINERS.register("fission_reactor_port", () -> IForgeMenuType.create((windowId, inv, data) -> new FissionPortContainer(windowId, data.m_130135_(), inv)));
    public static final BlockBehaviour.Properties REACTOR_BLOCKS_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_();
    public static final TagKey<Block> MODERATORS_BLOCKS = Tags.blockTag("moderators");
    public static final TagKey<Block> HEAT_SINK_BLOCKS = Tags.blockTag("heat_sinks");
    public static final TagKey<Block> INNER_REACTOR_BLOCKS = Tags.blockTag("reactor_inner");
    public static final TagKey<Item> MODERATORS_ITEMS = Tags.itemTag("moderators");
    public static final TagKey<Block> CASING_BLOCKS = Tags.blockTag("fission_reactor_casing");
    public static final TagKey<Item> CASING_ITEMS = Tags.itemTag("fission_reactor_casing");
    public static final List<String> reactor = Arrays.asList("casing", "controller", "irradiation_chamber", "port", "glass", "solid_fuel_cell");
    public static final HashSet<Block> blocks = FissionReactorRegistration.moderators();
    public static final HashMap<String, HeatSinkDef> heatsinks = FissionReactorRegistration.heatsinks();

    public static void init() {
        FissionReactorRegistration.blocks();
    }

    public static void blocks() {
        for (String name : reactor) {
            String key = "fission_reactor_" + name;
            if (name.contains("controller")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new FissionControllerBlock(REACTOR_BLOCKS_PROPERTIES)));
                FISSION_BE.put(key, (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(FissionControllerBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get(key).get()}).m_58966_(null)));
            } else if (name.contains("port")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new FissionPortBlock(REACTOR_BLOCKS_PROPERTIES)));
                FISSION_BE.put(key, (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(FissionPortBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get(key).get()}).m_58966_(null)));
            } else if (name.contains("irradiation")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new IrradiationChamberBlock(REACTOR_BLOCKS_PROPERTIES)));
            } else {
                BlockBehaviour.Properties props = TRANSPARENT_BLOCKS.matcher(key).matches() ? BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_() : REACTOR_BLOCKS_PROPERTIES;
                if (key.matches(".*glass|.*casing.*")) {
                    if (key.contains("glass")) {
                        FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new FissionCasingBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_())));
                    } else {
                        FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new FissionCasingBlock(props)));
                    }
                }
                if (key.matches(".*cell")) {
                    FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new FissionFuelCellBlock(props)));
                }
            }
            FISSION_BLOCK_ITEMS.put(key, FissionReactorRegistration.fromMultiblock(FISSION_BLOCKS.get(key)));
            NCItems.ALL_NC_ITEMS.put(key, FISSION_BLOCK_ITEMS.get(key));
        }
        for (String name : heatsinks.keySet()) {
            FISSION_BLOCKS.put(name + "_heat_sink", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_heat_sink", () -> new HeatSinkBlock(REACTOR_BLOCKS_PROPERTIES, heatsinks.get(name))));
            FISSION_BLOCK_ITEMS.put(name + "_heat_sink", FissionReactorRegistration.fromMultiblock(FISSION_BLOCKS.get(name + "_heat_sink")));
            NCItems.ALL_NC_ITEMS.put(name + "_heat_sink", FISSION_BLOCK_ITEMS.get(name + "_heat_sink"));
            if (name.matches("empty|active")) continue;
            hsBlocks.add(FISSION_BLOCKS.get(name + "_heat_sink"));
        }
    }

    public static HashSet<Block> moderators() {
        return TagUtil.getBlocksByTagKey(MODERATORS_BLOCKS.f_203868_().toString());
    }

    public static HashMap<String, HeatSinkDef> heatsinks() {
        HashMap<String, HeatSinkDef> tmp = new HashMap<String, HeatSinkDef>();
        ValidationScheduler scheduler = new ValidationScheduler();
        List<JsonArray> data = JSONUtil.loadAllJsonFromConfig("heat_sinks");
        Pattern activeCheck = Pattern.compile("^(?!.*active_).+_heat_sink$");
        if (data == null) {
            return tmp;
        }
        for (JsonArray array : data) {
            for (int i = 0; i < array.size(); ++i) {
                HeatSinkDef heatSink = HeatSinkDef.of(array.get(i).getAsJsonObject());
                if (heatSink == null) continue;
                tmp.put(heatSink.name, heatSink);
                Object name = heatSink.name;
                if (!((String)name).contains(":")) {
                    name = "nuclearcraft:" + (String)name;
                }
                for (String rule : heatSink.rules) {
                    String[] conditionParts = rule.split("=|-|>|<|\\^");
                    for (String block : conditionParts[0].split("\\|")) {
                        Object blockName = block;
                        if (!block.contains(":")) {
                            blockName = "nuclearcraft:" + block;
                        }
                        scheduler.graphAddEdge((String)name + "_heat_sink", (String)blockName);
                        if (!activeCheck.matcher(block).matches()) continue;
                        if (block.contains(":")) {
                            String[] blockParts = block.split(":");
                            blockName = blockParts[0] + ":active_" + blockParts[1];
                        } else {
                            blockName = "nuclearcraft:active_" + block;
                        }
                        scheduler.graphAddEdge((String)name + "_heat_sink", (String)blockName);
                    }
                }
            }
        }
        hsSchedule.addAll(scheduler.getSchedule());
        return tmp;
    }

    public static Block[] getHSBlocks() {
        Block[] blocks = new Block[hsBlocks.size()];
        int i = 0;
        for (RegistryObject<Block> b : hsBlocks) {
            blocks[i] = (Block)b.get();
            ++i;
        }
        return blocks;
    }

    public static <B extends Block> RegistryObject<Item> fromMultiblock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), FISSION_ITEM_PROPS));
    }
}

