/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.network.toServer;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.network.INcPacket;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;

public class PacketRecipeTransfer
implements INcPacket {
    private BlockPos blockPos;
    private ResourceLocation recipeId;

    public PacketRecipeTransfer() {
    }

    public PacketRecipeTransfer(BlockPos blockPos, ResourceLocation recipeId) {
        this.blockPos = blockPos;
        this.recipeId = recipeId;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        double distance = player.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5);
        if (distance > 25.0) {
            return;
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.blockPos);
        if (!(blockEntity instanceof NCProcessorBE)) {
            return;
        }
        NCProcessorBE processorBE = (NCProcessorBE)blockEntity;
        if (!this.isPlayerLookingAtBlock(player, this.blockPos)) {
            return;
        }
        Recipe recipe = player.m_9236_().m_7465_().m_44043_(this.recipeId).orElse(null);
        if (!(recipe instanceof NcRecipe)) {
            return;
        }
        NcRecipe ncRecipe = (NcRecipe)recipe;
        this.transferRecipeItems(player, processorBE, ncRecipe);
    }

    private void transferRecipeItems(ServerPlayer player, NCProcessorBE processorBE, NcRecipe recipe) {
        processorBE.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(processorItemHandler -> {
            int inputSlotIndex = 0;
            int maxInputSlots = processorBE.prefab().getSlotsConfig().getInputItems();
            for (ItemStackIngredient inputIngredient : recipe.getInputItems()) {
                if (inputSlotIndex >= maxInputSlots) break;
                if (inputIngredient == null || inputIngredient.getRepresentations().isEmpty()) {
                    ++inputSlotIndex;
                    continue;
                }
                for (ItemStack requiredStack : inputIngredient.getRepresentations()) {
                    int spaceLeft;
                    int actualTransfer;
                    int playerSlotIndex = this.findItemSlotInPlayerInventory(player, requiredStack);
                    if (playerSlotIndex == -1) continue;
                    ItemStack playerStack = player.m_150109_().m_8020_(playerSlotIndex);
                    int transferAmount = Math.min(requiredStack.m_41613_(), playerStack.m_41613_());
                    ItemStack toTransfer = playerStack.m_41777_();
                    toTransfer.m_41764_(transferAmount);
                    ItemStack currentInSlot = processorItemHandler.getStackInSlot(inputSlotIndex);
                    if (currentInSlot.m_41619_()) {
                        ItemStack remainder = processorItemHandler.insertItem(inputSlotIndex, toTransfer, false);
                        int actualTransferred = transferAmount - remainder.m_41613_();
                        if (actualTransferred <= 0) continue;
                        playerStack.m_41774_(actualTransferred);
                        if (!playerStack.m_41619_()) break;
                        player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
                        break;
                    }
                    if (!ItemStack.m_150942_((ItemStack)currentInSlot, (ItemStack)toTransfer) || (actualTransfer = Math.min(transferAmount, spaceLeft = currentInSlot.m_41741_() - currentInSlot.m_41613_())) <= 0) continue;
                    ItemStack toInsert = toTransfer.m_41777_();
                    toInsert.m_41764_(actualTransfer);
                    ItemStack remainder = processorItemHandler.insertItem(inputSlotIndex, toInsert, false);
                    int actualTransferred = actualTransfer - remainder.m_41613_();
                    if (actualTransferred <= 0) continue;
                    playerStack.m_41774_(actualTransferred);
                    if (!playerStack.m_41619_()) break;
                    player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
                    break;
                }
                ++inputSlotIndex;
            }
            processorBE.m_6596_();
        });
    }

    private int findItemSlotInPlayerInventory(ServerPlayer player, ItemStack required) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)required) || stack.m_41613_() < required.m_41613_()) continue;
            return i;
        }
        return -1;
    }

    private boolean isPlayerLookingAtBlock(ServerPlayer player, BlockPos blockPos) {
        Vec3 lookVec = player.m_20154_();
        Vec3 playerEyePos = player.m_146892_();
        Vec3 blockCenter = blockPos.m_252807_();
        Vec3 toBlock = blockCenter.m_82546_(playerEyePos).m_82541_();
        double dotProduct = lookVec.m_82526_(toBlock);
        return dotProduct > 0.5;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        buffer.m_130085_(this.recipeId);
    }

    public static PacketRecipeTransfer decode(FriendlyByteBuf buffer) {
        PacketRecipeTransfer packet = new PacketRecipeTransfer();
        packet.blockPos = buffer.m_130135_();
        packet.recipeId = buffer.m_130281_();
        return packet;
    }
}

