/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.util.NcUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class NcIngredient
extends Ingredient {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger();
    public static final NcIngredient EMPTY = new NcIngredient(Stream.empty());
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    private int invalidationCounter;
    protected int count = 1;
    private String name;
    private final boolean isVanilla = ((Object)((Object)this)).getClass() == NcIngredient.class;

    public static void invalidateAll() {
        INVALIDATION_COUNTER.incrementAndGet();
    }

    protected NcIngredient(Stream<? extends Ingredient.Value> pValues) {
        super(Stream.empty());
        this.values = (Value[])pValues.toArray(Value[]::new);
    }

    public static NcIngredient of(String name) {
        if (name.contains("#")) {
            TagKey tag = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NcUtils.rlFromString(name.replace("#", "")));
            return NcIngredient.of((TagKey<Item>)tag);
        }
        return NcIngredient.of((ItemLike)ForgeRegistries.ITEMS.getValue(NcUtils.rlFromString(name)));
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.values[0].getName();
        }
        return this.name;
    }

    public static void ping() {
    }

    public ItemStack[] m_43908_() {
        this.dissolve();
        return this.itemStacks;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(p_43916_ -> p_43916_.m_6223_().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    public boolean test(@Nullable ItemStack pStack) {
        if (pStack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return pStack.m_41619_();
        }
        for (ItemStack itemstack : this.itemStacks) {
            if (!itemstack.m_150930_(pStack.m_41720_()) || this.count > pStack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public IntList m_43931_() {
        if (this.stackingIds == null || this.checkInvalidation()) {
            this.markValid();
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (ItemStack itemstack : this.itemStacks) {
                this.stackingIds.add(StackedContents.m_36496_((ItemStack)itemstack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public JsonElement m_43942_() {
        if (this.values.length == 1) {
            return this.values[0].m_6544_();
        }
        JsonArray jsonarray = new JsonArray();
        for (Value ingredient$value : this.values) {
            jsonarray.add((JsonElement)ingredient$value.m_6544_());
        }
        return jsonarray;
    }

    public boolean m_43947_() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    public boolean isSimple() {
        return true;
    }

    public static NcIngredient of(TagKey<Item> pTag) {
        return NcIngredient.fromValues(Stream.of(new TagValue(pTag, new int[0])));
    }

    public static NcIngredient fromValues(Stream<? extends Ingredient.Value> pStream) {
        NcIngredient ingredient = new NcIngredient(pStream);
        return ingredient.m_43947_() ? EMPTY : ingredient;
    }

    public static NcIngredient of() {
        return EMPTY;
    }

    public static NcIngredient of(ItemLike ... pItems) {
        return NcIngredient.stack(Arrays.stream(pItems).map(ItemStack::new));
    }

    public static NcIngredient stack(ItemStack ... pStacks) {
        return NcIngredient.stack(Arrays.stream(pStacks));
    }

    public static NcIngredient fromVals(Stream<? extends Value> pStream) {
        NcIngredient ingredient = new NcIngredient(pStream);
        return ingredient.values.length == 0 ? EMPTY : ingredient;
    }

    public static NcIngredient stack(Stream<ItemStack> pStacks) {
        return NcIngredient.fromVals(pStacks.filter(p_43944_ -> !p_43944_.m_41619_()).map(ItemValue::new));
    }

    public static NcIngredient of(TagKey<Item> pTag, int ... pCounts) {
        return NcIngredient.fromVals(Stream.of(new TagValue(pTag, pCounts))).withCount(pCounts);
    }

    public NcIngredient withCount(int[] pCounts) {
        if (pCounts.length == 0) {
            return this;
        }
        if (pCounts.length == 1) {
            this.count = pCounts[0];
        }
        return this;
    }

    public static interface Value
    extends Ingredient.Value {
        public String getName();
    }

    public static class TagValue
    implements Value {
        private final TagKey<Item> tag;
        private final int count;

        public TagValue(TagKey<Item> pTag, int ... pCount) {
            this.tag = pTag;
            this.count = pCount.length > 0 ? pCount[0] : 1;
        }

        @Override
        public String getName() {
            return this.tag.f_203868_().m_135815_().replace("/", "_");
        }

        public Collection<ItemStack> m_6223_() {
            ArrayList list = Lists.newArrayList();
            for (Item item : ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().toList()) {
                list.add(new ItemStack((ItemLike)item));
            }
            if (list.size() == 0) {
                list.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + this.tag.f_203868_()))));
            }
            return list;
        }

        public JsonObject m_6544_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            return jsonobject;
        }
    }

    public static class ItemValue
    implements Value {
        private final ItemStack item;

        @Override
        public String getName() {
            return this.item.m_41720_().toString();
        }

        public ItemValue(ItemStack pItem) {
            this.item = pItem;
        }

        public Collection<ItemStack> m_6223_() {
            return Collections.singleton(this.item);
        }

        public JsonObject m_6544_() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item.m_41720_()).toString());
            if (this.item.m_41782_()) {
                if (this.item.m_41783_().m_128441_("Damage") && this.item.m_41783_().m_128451_("Damage") == 0) {
                    this.item.m_41783_().m_128473_("Damage");
                }
                if (!this.item.m_41783_().m_128431_().isEmpty()) {
                    jsonobject.addProperty("nbt", this.item.m_41783_().toString());
                }
            }
            if (this.item.m_41613_() > 1) {
                jsonobject.addProperty("count", (Number)this.item.m_41613_());
            }
            return jsonobject;
        }
    }
}

