/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient.creator;

import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IIngredientCreator;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.util.TagUtil;
import igentuman.nc.util.annotation.NothingNullByDefault;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public interface IFluidStackIngredientCreator
extends IIngredientCreator<Fluid, FluidStack, FluidStackIngredient> {
    @Override
    default public FluidStackIngredient from(String name, int amount) {
        if (NCFluids.NC_MATERIALS.get(name) != null) {
            return this.from((Fluid)NCFluids.NC_MATERIALS.get(name).getStill(), amount);
        }
        if (NCFluids.ALL_FLUID_ENTRIES.get(name) != null) {
            return this.from((Fluid)NCFluids.ALL_FLUID_ENTRIES.get(name).getStill(), amount);
        }
        if (!name.contains(":")) {
            return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(new FluidStack(TagUtil.getFluidByName(name), amount));
        }
        return IngredientCreatorAccess.fluid().from(name, amount);
    }

    @Override
    default public FluidStackIngredient from(Fluid instance, int amount) {
        return (FluidStackIngredient)this.from(new FluidStack(instance, amount));
    }
}

