/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient.creator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.network.BasePacketHandler;
import igentuman.nc.recipes.ingredient.IMultiIngredient;
import igentuman.nc.recipes.ingredient.InputIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IItemStackIngredientCreator;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ItemStackIngredientCreator
implements IItemStackIngredientCreator {
    public static final ItemStackIngredientCreator INSTANCE = new ItemStackIngredientCreator();

    private ItemStackIngredientCreator() {
    }

    @Override
    public ItemStackIngredient from(Ingredient ingredient, int amount) {
        Objects.requireNonNull(ingredient, "ItemStackIngredients cannot be created from a null ingredient.");
        if (ingredient == Ingredient.f_43901_) {
            return new SingleItemStackIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42127_}), amount);
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("ItemStackIngredients must have an amount of at least one. Received size was: " + amount);
        }
        return new SingleItemStackIngredient(ingredient, amount);
    }

    @Override
    public ItemStackIngredient from(JsonElement instance) {
        return this.deserialize(instance);
    }

    @Override
    public ItemStackIngredient read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "ItemStackIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.m_130066_(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> this.from(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130242_());
            case IngredientType.MULTI -> this.createMulti(BasePacketHandler.readArray(buffer, ItemStackIngredient[]::new, this::read));
        };
    }

    @Override
    public ItemStackIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null.");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined.");
            }
            if (size > 1) {
                ItemStackIngredient[] ingredients = new ItemStackIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = this.deserialize(jsonArray.get(i));
                }
                return this.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects.");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        int amount = 1;
        if (jsonObject.has("count")) {
            JsonElement count = jsonObject.get("count");
            if (!GsonHelper.m_13872_((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number that is one or larger.");
            }
            amount = count.getAsJsonPrimitive().getAsInt();
            if (amount < 1) {
                throw new JsonSyntaxException("Expected amount to larger than or equal to one.");
            }
        }
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonObject);
        return this.from(ingredient, amount);
    }

    public ItemStackIngredient createMulti(ItemStackIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<ItemStackIngredient> cleanedIngredients = new ArrayList<ItemStackIngredient>();
        for (ItemStackIngredient ingredient : ingredients) {
            if (ingredient instanceof MultiItemStackIngredient) {
                MultiItemStackIngredient multi = (MultiItemStackIngredient)ingredient;
                Collections.addAll(cleanedIngredients, multi.ingredients);
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new MultiItemStackIngredient(cleanedIngredients.toArray(new ItemStackIngredient[0]));
    }

    @Override
    public ItemStackIngredient from(Stream<ItemStackIngredient> ingredients) {
        return this.createMulti((ItemStackIngredient[])ingredients.toArray(ItemStackIngredient[]::new));
    }

    @NothingNullByDefault
    public static class SingleItemStackIngredient
    extends ItemStackIngredient {
        private final Ingredient ingredient;

        private SingleItemStackIngredient(Ingredient ingredient, int amount) {
            this.ingredient = Objects.requireNonNull(ingredient);
            this.amount = amount;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.testType(stack) && stack.m_41613_() >= this.amount;
        }

        @Override
        public boolean testType(ItemStack stack) {
            return this.ingredient.test(stack);
        }

        @Override
        public ItemStack getMatchingInstance(ItemStack stack) {
            return this.test(stack) ? StackUtils.size(stack, this.amount) : ItemStack.f_41583_;
        }

        @Override
        public long getNeededAmount(ItemStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            ItemStack[] items = this.ingredient.m_43908_();
            if (items.length == 0) {
                return true;
            }
            if (items.length == 1) {
                LiteralContents contents;
                ComponentContents componentContents;
                ItemStack item = items[0];
                return item.m_41720_() == Items.f_42127_ && (componentContents = item.m_41786_().m_214077_()) instanceof LiteralContents && (contents = (LiteralContents)componentContents).f_237368_().startsWith("Empty Tag: ");
            }
            return false;
        }

        public List<String> getItemsByTagKey(String key) {
            ArrayList<String> tmp = new ArrayList<String>();
            TagKey tag = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NcUtils.rlFromString(key));
            Ingredient ing = Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(tag)));
            for (ItemStack item : ing.m_43908_()) {
                tmp.add(item.m_41720_().toString());
            }
            return tmp;
        }

        @Override
        public List<@NotNull ItemStack> getRepresentations() {
            ArrayList<@NotNull ItemStack> representations = new ArrayList<ItemStack>();
            for (ItemStack stack : this.ingredient.m_43908_()) {
                if (stack.m_41613_() == this.amount) {
                    representations.add(stack);
                    continue;
                }
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(this.amount);
                representations.add(copy);
            }
            return representations;
        }

        public Ingredient getInputRaw() {
            return this.ingredient;
        }

        public int getAmountRaw() {
            return this.amount;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.SINGLE);
            this.ingredient.m_43923_(buffer);
            buffer.m_130130_(this.amount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            if (this.amount > 1) {
                json.addProperty("count", (Number)this.amount);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            return json;
        }

        @Override
        public String getName() {
            return this.getRepresentations().get(0).m_41720_().toString();
        }

        @Override
        public int getAmount() {
            return this.amount;
        }
    }

    private static enum IngredientType {
        SINGLE,
        MULTI;

    }

    @NothingNullByDefault
    public static class MultiItemStackIngredient
    extends ItemStackIngredient
    implements IMultiIngredient<ItemStack, ItemStackIngredient> {
        private final ItemStackIngredient[] ingredients;

        private MultiItemStackIngredient(ItemStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(ItemStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public String getName() {
            return this.getRepresentations().get(0).m_41720_().toString();
        }

        @Override
        public int getAmount() {
            return this.getRepresentations().get(0).m_41613_();
        }

        @Override
        public boolean testType(ItemStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public ItemStack getMatchingInstance(ItemStack stack) {
            for (ItemStackIngredient ingredient : this.ingredients) {
                ItemStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.m_41619_()) continue;
                return matchingInstance;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public long getNeededAmount(ItemStack stack) {
            for (ItemStackIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return Arrays.stream(this.ingredients).allMatch(InputIngredient::hasNoMatchingInstances);
        }

        @Override
        public List<@NotNull ItemStack> getRepresentations() {
            ArrayList<@NotNull ItemStack> representations = new ArrayList<ItemStack>();
            for (ItemStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public boolean forEachIngredient(Predicate<ItemStackIngredient> checker) {
            boolean result = false;
            for (ItemStackIngredient ingredient : this.ingredients) {
                result |= checker.test(ingredient);
            }
            return result;
        }

        @Override
        public final List<ItemStackIngredient> getIngredients() {
            return List.of(this.ingredients);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.MULTI);
            BasePacketHandler.writeArray(buffer, this.ingredients, InputIngredient::write);
        }

        @Override
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (ItemStackIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.ingredients, ((MultiItemStackIngredient)o).ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }
}

