/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.content.ArmorMaterials;
import igentuman.nc.content.materials.Chunks;
import igentuman.nc.content.materials.Dusts;
import igentuman.nc.content.materials.Gems;
import igentuman.nc.content.materials.Ingots;
import igentuman.nc.content.materials.Nuggets;
import igentuman.nc.content.materials.Plates;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.item.BatteryItem;
import igentuman.nc.item.DosimiterItem;
import igentuman.nc.item.GeigerCounterItem;
import igentuman.nc.item.HEVItem;
import igentuman.nc.item.HazmatItem;
import igentuman.nc.item.MultitoolItem;
import igentuman.nc.item.MusicDiscItem;
import igentuman.nc.item.NCBGemItem;
import igentuman.nc.item.NCBlockItem;
import igentuman.nc.item.NCChunkItem;
import igentuman.nc.item.NCDustItem;
import igentuman.nc.item.NCIngotItem;
import igentuman.nc.item.NCNuggetItem;
import igentuman.nc.item.NCPlateItem;
import igentuman.nc.item.ParticleSourceItem;
import igentuman.nc.item.PaxelItem;
import igentuman.nc.item.QNP;
import igentuman.nc.item.RadAwayItem;
import igentuman.nc.item.RadShieldingItem;
import igentuman.nc.item.ResearchPaperItem;
import igentuman.nc.item.Tiers;
import igentuman.nc.item.UpgradeItem;
import igentuman.nc.setup.registration.Entities;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.RegistryObject;

public class NCItems {
    public static HashMap<String, RegistryObject<Item>> NC_FOOD = new HashMap();
    public static HashMap<String, RegistryObject<Item>> ALL_NC_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_RECORDS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_PARTS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> ION_SOURCES = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_SHIELDING = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_GEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_INGOTS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_CHUNKS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_NUGGETS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_PLATES = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_DUSTS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> ORE_BLOCK_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_BLOCKS_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_ELECTROMAGNETS_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_RF_AMPLIFIERS_ITEMS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> MULTIBLOCK_ITEMS = new HashMap();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties();
    public static final Item.Properties ONE_ITEM_PROPERTIES = new Item.Properties().m_41487_(1).setNoRepair();
    public static final Item.Properties THORIUM_PAXEL_PROPS = new Item.Properties().m_41487_(1).m_41503_(5000).m_41486_();
    public static final Item.Properties TOUGH_PAXEL_PROPS = new Item.Properties().m_41487_(1).m_41503_(9000).m_41486_();
    public static final Item.Properties HAZMAT_PROPS = new Item.Properties().m_41487_(1).m_41503_(250);
    public static final Item.Properties TOUGH_PROPS = new Item.Properties().m_41487_(1).m_41503_(2500).m_41486_();
    public static final Item.Properties HEV_PROPS = new Item.Properties().m_41487_(1).m_41503_(5500).m_41486_();
    public static final RegistryObject<Item> FERAL_GHOUL_SPAWN_EGG = Registries.ITEMS.register("feral_ghoul_spawn_egg", () -> new ForgeSpawnEggItem(Entities.FERAL_GHOUL, 8296064, 12964293, new Item.Properties()));
    public static final RegistryObject<Item> HAZMAT_MASK = Registries.ITEMS.register("hazmat_mask", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.HELMET, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_CHEST = Registries.ITEMS.register("hazmat_chest", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.CHESTPLATE, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_BOOTS = Registries.ITEMS.register("hazmat_boots", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.BOOTS, HAZMAT_PROPS));
    public static final RegistryObject<Item> HAZMAT_PANTS = Registries.ITEMS.register("hazmat_pants", () -> new HazmatItem(ArmorMaterials.HAZMAT, ArmorItem.Type.LEGGINGS, HAZMAT_PROPS));
    public static final RegistryObject<Item> HEV_HELMET = Registries.ITEMS.register("hev_helmet", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.HELMET, HEV_PROPS));
    public static final RegistryObject<Item> HEV_CHEST = Registries.ITEMS.register("hev_chest", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.CHESTPLATE, HEV_PROPS));
    public static final RegistryObject<Item> HEV_BOOTS = Registries.ITEMS.register("hev_boots", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.BOOTS, HEV_PROPS));
    public static final RegistryObject<Item> HEV_PANTS = Registries.ITEMS.register("hev_pants", () -> new HEVItem(ArmorMaterials.HEV, ArmorItem.Type.LEGGINGS, HEV_PROPS));
    public static final RegistryObject<Item> TOUGH_HELMET = Registries.ITEMS.register("tough_helmet", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.HELMET, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_CHEST = Registries.ITEMS.register("tough_chest", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.CHESTPLATE, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_BOOTS = Registries.ITEMS.register("tough_boots", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.BOOTS, TOUGH_PROPS));
    public static final RegistryObject<Item> TOUGH_PANTS = Registries.ITEMS.register("tough_pants", () -> new ArmorItem((ArmorMaterial)ArmorMaterials.TOUGH, ArmorItem.Type.LEGGINGS, TOUGH_PROPS));
    public static final RegistryObject<Item> GEIGER_COUNTER = Registries.ITEMS.register("geiger_counter", () -> new GeigerCounterItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> LITHIUM_ION_CELL = Registries.ITEMS.register("lithium_ion_cell", () -> new BatteryItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> SPAXELHOE_TOUGH = Registries.ITEMS.register("spaxelhoe_tough", () -> new PaxelItem(7.0f, 2.0f, Tiers.TOUGH, TOUGH_PAXEL_PROPS));
    public static final RegistryObject<Item> SPAXELHOE_THORIUM = Registries.ITEMS.register("spaxelhoe_thorium", () -> new PaxelItem(3.0f, 1.0f, Tiers.THORIUM, THORIUM_PAXEL_PROPS));
    public static final RegistryObject<Item> QNP = Registries.ITEMS.register("qnp", () -> new QNP(Tiers.QNP, 11, 2.0f, ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> MULTITOOL = Registries.ITEMS.register("multitool", () -> new MultitoolItem(ONE_ITEM_PROPERTIES));
    public static final RegistryObject<Item> UNKNOWN_INGREDIENT = Registries.ITEMS.register("unknown_ingredient", () -> new Item(ONE_ITEM_PROPERTIES));
    public static final TagKey<Item> AMPLIFIERS_ITEMS = Tags.itemTag("amplifiers");
    public static final TagKey<Item> ELECTROMAGNETS_ITEMS = Tags.itemTag("electromagnets");

    public static RegistryObject<Item> registerItem(String name) {
        return Registries.ITEMS.register(name, () -> new Item(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerIngot(String name) {
        return Registries.ITEMS.register(name, () -> new NCIngotItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerChunk(String name) {
        return Registries.ITEMS.register(name, () -> new NCChunkItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerNugget(String name) {
        return Registries.ITEMS.register(name, () -> new NCNuggetItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerPlate(String name) {
        return Registries.ITEMS.register(name, () -> new NCPlateItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerDust(String name) {
        return Registries.ITEMS.register(name, () -> new NCDustItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerGem(String name) {
        return Registries.ITEMS.register(name, () -> new NCBGemItem(ITEM_PROPERTIES));
    }

    public static RegistryObject<Item> registerBlockItem(String name) {
        return Registries.ITEMS.register(name, () -> new NCBlockItem(ITEM_PROPERTIES));
    }

    public static void init() {
        NCItems.registerChunks();
        NCItems.registerNuggets();
        NCItems.registerIngots();
        NCItems.registerPlates();
        NCItems.registerDusts();
        NCItems.registerGems();
        NCItems.registerParts();
        NCItems.registerItems();
        NCItems.registerFood();
        NCItems.registerRecords();
        NCItems.registerShielding();
        NCItems.registerParticleSources();
    }

    private static void registerParticleSources() {
        for (String name : ParticleSources.sources.keySet()) {
            ION_SOURCES.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new ParticleSourceItem(new Item.Properties().m_41487_(1))));
            ALL_NC_ITEMS.put(name, ION_SOURCES.get(name));
            Tags.ION_SOURCE_TAG.put(name, Tags.itemTag("ion_sources/" + name.replace("source_", "")));
        }
    }

    private static void registerRecords() {
        List<String> items = Arrays.asList("end_of_the_world", "hyperspace", "money_for_nothing", "wanderer");
        for (String name : items) {
            NC_RECORDS.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new MusicDiscItem(15, (Supplier)NCSounds.SOUND_MAP.get(name), new Item.Properties(), 3600)));
            ALL_NC_ITEMS.put(name, NC_RECORDS.get(name));
        }
    }

    private static void registerFood() {
        List<String> items = Arrays.asList("marshmallow", "milk_chocolate", "dark_chocolate", "graham_cracker", "smore", "moresmore", "foursmore", "dominos", "evenmoresmore");
        int i = -18;
        for (String name : items) {
            int finalI = Math.max(i += 4, 1);
            NC_FOOD.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(finalI).m_38758_((float)finalI).m_38767_()))));
            ALL_NC_ITEMS.put(name, NC_FOOD.get(name));
        }
        for (String name : List.of("rad_x", "radaway", "radaway_slow")) {
            NC_FOOD.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new RadAwayItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()))));
            ALL_NC_ITEMS.put(name, NC_FOOD.get(name));
        }
    }

    private static void registerUpgrades() {
        List<String> items = Arrays.asList("upgrade_energy", "upgrade_speed", "upgrade_stack");
        for (String name : items) {
            NC_ITEMS.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new UpgradeItem(ITEM_PROPERTIES)));
            ALL_NC_ITEMS.put(name, NC_ITEMS.get(name));
        }
    }

    private static void registerItems() {
        List<String> items = Arrays.asList("cocoa_butter", "cocoa_solids", "roasted_cocoa_beans", "flour", "gelatin", "ground_cocoa_nibs", "salt", "sawdust", "dosimeter", "water_collector", "lava_collector", "compact_water_collector", "dense_water_collector", "helium_collector", "compact_helium_collector", "dense_helium_collector", "nitrogen_collector", "compact_nitrogen_collector", "dense_nitrogen_collector", "unsweetened_chocolate");
        for (String name : items) {
            if (name.equals("dosimeter")) {
                NC_ITEMS.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new DosimiterItem(ONE_ITEM_PROPERTIES)));
            } else {
                NC_ITEMS.put(name, NCItems.registerItem(name));
            }
            ALL_NC_ITEMS.put(name, NC_ITEMS.get(name));
        }
        Tags.DUSTS_TAG.put("salt", Tags.forgeDust("salt"));
        Tags.DUSTS_TAG.put("sodium_chloride", Tags.forgeDust("sodium_chloride"));
        NCItems.registerUpgrades();
    }

    private static void registerShielding() {
        List<String> parts = Arrays.asList("light", "medium", "heavy", "dps");
        int i = 1;
        for (String name : parts) {
            int finalI = i;
            NC_SHIELDING.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new RadShieldingItem(ITEM_PROPERTIES, finalI)));
            i += 2;
            ALL_NC_ITEMS.put(name, NC_SHIELDING.get(name));
        }
    }

    private static void registerParts() {
        List<String> parts = Arrays.asList("actuator", "research_paper", "basic_electric_circuit", "bioplastic", "chassis", "empty_frame", "empty_sink", "motor", "plate_advanced", "plate_basic", "plate_du", "plate_elite", "plate_extreme", "servo", "sic_fiber", "steel_frame", "coil_copper", "coil_magnesium_diboride", "coil_bscco", "advanced_processor", "basic_processor", "elite_processor", "silicon_boule", "silicon_n_doped", "silicon_p_doped", "silicon_wafer", "empty_detector", "wire_chamber_casing", "scintillator_pwo", "scintillator_plastic", "laser_assembly", "wire_gold_tungsten");
        for (String name : parts) {
            if (name.equals("research_paper")) {
                NC_PARTS.put(name, (RegistryObject<Item>)Registries.ITEMS.register(name, () -> new ResearchPaperItem(ONE_ITEM_PROPERTIES)));
            } else {
                NC_PARTS.put(name, NCItems.registerItem(name));
            }
            ALL_NC_ITEMS.put(name, NC_PARTS.get(name));
        }
    }

    private static void registerGems() {
        for (String name : Gems.get().all().keySet()) {
            Tags.addGemTag(name);
            NC_GEMS.put(name, NCItems.registerGem(name + "_gem"));
            ALL_NC_ITEMS.put(name + "_gem", NC_GEMS.get(name));
        }
    }

    private static void registerChunks() {
        for (String name : Chunks.get().all().keySet()) {
            Tags.addChunkTag(name);
            NC_CHUNKS.put(name, NCItems.registerChunk(name + "_chunk"));
            ALL_NC_ITEMS.put(name + "_chunk", NC_CHUNKS.get(name));
        }
    }

    private static void registerNuggets() {
        for (String name : Nuggets.get().all().keySet()) {
            Tags.addNuggetTag(name);
            NC_NUGGETS.put(name, NCItems.registerNugget(name + "_nugget"));
            ALL_NC_ITEMS.put(name + "_nugget", NC_NUGGETS.get(name));
        }
    }

    private static void registerIngots() {
        for (String name : Ingots.get().all().keySet()) {
            Tags.addIngotTag(name);
            NC_INGOTS.put(name, NCItems.registerIngot(name + "_ingot"));
            ALL_NC_ITEMS.put(name + "_ingot", NC_INGOTS.get(name));
        }
    }

    private static void registerPlates() {
        for (String name : Plates.get().all().keySet()) {
            Tags.addPlateTag(name);
            NC_PLATES.put(name, NCItems.registerPlate(name + "_plate"));
            ALL_NC_ITEMS.put(name + "_plate", NC_PLATES.get(name));
        }
    }

    private static void registerDusts() {
        for (String name : Dusts.get().all().keySet()) {
            Tags.addDustTag(name);
            NC_DUSTS.put(name, NCItems.registerDust(name + "_dust"));
            ALL_NC_ITEMS.put(name + "_dust", NC_DUSTS.get(name));
        }
    }
}

