/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import com.mojang.serialization.Codec;
import igentuman.nc.NuclearCraft;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.world.BiomeFilterNether;
import igentuman.nc.world.OrePlacementModifier;
import igentuman.nc.world.structure.WastelandBossLairFeature;
import igentuman.nc.world.structure.WastelandPortalFeature;
import igentuman.nc.world.structure.WastelandStructureFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WorldGeneration {
    public static final TagKey<Biome> WASTELAND = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)NuclearCraft.rl("wasteland"));
    public static final ResourceKey<Biome> WASTELAND_BIOME = WorldGeneration.makeKey("wasteland");
    public static final RegistryObject<PlacementModifierType<?>> NC_ORE_MODIFIER = Registries.PLACEMENT_MODIFIERS.register("nc_ore_modifier", () -> WorldGeneration.placement(OrePlacementModifier.CODEC));
    public static final RegistryObject<PlacementModifierType<?>> VEGETATION_MODIFIER = Registries.PLACEMENT_MODIFIERS.register("nc_vegetation_modifier", () -> WorldGeneration.placement(BiomeFilterNether.CODEC));

    private static ResourceKey<Biome> makeKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256952_, (ResourceLocation)NuclearCraft.rl(name));
    }

    public static <P extends PlacementModifier> PlacementModifierType<P> placement(Codec<P> codec) {
        return () -> codec;
    }

    public static void init() {
        WastelandStructureFeature.init();
        WastelandPortalFeature.init();
        WastelandBossLairFeature.init();
    }

    public static class StructurePlacer {
        public static void placeStructure(ServerLevel level, BlockPos pos, String name) {
            ResourceLocation structureLocation = NuclearCraft.rl(name);
            StructureTemplate template = StructureLoader.loadStructure(level, structureLocation);
            if (template == null) {
                System.out.println("Structure not found: " + structureLocation);
                return;
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false);
            template.m_230328_((ServerLevelAccessor)level, pos, pos, settings, level.f_46441_, 2);
        }
    }

    public static class StructureLoader {
        public static StructureTemplate loadStructure(ServerLevel level, ResourceLocation structureLocation) {
            StructureTemplateManager manager = level.m_215082_();
            return manager.m_230407_(structureLocation).orElse(null);
        }
    }
}

