/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.config.AcceleratorConfig;

public class Equations {
    public static double focusLoss(double distance, ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return (Double)AcceleratorConfig.ACCELERATOR_CONFIG.BEAM_ATTENUATION_RATE.get() * distance * (1.0 + Math.abs(particle.getCharge()) * Math.sqrt((double)stack.getAmount() / (Double)AcceleratorConfig.ACCELERATOR_CONFIG.BEAM_SCALING.get()));
        }
        return 0.0;
    }

    public static double travelDistance(ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return stack.getFocus() / Equations.focusLoss(1.0, stack);
        }
        return 0.0;
    }

    public static double focusGain(double quadrupoleStrength, ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return quadrupoleStrength * Math.abs(particle.getCharge());
        }
        return 0.0;
    }

    public static long linacEnergyGain(long cavityVoltage, ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return (long)((double)cavityVoltage * Math.abs(particle.getCharge())) / 1000L;
        }
        return 0L;
    }

    public static long ringEnergyMaxEnergyFromDipole(double dipoleStrength, double radius, double charge, double mass) {
        return (long)(Math.pow(charge * dipoleStrength * radius, 2.0) / (2.0 * mass) * 1000000.0);
    }

    public static long ringEnergyMaxEnergyFromRadiation(long cavityVoltage, double radius, double charge, double mass) {
        return (long)(mass * Math.pow((double)(3L * cavityVoltage) * radius / Math.abs(charge), 0.25) * 1000000.0);
    }

    public static long ringEnergyMaxEnergy(double dipoleStrength, long cavityVoltage, double radius, ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return Math.min(Equations.ringEnergyMaxEnergyFromDipole(dipoleStrength, radius, particle.getCharge(), particle.getMass()), Equations.ringEnergyMaxEnergyFromRadiation(cavityVoltage, radius, particle.getCharge(), particle.getMass()));
        }
        return 0L;
    }

    public static long synchrotronRadiationEnergy(double radius, ParticleStack stack) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return (long)(Math.pow((double)stack.getMeanEnergy() / (1000.0 * particle.getMass()), 3.0) / (6283185.307179586 * radius));
        }
        return 0L;
    }

    public static long cornerEnergyLoss(ParticleStack stack, double radius) {
        if (stack != null) {
            Particle particle = stack.getParticle();
            return (long)((double)stack.getMeanEnergy() * Math.pow(particle.getCharge(), 2.0) / (6.0 * Math.pow(particle.getMass(), 4.0) * Math.pow(radius, 2.0)));
        }
        return 0L;
    }

    public static long collisionEnergy(long energy1, long energy2) {
        return (long)(2.0 * Math.sqrt(energy1 * energy2));
    }

    public static long particleOutputAmount(long inputAmount, long recipeAmount, double crossSection, double efficency) {
        return (long)((double)(inputAmount * recipeAmount) * Math.min(crossSection * efficency, 1.0));
    }

    public static long particleOutputAmountCollisionChamber(long inputAmount1, long inputAmount2, long energy1, long energy2, long recipeAmount, double crossSection, double efficency) {
        return (long)((double)(recipeAmount * Math.min(inputAmount1, inputAmount2)) * Math.min(crossSection * efficency * (double)(1L - Math.abs(energy1 - energy2) / (energy1 + energy2)), 1.0));
    }

    public static long particleOutputEnergy(long inputEnergy, long recipeQ, long particleNumber) {
        return (inputEnergy + recipeQ) / particleNumber;
    }
}

